#!/bin/sh
#
# Detail form for a serial port. You must supply the following two CGI parameters:
#  DEVNODE - The device node for the port (eg. /dev/ttyS1)
#  DEVNAME - The friendly name for the port (eg. COM1)

if [ -z  "${SESSION_ID}" -o "${SESSION_ID}" != "${sessionid}" ]; then
	exit 0
fi

pick() {
	shift $1
	echo $1
}

MESSAGE=""

# Add to message box. Appears at end of page or on stdout during nocgi.
madd() {
	N=`echo $@`
	MESSAGE="${MESSAGE}
$N"
}

# Emit a CGI line. Becomes a no-op in case of nocgi.
emit() {
	if [ -z "$NOCGI" ]; then echo $@; fi
}

emit -e 'Content-type: text/html\n'
emit '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'
emit '<html xmlns="http://www.w3.org/1999/xhtml">'
emit '<head>'
emit '  <meta http-equiv="Pragma" content="no-cache">'
emit '  <meta http-equiv="Expires" content="-1">'
emit '  <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">'
emit '  <title>PAD Daemon Serial Port</title>'
if [ -e /www/cdcs.css ]; then
emit '  <link href="/cdcs.css" rel="stylesheet" type="text/css" />'
elif [ -e /www/linkFiles/790.css ]; then
echo '  <link href="/linkFiles/790.css" rel="stylesheet" type="text/css" />'
elif [ -e /www/BovineStyle.css ]; then
echo '  <link href="/BovineStyle.css" rel="stylesheet" type="text/css" />'
fi
emit '</head>'
emit '<body>'

# splits CGI query into var="value" strings
cgi_split() {
	echo "$1" | awk 'BEGIN{
		hex["0"] =  0; hex["1"] =  1; hex["2"] =  2; hex["3"] =  3;
		hex["4"] =  4; hex["5"] =  5; hex["6"] =  6; hex["7"] =  7;
		hex["8"] =  8; hex["9"] =  9; hex["A"] = 10; hex["B"] = 11;
		hex["C"] = 12; hex["D"] = 13; hex["E"] = 14; hex["F"] = 15;
	}
	{
		n=split ($0,EnvString,"&");
		for (i = n; i>0; i--) {
			z = EnvString[i];
			x=gsub(/\=/,"=\"",z);
			x=gsub(/\+/," ",z);
			while(match(z, /%../)){
				if(RSTART > 1)
					printf "%s", substr(z, 1, RSTART-1)
				printf "%c", hex[substr(z, RSTART+1, 1)] * 16 + hex[substr(z, RSTART+2, 1)]
				z = substr(z, RSTART+RLENGTH)
			}
			x=gsub(/$/,"\"",z);
			print z;
		}
	}'
}

qlist=`cgi_split "$QUERY_STRING"`

split() {
	shift $1
	echo "$1"
}

# Get the device node and name (but don't get any other params yet!)
for V in $qlist; do
	VAR="PADD_$V"
	SEP=`echo "$VAR" | tr '=' ' '`
	NAME=`split 1 $SEP`
	VAL=`split 2 $SEP`
	if [ $NAME = "PADD_DEVNAME" ]; then
		eval $VAR
	fi
	if [ $NAME = "PADD_DEVNODE" ]; then
		eval $VAR
	fi
	if [ $NAME = "PADD_IFRAME" ]; then
		eval $VAR
	fi
done

override_enable_by_rdb() {
	# override padd enable flag if rdb padd enable flag exists
	RDB_PADD_ENABLE=`rdb_get confv250.padd_enable 2> /dev/null`
	if [ -n "$RDB_PADD_ENABLE" ]; then
		PADD_ENABLE="$RDB_PADD_ENABLE"
	fi
}

# Load default settings
. /etc/cdcs/padd_settings_default.sh $PADD_DEVNODE

SFILE="/etc/cdcs/padd_settings_$PADD_DEVNAME.sh"

if [ ! -f "$SFILE" ]; then
	touch "$SFILE"
fi
. "$SFILE";

override_enable_by_rdb

# See if there are any changes sent via CGI.
CHANGED=""
for V in $qlist; do
	VAR="PADD_$V"
	SEP=`echo "$VAR" | tr '=' ' '`
	NAME=`split 1 $SEP`
	VAL=`split 2 $SEP`
	eval "OVAL=\"\\\"\$$NAME\\\"\""
	if [ "$OVAL" != "$VAL" ]; then
		CHANGED="yes"
	fi
	eval $VAR
done

if [ "$PADD_IFRAME" != "y" ]; then
	emit '<div id="contentWrapper-2">'
	emit "<h2>PAD Daemon Settings for $PADD_DEVNAME</h2>"
	emit '<a href="/">Return</a>'
	emit '<div class="line" style="margin: 8px 25% 16px 0;"></div>'
fi

# Save settings (only in cgi mode)
if [ -n "$CHANGED" ]; then
	madd "writing $SFILE"
	echo "# Maintained by padd.cgi" >"$SFILE"
	echo "PADD_ENABLE=\"$PADD_ENABLE\"" >>"$SFILE"
	echo "PADD_DLEVEL=\"$PADD_DLEVEL\"" >>"$SFILE"

	echo "PADD_BAUD=\"$PADD_BAUD\"" >>"$SFILE"
	echo "PADD_BITS=\"$PADD_BITS\"" >>"$SFILE"
	echo "PADD_STOPB=\"$PADD_STOPB\"" >>"$SFILE"
	echo "PADD_PAR=\"$PADD_PAR\"" >>"$SFILE"
	echo "PADD_HWFC=\"$PADD_HWFC\"" >>"$SFILE"
	echo "PADD_TO=\"$PADD_TO\"" >>"$SFILE"
	echo "PADD_EOL=\"$PADD_EOL\"" >>"$SFILE"
	echo "PADD_TS=\"$PADD_TS\"" >>"$SFILE"

	echo "PADD_PORT=\"$PADD_PORT\"" >>"$SFILE"
	echo "PADD_EXCLUSIVE=\"$PADD_EXCLUSIVE\"" >>"$SFILE"

	echo "PADD_MODE=\"$PADD_MODE\"" >> "$SFILE"
	echo "PADD_PROTO=\"$PADD_PROTO\"" >> "$SFILE"
	echo "PADD_SERVER0=\"$PADD_SERVER0\"" >>"$SFILE"
	echo "PADD_SERVER1=\"$PADD_SERVER1\"" >>"$SFILE"
	echo "PADD_SERVER2=\"$PADD_SERVER2\"" >>"$SFILE"
	echo "PADD_SERVER3=\"$PADD_SERVER3\"" >>"$SFILE"

	echo "PADD_RETRTIME=\"$PADD_RETRTIME\"" >>"$SFILE"
	echo "PADD_TCPKA=\"$PADD_TCPKA\"" >>"$SFILE"
	echo "PADD_TCPKAC=\"$PADD_TCPKAC\"" >>"$SFILE"
fi

# Firewall manipulation if the platform supports it
# $1=del|add, $2=port
firewall() {
	P=`which fw_open_port.sh`
	if [ -z "$P" ]; then
		madd "[no FW]"
		return
	fi
	madd "[fw $1 $2]"
	$P $1 $2
}

# Start or stop the daemon as required.
if [ -n "$CHANGED" ]; then
	if [ "$PADD_IFRAME" = "y" ]; then
		if [ "$PADD_ENABLE" = "1" ]; then
			rdb_set "confv250.padd_enable" 1 2>/dev/null
		else
			rdb_set "confv250.padd_enable" 0 2>/dev/null
		fi
		sleep 3
	fi

	if [ $PADD_ENABLE = 1 ]; then
		firewall del $PORT      # Close port if it was open
		firewall add $PADD_PORT  # Open new port
		OP=RESTART
	else
		# Close firewall hole
		firewall del $PADD_PORT # Close port
		OP=STOP
	fi
	madd `paddrestart.sh $PADD_DEVNODE $PADD_DEVNAME $OP 2> /dev/null`
fi

STATUSFILE="/tmp/padd.stat"
LINE=`cat /tmp/padd.stat 2>/dev/null`
if [ -n "$LINE" ]; then
	S_CL=`pick 1 $LINE`
	S_S0=`pick 2 $LINE`
	S_S1=`pick 3 $LINE`
	S_S2=`pick 4 $LINE`
	S_S3=`pick 5 $LINE`
else
	S_CL=0
	S_S0=0
	S_S1=0
	S_S2=0
	S_S3=0
fi

# Displays connection status as a colored space
# $1 is status [012]
status() {
	echo -n '&nbsp;<font face="monospace" style="background:'
	case "$1" in
	'0')	echo -n '#000000">&nbsp</font>'; ;;
	'1')	echo -n '#FF0000">X</font>'; ;;
	'2')	echo -n '#00FF00">V</font>'; ;;
	*)	echo -n '#FFFF00">?</font>'; ;;
	esac
}

# Assemble Form
echo '<form action="/cgi-bin/paddport.cgi" method=get>'
echo "<input type=\"hidden\" name=\"DEVNODE\" value=\"$PADD_DEVNODE\" />"
echo "<input type=\"hidden\" name=\"DEVNAME\" value=\"$PADD_DEVNAME\" />"
echo "<input type=\"hidden\" name=\"IFRAME\" value=\"$PADD_IFRAME\" />"

echo '<table width="75%">'
echo "   <tr><th>Daemon for serial port $PADD_DEVNAME</th></tr>"
echo '</table>'
echo '<table width="75%">'
echo '  <tr>'
echo '    <td width="30%">PAD Daemon</td>'
echo '    <td>'
if [ "$PADD_ENABLE" = "1" ]; then
echo '      <input type=radio name=ENABLE value=1 checked>&nbsp;Enable &nbsp;&nbsp;'
echo '      <input type=radio name=ENABLE value=0>&nbsp;Disable'
else
echo '      <input type=radio name=ENABLE value=1>&nbsp;Enable &nbsp;&nbsp;'
echo '      <input type=radio name=ENABLE value=0 checked>&nbsp;Disable'
fi

echo '<p></p>'                                                                      
echo '<p>(PAD Mode in WWAN (3G) Connection will be disable when PADD is Enable)</p>'

echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Debug Level</td>'
echo '    <td>'
echo "      <input type=text name=DLEVEL size=6 maxLength=1 value=\"$PADD_DLEVEL\">&nbsp;( 0 - 2 )"
echo '    </td>'
echo '  </tr>'
echo '</table>'
echo '<table width="75%">'
echo '  <tr><th>UART</th></tr>'
echo '</table>'
echo '<table width="75%">'
echo '  <tr>'
echo '    <td width="30%">Baud Rate</td>'
echo '    <td>'
echo "      <input type=text name=BAUD size=6 maxLength=6 value=\"$PADD_BAUD\">&nbsp;( 300, 600, ..., 115200 )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Data Bits</td>'
echo '    <td>'
echo "      <input type=text name=BITS size=6 maxLength=1 value=\"$PADD_BITS\">&nbsp;( 5 - 8 )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Stop Bits</td>'
echo '    <td>'
echo "      <input type=text name=STOPB size=6 maxLength=1 value=\"$PADD_STOPB\">&nbsp;( 1 - 2 )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Parity</td>'
echo '    <td>'
echo "      <input type=text name=PAR size=6 maxLength=6 value=\"$PADD_PAR\">&nbsp;( none, odd, even )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Hardware Flow Control</td>'
echo '    <td>'
echo "      <input type=text name=HWFC size=6 maxLength=1 value=\"$PADD_HWFC\">&nbsp;( 0, 1 )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Inter-character Timeout</td>'
echo '    <td>'
echo "      <input type=text name=TO size=6 maxLength=3 value=\"$PADD_TO\">&nbsp;( x100ms )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>End-of-line character</td>'
echo '    <td>'
echo "      <input type=text name=EOL size=6 maxLength=4 value=\"$PADD_EOL\">&nbsp;( ASCII code )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Start of line timestamps</td>'
echo '    <td>'
echo "      <input type=text name=TS size=6 maxLength=4 value=\"$PADD_TS\">&nbsp;( 0=off, 1=\"YYYYMMDDHHMMSS \"  )"
echo '    </td>'
echo '  </tr>'
echo '</table>'

echo '<table width="75%">'
echo '  <tr><th>TCP/IP Server</th></tr>'
echo '</table>'
echo '<table width="75%">'
echo '  <tr>'
echo '    <td width="30%">Server Mode Port</td>'
echo '    <td>'
echo "      <input type=text name=PORT size=6 maxLength=5 value=\"$PADD_PORT\">`status $S_CL`&nbsp;( TCP port number )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Incoming connection is</td>'
echo '    <td>'
if [ $PADD_EXCLUSIVE = 1 ]; then
	echo '      <input type=radio name=EXCLUSIVE value=1 checked>&nbsp;Exclusive &nbsp;&nbsp;'
	echo '      <input type=radio name=EXCLUSIVE value=0>&nbsp;Shared'
else
	echo '      <input type=radio name=EXCLUSIVE value=1>&nbsp;Exclusive &nbsp;&nbsp;'
	echo '      <input type=radio name=EXCLUSIVE value=0 checked>&nbsp;Shared'
fi
echo '</td></tr>'
echo '</table>'

echo '<table width="75%">'
echo '  <tr><th>TCP/IP Client</th></tr>'
echo '</table>'
echo '<table width="75%">'
echo '  <tr>'
echo '    <td width="30%">Mode</td>'
echo '    <td>'
if [ "$PADD_MODE" = "one" ]; then
	echo '      <input type=radio name=MODE value=one checked>&nbsp;First available &nbsp;&nbsp;'
	echo '      <input type=radio name=MODE value=all>&nbsp;All available'
else
	echo '      <input type=radio name=MODE value=one>&nbsp;First available &nbsp;&nbsp;'
	echo '      <input type=radio name=MODE value=all checked>&nbsp;All available'
fi
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td width="30%">Prototcol</td>'
echo '    <td>'
if [ "$PADD_PROTO" = "udp" ]; then
	echo '      <input type=radio name=PROTO value=tcp>&nbsp;TCP&nbsp;&nbsp;'
	echo '      <input type=radio name=PROTO value=udp checked>&nbsp;UDP'
else
	echo '      <input type=radio name=PROTO value=tcp checked>&nbsp;TCP&nbsp;&nbsp;'
	echo '      <input type=radio name=PROTO value=udp>&nbsp;UDP'
fi
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Remote Servers</td>'
echo '    <td>'
echo "      <input type=text name=SERVER0 size=24 maxLength=128 value=\"$PADD_SERVER0\">`status $S_S0`&nbsp;( server:port )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td></td>'
echo '    <td>'
echo "      <input type=text name=SERVER1 size=24 maxLength=128 value=\"$PADD_SERVER1\">`status $S_S1`&nbsp;( server:port )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td></td>'
echo '    <td>'
echo "      <input type=text name=SERVER2 size=24 maxLength=128 value=\"$PADD_SERVER2\">`status $S_S2`&nbsp;( server:port )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td></td>'
echo '    <td>'
echo "      <input type=text name=SERVER3 size=24 maxLength=128 value=\"$PADD_SERVER3\">`status $S_S3`&nbsp;( server:port )"
echo '    </td>'
echo '  </tr>'
echo '</table>'

echo '<table width="75%">'
echo '  <tr><th>Network</th></tr>'
echo '</table>'
echo '<table width="75%">'
echo '  <tr>'
echo '    <td width="30%">Remote Server Retry Period</td>'
echo '    <td>'
echo "      <input type=text name=RETRTIME size=6 maxLength=5 value=\"$PADD_RETRTIME\">&nbsp;( seconds )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>TCP Keepalive Probes</td>'
echo '    <td>'
echo "      <input type=text name=TCPKA size=6 maxLength=5 value=\"$PADD_TCPKA\">&nbsp;( seconds )"
echo '    </td>'
echo '  </tr>'
echo '  <tr>'
echo '    <td>Number of probe failures before disconnect</td>'
echo '    <td>'
echo "      <input type=text name=TCPKAC size=6 maxLength=5 value=\"$PADD_TCPKAC\">&nbsp;( 1 - 20 )"
echo '    </td>'
echo '  </tr>'
echo '</table>'

echo '<div align="right" style="margin-right:25% ">'
echo '<p></p>'
echo '<input type=submit value=Save></input>'
echo '</div>'

echo '</form>'

echo "<p></p><p></p><pre>"
echo -n "$MESSAGE"
echo "</pre>"

echo '</body>'
echo '</html>'

