function SOAPAction() {
    this._xml = null;
    this._dict = {};
}
SOAPAction.prototype.sendAction = function (action, d, r, list_enc, list_dec) {
    var xml = new StringDoc();
    var lock = $.Deferred();

    if (d != undefined && typeof d == "object") {
        try {
            var data = $.extend({}, d);
            if (list_enc != undefined) {
                list_enc.forEach(function (v) {
                    if (v in d) data[v] = AES_Encrypt128(data[v]);
                })
            }
            xml.XDoc = JSON.stringify(data);
        } catch (error) {
            console.log(error);
        }
    }

    var callbackFunc = function (res) {
        var result = res[action + "Response"];
        if (result != null && result[action + "Result"] != undefined) {
            var res = (r != undefined && typeof r == "object") ? r : {};
            $.extend(res, result);
            if (result[action + "Result"] == "OK") {
                try {
                    if (list_dec != undefined) {
                        list_dec.forEach(function (v) {
                            if (v in res) res[v] = AES_Decrypt128(res[v]);
                        })
                    }
                } catch (error) {
                    console.log(error);
                }

                lock.resolve(res);
            } else {
                lock.reject(res);
            }
        }
        lock.reject();
    };

    $.ajax({
        url: "./WEBCGI/" + action,
        // data: xml,
        dataType:"jsonp",
        crossDomain: true,
        jsonpCallback: "JsonP",
        success: callbackFunc,
        error: function(){lock.reject();}
    })

    if(window.__pageonloadding_timer)clearTimeout(window.__pageonloadding_timer);
    return lock.promise().always(function(){
        if(window.__pageonloadding){
            window.__pageonloadding_timer = setTimeout(function(){
                window.__pageonloadding=false;
                $(".content-wrapper.contentonload").removeClass("contentonload");
                $(".content-wrapper > .spinner-grow").remove();
                refreshSelect2();
            }, 80);
        }
    })
}
SOAPAction.prototype.setMultiAction = function (action, d, r, list_enc, list_dec) {
    if (this._xml == null) this._xml = new StringDoc(JSON.stringify({
        GetMultipleWEBCGIs: ""
    }));

    var data = null;
    if (d != undefined && typeof d == "object") {
        try {
            data = $.extend({}, d);
            if (list_enc != undefined) {
                list_enc.forEach(function (v) {
                    if (v in data) data[v] = AES_Encrypt128(data[v]);
                })
            }
        } catch (error) {
            console.log(error);
        }
    }

    var res = (r != undefined && typeof r == "object") ? r : {};
    this._xml.Set("GetMultipleWEBCGIs/" + action, data);
    this._dict[action] = [data, res, list_dec];
}
function SOAPSendList(l, m, n) {
	this._defer = $.Deferred();
	this._soap = new SOAPAction();

	this._list = (l instanceof Array && l.length > 0) ? l : [];
	this._maxTryTimes = (typeof m == "number" && m > 0) ? m : 0;
	this._maxOneTryTimes = (typeof n == "number" && n > 0) ? n : this._maxTryTimes;

	this._failCount = 0;
	this._continuousFailCount = 0;
	this._lastFail = false;
	this._currSoapObj = null;

	if (typeof SOAPSendList._initialized == "undefined") {
		SOAPSendList.prototype.Push = function (url, d, r, e, c) {
			this._list.push([url, d, r, e, c])
		}
		SOAPSendList.prototype.Run = function () {
			if (this._list.length == 0) {
				this._defer.resolve();
				return;
			}

			if (!this._lastFail || (this._failCount > this._maxTryTimes || this._continuousFailCount > this._maxOneTryTimes))
				this._currSoapObj = this._list.shift(),this._continuousFailCount = 0;
			else
				console.log("Try agin: " + this._currSoapObj[0]);


			var obj = this,
				soapObj = this._currSoapObj;
			this._soap.sendAction(soapObj[0], soapObj[1], soapObj[2], null, soapObj[3]).then(function () {
				obj._lastFail = false;
				obj._continuousFailCount = 0;
			}, function () {
				obj._lastFail = true;
				obj._continuousFailCount++;
				obj._failCount++;
			}).then(function () {
				obj.Run();
			})
		}
		SOAPSendList._initialized = true;
	}
}
SOAPSendList.prototype = {
	get Promise() {
		return this._defer.promise();
	},
	get Count() {
		return this._list.length;
	},
	get FailCount() {
		return this._failCount;
	}
}

SOAPAction.prototype.sendMultiAction = function () {
    var lock = $.Deferred();
    var soap = this;
    var soapList = new SOAPSendList(null, 2, 2);

    for(var action in this._dict)
    {
        soapList.Push(action, this._dict[action][0], this._dict[action][1], this._dict[action][2]);
    }
    soapList.Run();

    $.when(soapList.Promise).done(function(){
        var res = {"GetMultipleWEBCGIsResult":"OK"};
        for(var action in soap._dict)
        {
            res[action+"Response"] = soap._dict[action][1];
        }
        lock.resolve(res);
    }).fail(function(){
        lock.reject();
    })

    return lock.promise().always(function(){
        soap._dict = {};
        soap._xml = null;
        if(window.__pageonloadding){
            window.__pageonloadding_timer = setTimeout(function(){
                window.__pageonloadding=false;
                $(".content-wrapper.contentonload").removeClass("contentonload");
                $(".content-wrapper > .spinner-grow").remove();
                refreshSelect2();
            }, 80);
        }
    })
}

function refreshSelect2(selector) {
    var objs = null;
    if (selector != undefined) {
        if ($(selector).hasClass("select2"))
            objs = $(selector);
        else
            objs = $(selector).find(".select2")
    } else {
        objs = $(".select2");
    }
    if (objs.length) objs.select2({
        minimumResultsForSearch: -1
    });
}

function getLangM(key) {
    return I18N("j", key);
}

function Logout() {
    function logout_do() {
        if ($(window).width() > 768) {
            $("#navbar_top").html("");
            var s = $("#sidebar");
            if (s.css("left") == "0px") {
                s.html("").animate({
                    width: $(window).width()
                }, 400, "swing", function () {
                    go_next("Login.html");
                })
                return;
            }
        }
        go_next("Login.html");
    }
    if (_DEBUG_ON) return logout_do();
    if (confirm(getLangM('Are you sure you want to sign out?'))) {
        var soapAction = new SOAPAction();
        soapAction.sendAction("Logout", {
                Action: "logout",
                Username: ""
            }, null)
            .done(function () {
                sessionStorage.clear();
                logout_do();
            })
            .fail(function () {
                go_next("Login.html?error");
            });
    }
}

function go_next(arg) {
    //some browser will return 304 not modify, add random number on url can resolve browser return page from cache.
    var tt = new Date().getTime();
    if (arg.indexOf("?") != -1)
        arg += "&t=" + tt;
    else
        arg += "?t=" + tt;
    window.location.href = arg;
}

/********************** Util **********************/
function randomNum(minNum, maxNum) {
    switch (arguments.length) {
        case 1:
            return parseInt(Math.random() * minNum + 1, 10);
            break;
        case 2:
            return parseInt(Math.random() * (maxNum - minNum + 1) + minNum, 10);
            break;
        default:
            return 0;
            break;
    }
}

function StrFormat() {
    var str = arguments[0];
    for (var i = 0; i < arguments.length - 1; i++) {
        var reg = new RegExp("\\{" + i + "\\}", "gm");
        str = str.replace(reg, arguments[i + 1]);
    }
    return str;
}

function ObjectNullToEmpty(d) {
    for (var name in d) {
        if (d[name] == null)
            d[name] = "";
    }
}

function err_scrollTop() {
    var scroll = $('.has-error').first().offset().top - $('.content-wrapper').first().offset().top;
    $('.main-panel').first().animate({
        scrollTop: scroll - 120
    }, 500);
}

function show_error_msg(msg, obj) {
    var e = $(obj).closest(".input-wrapper");
    if (e.length) {
        e.parent().addClass("has-error");
        var div = $('<div class="form-group row has-error has-error-msg">');
        div.append($('<label class="col-form-label">'));
        div.append(
            $('<div class="input-wrapper">').append(
                $('<span class="error-info">').text(getLangM(msg))
            )
        );
        e.parent().after(div);
        err_scrollTop();
    }
}

function remove_error_msg() {
    $(".has-error").removeClass("has-error");
    $(".has-error-msg").remove();
}

function get_check(name, selector) {
    var e = $("input[name='" + name + "']");
    if (selector != undefined) e = $(e).find("input[name='" + name + "']");
    if (e.length) {
        if (e.attr("type") == "checkbox")
            return e.prop("checked");
        else
            return e.filter(":checked").val();
    }
    return null;
}

function set_check(name, value, selector) {
    var e = $("input[name='" + name + "']");
    if (selector != undefined) e = $(e).find("input[name='" + name + "']");
    if (e.length) {
        if (e.attr("type") == "checkbox") {
            if (e.prop("checked") != value) {
                e.trigger("click");
            }
        } else {
            e = e.filter("[value='" + value + "']");
            if (e.length) {
                if (!e.prop("checked")) {
                    e.trigger("click");
                }
            }
        }
    }
}

function insertWait(arg) {
    var str = "";
    str+= "<div class=\"waiting_base\" id=\"waiting_base\" style=\"display: none;\"></div>";
    str+= "<div class=\"waiting_body\" id=\"waiting_body\" style=\"display: none;\">";
    str+= "<div class=\"text-center\">";
    str+= "<img class=\"indicator\" src=\"images/wait.gif\"><br/>";
    str+= "<span id=\"wait_desc\">"+getLangM( "Data Save Tips")+"</span><br/>";
    str+= "<span id=\"wait_sec\">1</span>";
    str+= "<span id=\"desc_percent\"> %</span>";
    str+= "</div>";
    str+= "</div>";
    $("."+arg).append(str);
}

/* process waiting */
var loadingSeconds = 0, progressBase = 0, progressNum = 0;
var G_option = {};
var current_url = location.pathname.substring(location.pathname.lastIndexOf('/') + 1);

function showLoading(option) {
    var obj = {
        wait: -1,
        message: "",
        next: current_url,
        display_counter: true,
        callback: null
    };

    $.extend(obj, option);
    G_option = obj;
    loadingSeconds = obj.wait;
    progressBase = 100/loadingSeconds;
    progressNum = 0;
    LoadingTime(obj.wait);
    if(obj.message) {
        showtext("wait_desc", obj.message + " ");
    }
    $("#waiting_base").css('display','block');
    $("#waiting_body").css('display','block');
}

function LoadingTime(seconds) {
    progressNum = progressNum + progressBase;
    if(typeof(seconds) == "number" && seconds >= 0) {
        if(seconds != 0) {
            if(G_option.display_counter) {
                showtext("wait_sec", Math.round(progressNum));
                if(Math.round(progressNum) > 100) {
                    showhide("wait_sec, desc_percent", false);
                }
                showhide("wait_sec, desc_percent", true);
            } else {
                showhide("wait_sec, desc_percent", false);
            }
            --seconds;
            setTimeout("LoadingTime("+seconds+");", 1000);
        } else {
            progressNum = 0;
            hideLoading();
            if(G_option.callback) {
                G_option.callback();
            } else if(G_option.next != "none") {
                go_next(G_option.next);
            }
        }
    } else if(seconds == -1) {
        showhide("wait_sec, desc_percent", false);
    }
}

function hideLoading() {
    $("#waiting_base").css('display','none');
    $("#waiting_body").css('display','none');
}

function showtext(obj, str) {
    $("#"+obj).html(str);
}

function showhide(obj_id_ary, flag) {
    obj_id_ary = obj_id_ary.replace(/ /g, "");
    var ary = obj_id_ary.split(",");

    for(var x=0; x<ary.length; x++) {
        if(ary[x] == "") continue;
        var input_type = $("#"+ary[x]).prop('type');
        if(input_type == "select-one" || input_type == "radio" || input_type == "checkbox" || input_type == "password" ||
            input_type == "password" || input_type == "textarea" || input_type == "text" || input_type == "select-multiple")
        $("#"+ary[x]).prop('disabled', !flag);
        if(flag) {
            $("#"+ary[x]).show();
        } else {
            $("#"+ary[x]).hide();
        }
    }
}

function Reload(o) {
    function r() {
        location = location.pathname;
    }
    if (o != null && typeof o == "object") {
        o.callback = r;
        showLoading(o);
    } else {
        r();
    }
}

function TW_confirm(option) {
    var obj = {
        title: "",
        message: "",
        text_yes: getLangM("Apply"),
        text_no: getLangM("Cancel"),
        show_yes: true,
        show_no: true,
        style: null
    };
    $.extend(obj, option);

    $("#confirm_box").remove();
    $("div.modal-backdrop").remove();
    var div_root = $('<div class="modal" id="confirm_box" tabindex="-1" aria-hidden="true">');
    var div_dialog = $('<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">');
    var div_content = $('<div class="modal-content">');
    var div_header = $('<div class="modal-header">');
    var h5_header = $('<h5 class="modal-title">').text(obj.title);
    var button_header = $('<button type="button" class="close" data-dismiss="modal" aria-label="Close">');
    var span_header = $('<span aria-hidden="true">').text("x");
    var div_body = $('<div class="modal-body">');
    var div_container = $('<div class="container-fluid">');
    var div_message = $('<div class="text-center" id="body_text">').html(obj.message);
    var div_footer = $('<div class="modal-footer">');
    var button_yes = $('<button type="button" class="btn btn-secondary" id="confirm_no" data-dismiss="modal">').text(obj.text_no);
    var button_no = $('<button type="button" class="btn btn-primary" id="confirm_yes">').text(obj.text_yes);

    button_header.append(span_header);
    div_header.append(h5_header).append(button_header);
    div_container.append(div_message);
    div_body.append(div_container);
    div_footer.append(button_yes).append(button_no);
    div_content.append(div_header).append(div_body).append(div_footer);
    div_dialog.append(div_content);
    div_root.append(div_dialog);
    $(".content-wrapper").append(div_root);
    $("#confirm_box").modal("show");
    if(obj.show_no == false) {
        $("#confirm_no").hide();
    }
    if(obj.show_yes == false) {
        $("#confirm_yes").hide();
    }
    if(obj.style) {
        $("#body_text").css(obj.style);
    }

    var d = $.Deferred();
    $("#confirm_yes").click(function() {
        $("#confirm_box").modal("hide");
        d.resolve();
    });
    $("#confirm_no").click(function() {
        $("#confirm_box").modal("hide");
        d.reject();
    });
    button_header.click(function() {
        $("#confirm_box").modal("hide");
        d.reject();
    });

    return d.promise();
}

function getLogoutTime()
{
    var d = $.Deferred();
    // new SOAPAction().sendAction("GetHttpTimeoutSettings").done(function(res){
    //     d.resolve(parseInt(res.http_timeout));
    // }).fail(function(){
    //     d.reject();
    // }).always(function(){
    //     if(window.__pageonloadding_timer)clearTimeout(window.__pageonloadding_timer);
    // });
    d.resolve(600);
    return d.promise();
}

function COMM_GetURLParameter(parameter) {
    var reg = new RegExp("(^|\\?|&)"+ parameter +"=([^&]*)(\\s|&|$)", "i");
    if (reg.test(location.href)) return unescape(RegExp.$2.replace(/\+/g, " "));
    else return "";
}

function insert_pwd_eye() {
    var str = "";
    str += '<input type="text" class="form-control short d-none" maxlength="63">';
    str += '<label class="password_eye input-group-text">';
    str += '<input type="checkbox" class="checkbox-pwd-eye">';
    str += '<i class="bi bi-eye"></i>'
    str += '</label>';
    $('input[type="password"]').after(str);

    $(".checkbox-pwd-eye").on('change', function () {
        var div_parent = $(this).parent().parent();
        var input_child = div_parent.find('input[type="password"], input[type="text"]');
        input_child.toggleClass('d-none');
        var last_value = input_child.filter('input[type="password"]').val();
        input_child.filter('input[type="text"]').val(last_value);
    });

    $(".checkbox-pwd-eye").parent().parent().find('input[type="text"]').on("input propertychange", function () {
        var last_value = $(this).val();
        $(this).parent().find('input[type="password"]').val(last_value);
    });

    $(".checkbox-pwd-eye").parent().parent().find('input[type="password"], input[type="text"]').css('padding-right', '24px');
}
