var load_navbar = $.Deferred();
var load_sidebar = $.Deferred();
var webTimer = null;

(function ($) {
    'use strict';

    document.writeln("<script src=\"js/i18n.js\"></script>");
    document.writeln("<script src=\"js/select2.min.js\"></script>");
    document.writeln("<script src=\"js/jquery.cookie.js\"></script>");
    document.writeln("<script src=\"js/hmac_md5.js\"></script>");
    document.writeln("<script src=\"js/aes.js\"></script>");
    document.writeln("<script src=\"js/libajax.js\"></script>");
    document.writeln("<script src=\"js/hnap.js\"></script>");
    document.writeln("<script src=\"js/util.js\"></script>");
    document.writeln("<script src=\"js/validation.js\"></script>");
    document.writeln("<script src=\"js/verify.js\"></script>");
    document.writeln("<script src=\"js/table_obj.js\"></script>");

    // loadding page
    if($(".content-wrapper.contentonload").length){
        $(".content-wrapper.contentonload").append($('<div class="spinner-grow text-warning" role="status">'));
        window.__pageonloadding = true;
    }
})(jQuery);

$(function () {
    'use strict';

    // load menu, header, footer
    var work_mode = $.cookie("work_mode");
    var sidebar = "_sidebar.html";
    if (work_mode == "bridge") {
        sidebar = "_sidebar_bridge.html";
    } else if (work_mode == "repeater") {
        sidebar = "_sidebar_repeater.html";
    }
    // $("#sidebar").load("./partials/"+ sidebar +" #sidebar>*", null, function () {
    //     load_sidebar.resolve();
    // });
    // $("#navbar_top").load("./partials/_navbar.html #navbar_top>*", null, function () {
    //     load_navbar.resolve();
    // });
    $.ajax({
        url: "./partials/"+ sidebar,
        dataType:"jsonp",
        crossDomain: true,
        jsonpCallback: "JsonP_side",
        success: function(res){
            $("#sidebar").html($(res).html())
            load_sidebar.resolve();
        }
    })
    $.ajax({
        url: "./partials/"+ "_navbar.html",
        dataType:"jsonp",
        crossDomain: true,
        jsonpCallback: "JsonP_nav",
        success: function(res){
            $("#navbar_top").html($(res).html())
            load_navbar.resolve();
        }
    })

    $.when(load_sidebar).done(function () {
        var path = location.pathname;
        var pageName = "";
        path = path.split("/").slice(-1)[0];
        path == "" && (path = "index.html");
        I18N_Translate("#sidebar");
        $("#sidebar .nav-link").each(function (i, e) {
            var href = $(e).attr("href");
            if (href && (RegExp("[/'\"]" + path).test(href))) {
                $(e).parentsUntil("#sidebar", ".collapse").each(function (i, e) {
                    $(e).collapse("show");
                })
                $(e).toggleClass("active");
                pageName = $(e).text();
                return false;
            }
        });
        $.when(load_sidebar, load_navbar).done(function () {
            I18N_Translate("#navbar_top");
            $("#page-title").text(pageName);
        })
    });
});

$(function () {
    'use strict';

    // menu collapse button
    $('#navbar_top').on("click", 'button[data-toggle="offcanvas"]', function () {
        if (window.matchMedia('(max-width: 991px)').matches) {
            $('.sidebar-offcanvas').toggleClass('active');
        } else {
            $('.container-scroller').toggleClass('sidebar-hide');

        }
    })

    // select2
    refreshSelect2();
    $(".modal").on("shown.bs.modal", function () {
        refreshSelect2($(this));
    });
    $(".collapse").on("shown.bs.collapse", function () {
        refreshSelect2($(this));
    });
    window.onresize = function () {
        refreshSelect2();
    };

    insertWait("content-wrapper");
    if(parent.location.href.indexOf("Account") < 0) {
        insert_pwd_eye();
    }

    // checkbox
    /*$(".form-check-label").on("change", function () {
        var input_check = $(this).find("input[type='checkbox']");
        var span_text = $(this).find("span");
        if (input_check.length > 0 && span_text.length > 0) {
            var status = input_check.prop("checked");
            if (span_text.html() == getLangM("Enable") || span_text.html() == getLangM("Disable")) {
                if (status == true) {
                    span_text.html(getLangM("Enable"));
                } else {
                    span_text.html(getLangM("Disable"));
                }
            }
        }
    });*/

    if(parent.location.href.indexOf("Wizard") < 0) {
        startTimeout();
    }
});

function startTimeout() {
    var WEB_TIMEOUT_TIME = 600;//web timeout seconds
    var promise = null;

    if (window.sessionStorage) {
        if (sessionStorage._logoutTime && parseInt(sessionStorage._logoutTime) > 0)
            WEB_TIMEOUT_TIME = parseInt(sessionStorage._logoutTime);
        else
            promise = getLogoutTime();
    }
    $.when(promise).always(function (res) {
        if (res != null && parseInt(res) > 0) {
            WEB_TIMEOUT_TIME = parseInt(res);
            if (window.sessionStorage) sessionStorage._logoutTime = WEB_TIMEOUT_TIME;
        }
        clearTimeout(webTimer);
        webTimer = setTimeout("readyLogout()", 1e3 * WEB_TIMEOUT_TIME);
    })
}

function readyLogout() {
    var soapAction = new SOAPAction();
    soapAction.sendAction("Logout", {
        Action: "logout",
        Username: ""
    }, null).done(function () {
        sessionStorage.clear();
        redirect_URL();
    }).fail(function () {
        redirect_URL();
    });
}

function redirect_URL() {
    location.assign("/");
}

// fix ie compatibility
if (typeof String.prototype.startsWith !== 'function') {
    String.prototype.startsWith = function(prefix) {
        return this.slice(0, prefix.length) === prefix;
    };
}