// ajax HttpRequest
function sendAction(url, type, query, data) {
    if (!type) type = "GET";
    if (!query) query = {};
    if (!data) data = "";

    if (/(\.cgi)|(\.cmd)/.test(url)) {
        query["sessionKey"] = sessionKey;
    }
    Object.keys(query).forEach(function (k) {
        url += "&" + k + "=" + query[k].toString();
    });
    url = url.replace("&", "?");

    var r = $.Deferred();
    $.ajax({
        url: url,
        type: type,
        data: data,
        success: function (result) {
            var v = getValueByName(result,"sessionKey");
            v != "" && (sessionKey = v);
            r.resolve(result);
        },
        fail: function (result) {
            r.reject(result);
        }
    });
    return r.promise()
}

// select box func
var mySelect = {
    select: null,
    target: null,
    InitSelect: function () {
        select = $("#selectAlert");
        select.off().on("click", function () {
            target = null, select.hide();
        });
        select.on("click", "#selectRect", function () {
            return false;
        });
        select.on("click", "#selectRect li", function () {
            target && (target.find(".select_content").html(this.innerHTML).val(mySelect.getValue(this.value)).change());
            target = null;
            select.hide();
            return false;
        });


        $(".select_div").on("click", function () {
            target = $(this);
            mySelect.show();
        })
    },
    show: function () {
        select.html("<div id='selectRect'><ul></ul></div>");
        if (!target) return;
        var name = target.find(".select_content").prop("id");
        if (name in mySelectDict) {
            mySelectDict[name]["text"].forEach(function (v, i) {
                select.find("ul").append("<li value=" + i + ">" + v + "</li>");
            });
        }
        select.show().focus();
    },
    hide: function () {
        select.hide();
    },
    getValue: function (v) {
        if (!target) return v;
        var name = target.find(".select_content").prop("id");
        if (name in mySelectDict) return mySelectDict[name]["value"][v];
        else return v;
    },
    setValue: function (e, v) {
        var id = e.prop("id");
        if (id in mySelectDict) {
            var vs = mySelectDict[id]["value"],
                vt = mySelectDict[id]["text"];
            if (vs.indexOf(v) < 0) return e.val(v).html(v), 0;
            e.val(v).html(vt[vs.indexOf(v)]);
        } else {
            e.val(v).html(v);
        }
    }
}

// 时间格式化输出
function dateFormat(fmt, date) {
    let ret;
    const opt = {
        "Y+": date.getFullYear().toString(), // 年
        "m+": (date.getMonth() + 1).toString(), // 月
        "d+": date.getDate().toString(), // 日
        "H+": date.getHours().toString(), // 时
        "M+": date.getMinutes().toString(), // 分
        "S+": date.getSeconds().toString() // 秒
        // 有其他格式化字符需求可以继续添加，必须转化成字符串
    };
    for (let k in opt) {
        ret = new RegExp("(" + k + ")").exec(fmt);
        if (ret) {
            fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
        };
    };
    return fmt;
}


function getValueByName(str, name, p, i) {
    if (str == null || str == "") return "";
    if (name == null || name == "") return "";
    if (p == null) p = "[0-9a-zA-Z]+";
    if (i == null) i = true;

    var r = new RegExp(name + "[\ ]*=[\ ]*[\'\"]?(" + p + ")[\'\"]?",i?"i":"");
    if(r.test(str))return RegExp.$1;
    return "";
}