#! /usr/bin/awk -f 

# @todo refactor openvpn.cgi, ipsec.cgi, pptp.cgi to reduce code duplication.
#
# $1 = type of dev (openvpn.0)
# $2 = 
#

function read_rdb_profile(profile_no,profile_var,default_value) {
	
	cmd = sprintf("rdb_get link.profile.%s.%s",profile_no,profile_var)
	if( (cmd | getline) == 1 ) {
		var=$0
	}
	else {
		var=default_value
	}
	close(cmd);
	
	return var
}

function write_java_variable(javascript_var,javascript_val,suffix) {
	printf("\"%s\":\"%s\"%s\n",javascript_var,javascript_val,suffix);
}

function write_rdb_profile_to_java_variable(profile_no,profile_var,default_value,suffix) {
	javascript_val=read_rdb_profile(profile_no,profile_var,default_value)
	write_java_variable(profile_var,javascript_val,suffix);
}

BEGIN 
{
	FirstAvailableProfile = 7;  # Profiles 0-6 are reserved.
	LastAvailableProfile = 32;
	DelFlagUsed = "0";          # Profile in use.

	print ("Content-type: text/html\n");
	if( ENVIRON["SESSION_ID"]=="" || ENVIRON["SESSION_ID"] !=  ENVIRON["sessionid"] ) exit;

	# Loop through all profiles, as they may be non-contiguous.
	print ("var st=[");
	j=0;
	for (i = FirstAvailableProfile; i <= LastAvailableProfile; ++i)
	{
		cmd = sprintf("rdb_get link.profile.%s.dev",i);
		if(( cmd | getline) > 0)
		{
			dev = $1

			# Ignore profiles not in use.
			rdb_var = read_rdb_profile(i, "delflag", DelFlagUsed)
			if (rdb_var != DelFlagUsed) {
				continue;
			}

			if(dev =="openvpn.0" ) {
				# keep type
				type = dev;

				# put seperator if any previous exists
				if(j++>0) 
					print(",");
				
				printf("{\n")

				# read name
				rdb_var = read_rdb_profile(i,"name","")
				# write name
				write_java_variable("name",rdb_var,",");
				
				# put enable
				write_rdb_profile_to_java_variable(i,"enable","0",",");

				# put profile number
				write_java_variable("profilenum",i,",");
				# put profile type
				write_java_variable("type",type,",");

				# openvpn type
				write_rdb_profile_to_java_variable(i,"vpn_type","",",");
				
				# put network address
				write_rdb_profile_to_java_variable(i,"network_addr","",",");
				# put network mask
				write_rdb_profile_to_java_variable(i,"network_mask","",",");
				# put authentication type
				write_rdb_profile_to_java_variable(i,"vpn_authtype","",",");
				
				# TODO: print generated certificates - array
				
				# put user name and password
				write_rdb_profile_to_java_variable(i,"user","",",");
				write_rdb_profile_to_java_variable(i,"pass","",",");
				# put server address and port
				write_rdb_profile_to_java_variable(i,"serveraddress","",",");
				write_rdb_profile_to_java_variable(i,"serverport","",",");
				write_rdb_profile_to_java_variable(i,"serverporttype","",",");
				write_rdb_profile_to_java_variable(i,"conn_type","",",");
				write_rdb_profile_to_java_variable(i,"defaultgw","0",",");

				write_rdb_profile_to_java_variable(i,"certi","",",");

				# TODO: print installed certificates - array
				
				# put network address
				write_rdb_profile_to_java_variable(i,"local_ipaddr","",",");
				write_rdb_profile_to_java_variable(i,"remote_ipaddr","",",");
				write_rdb_profile_to_java_variable(i,"remote_nwaddr","",",");
				write_rdb_profile_to_java_variable(i,"remote_nwmask","",",");
				
				printf("}\n")
			}
		}
	}
	print ("];");
}
