#!/bin/sh

if [ -z  "${SESSION_ID}" -o "${SESSION_ID}" != "${sessionid}" ]; then
	exit 0
fi

log() {
	logger "ram_dump: ${1}"
}

log "query str = $QUERY_STRING"

if [ -z "$QUERY_STRING" -a -n "$1" ]; then
	CMD="$1"
fi

DB_DUMP_RESULT="mmemdump.result"
DB_UMTS_CMD="wwan.0.umts.services.command"
DB_UMTS_CMD_ST="wwan.0.umts.services.command.status"
DB_UMTS_CMD_RESULT="wwan.0.umts.services.command.response"
rdb_set $DB_DUMP_RESULT
SIERRA_MODULE=`rdb_get wwan.0.manufacture | grep "Sierra" | grep -v grep`

AT_PORT=`rdb_get wwan.0.V250_if.1`

if [ -x "/usr/sbin/chat" ]; then
	CHAT="/usr/sbin/chat"
else
	CHAT="/bin/chat"
fi

echo -e 'Content-type: text/html\n'

log() {
	logger -t `basename $0` -- "$@"
}

do_chat() {
	cat << EOF > /tmp/tmp-$$
''	+++
''	AT
OK	'$@'
OK
EOF
	"$CHAT" -v -t 4 -f /tmp/tmp-$$ < "$AT_PORT" > "$AT_PORT"
	return $?
}

do_chat_with_check() {
	log "sending... $@ : "
	do_chat "$@" || set_result_exit "Error: Crash mode set failed, reboot module & try again"
	log "ok"
}

set_result_exit() {
	log "$@"
	rdb_set $DB_DUMP_RESULT "$@"
	echo "DumpMode=\"$@\";"
	exit 0
}

# check if Sierra Wireless module?
if [ -z "$SIERRA_MODULE" ]; then
	set_result_exit "Error: Non Sierra Wireless module"
fi

# check if simple_at_manager is running
if [ "$CMD" = "START" -o "$CMD" = "STOP" -o "$CMD" = "CHECK" ]; then
	SIMPLE_AT_PID=`pidof simple_at_manager`
	if [ -z "$SIMPLE_AT_PID" ]; then
		set_result_exit "Error: simple_at_manager is not running"
	fi
fi

reboot_module() {
	reboot_module.sh 2>/dev/null 1>/dev/null
	let "timeout=60"
	while [ $timeout -gt 0 ] ;do
		atmgr_st=`rdb_get atmgr.status`
		test -n "$atmgr_st" && break
		sleep 1
		let "timeout-=1"
		#log "timeout = $timeout"
	done
	test "$atmgr_st" != "ready" && set_result_exit "Error: fail to reboot module"
}

send_at_cmd() {
	result=""
	rdb_set $DB_UMTS_CMD_RESULT
	rdb_set $DB_UMTS_CMD_ST
	rdb_set $DB_UMTS_CMD "$1"
	let "timeout=10"
	while [ $timeout -gt 0 ] ;do
		st=`rdb_get $DB_UMTS_CMD_ST`
		test -n "$st" && break
		sleep 1
		let "timeout-=1"
		#log "timeout = $timeout"
	done
	result=`rdb_get $DB_UMTS_CMD_RESULT`
	#log "$result"
	if [ "$result" = "" -a "$st" = "0" ]; then
		set_result_exit "$1 command error"
	fi
}

check_cmd_result() {
	chk_str=`echo $1 | grep "$2" | grep -v grep`
	test -n "$chk_str" && set_result_exit "$3"
}

start_mmem_dump_mode() {
	send_at_cmd "at!entercnd=\"A710\""
	send_at_cmd "at!eroption=0"
	send_at_cmd "at!err=0"
	send_at_cmd "at!gcclr"
	killall -stop supervisor 2>/dev/null
	reboot_module
	check_mmem_dump_mode
}

stop_mmem_dump_mode() {
	send_at_cmd "at!entercnd=\"A710\""
	send_at_cmd "at!eroption=1"
	reboot_module
	killall -cont supervisor 2>/dev/null
	check_mmem_dump_mode
}

check_mmem_dump_mode() {
	send_at_cmd "at!eroption?"
	check_cmd_result "$result" "1 - Reset" "Memory dump mode is disabled"
	check_cmd_result "$result" "0 - USB Memory Download" "Memory dump mode is enabled"
	set_result_exit "Error: unknown memory dump mode : $result"
}

kill_process() {
	while test -n "`pidof $1`"
	do
		killall $1 2>/dev/null
		sleep 1
	done
}

kill_processes() {
	kill_process connection_mgr
	kill_process pots_bridge
	kill_process cnsmgr
	kill_process simple_at_manager
	kill_process modem_emulator
	kill_process gpsd_client
	kill_process gpsd
	rdb_set sensors.gps.0.gpsd_status
}

make_module_crash() {
	killall -stop supervisor 2>/dev/null
	kill_processes
	do_chat_with_check 'at!unlock=\"A710\"' 2>/dev/null
	# It may fail with do_chat_with_check() function because module will
	# reboot immediately after !ertest=1 command
	do_chat 'at!ertest=1' 2>/dev/null
	sleep 10
	# above command reboot 3G module and launch cnsmgr so need to kill again
	kill_processes
	set_result_exit "Force crash mode is set"
}

start_mmem_dump() {
	rm /opt/cdcs/upload/ebi.bin 2>/dev/null
	rm /opt/cdcs/upload/load.cmm 2>/dev/null
	rm /var/log/ram_dump.log 2>/dev/null
	let "free_mem=0"
	free_mem=`df -h /opt | grep opt | grep -v grep | awk '{print $4}' | sed -e 's/M//g' -e 's/\..*$//'`
	log "free memory space in /opt is $free_mem"
	if [ $free_mem -lt 65 ]; then
		set_result_exit "Error: not enough memory space"
	fi
	test ! -d /opt/cdcs/upload && set_result_exit "Error: /opt/cdcs/upload does not exist"
	kill_processes
	curr_dir=`pwd`
	cd /opt/cdcs/upload
	CNS_IF=`rdb_get wwan.0.mgmt_if`
	test -z "$CNS_IF" && CNS_IF="/dev/ttyUSB0"
	LOGFILE="/var/log/ram_dump.log"
	rm $LOGFILE	2>/dev/null
	touch $LOGFILE
	ramdumptoolarm9 "$CNS_IF" -s 1>$LOGFILE 2>$LOGFILE
	cd $curr_dir
	#reboot_module
	modem_err=`grep "Modem not responding" $LOGFILE | grep -v grep`
	test -z "$modem_err" &&	set_result_exit "Memory dump done"
	set_result_exit "Error: Modem is not responding"
}

reboot_Sierra_module() {
	reboot_module
	check_mmem_dump_mode
}

case "$CMD" in
	'START') log "Starting memory dump mode"
		start_mmem_dump_mode
		;;
	'STOP') log "Stopping memory dump mode"
		stop_mmem_dump_mode
		;;
	'CHECK') log "Checking memory dump mode"
		check_mmem_dump_mode
		;;
	'CRASH') log "Making module crash for test"
		make_module_crash
		;;
	'DUMP') log "Starting memory dump"
		start_mmem_dump
		;;
	'REBOOTMODULE') log "Rebooting module"
		reboot_Sierra_module
		;;
	*)
		log "Usage : `basename $0` [start|stop|check|dump]"
		set_result_exit "Unknown command"
esac

set_result_exit "Error: Modem is not responding"
exit 0
