<!--
  Common include to check the session is current and if not redirect to the
  login page, then after logging in redirect back to the referring page.

  Note a redirect on a non-root user can be effected by defining the
  pre-processor symbol "CHECK_ROOT_USER" before including this file.

  Note this should be included using the C preprocessor after the
  topinc_v2.inc include as it has the following dependencies:
  - util.js:HostDate()
  - jQuery
-->

<!-- <%
// Check the session, if timed out redirect, and pass the referring page as
// an argument. This allows index.html to redirect back to the referring page.
useSession();
if (
#ifdef CHECK_ROOT_USER
    (session["userlevel"] != '0') ||
#endif
    request["SESSION_ID"] != session["sessionid"]) {
  redirect('/index.html?src=' + request["SCRIPT_NAME"]);
  exit(403);
}
%> -->

<!--
Set the date on the router if we are redirected back here (the original page)
from index.html after logging in again from a timed out session.
-->
<script language="JavaScript">
if ("@@request['QUERY_STRING']" == "setdate") {
  // Send the browser date to the router.
  $.get("/cgi-bin/setdate.cgi?" + HostDate(),
    function() {
    // Restore the original page.
    // Otherwise the date would be set every time this page loads.
    // Do this synchronously otherwise the http GET is aborted.
    window.location = "@@request['SCRIPT_NAME']";
  });
}
</script>
