 /*
//----------------------------------------------------------------------------
//           Copyright (c) 2003 Texas Instruments Incorporated
//                        ALL RIGHTS RESERVED
//
//     "This computer program is subject to a separate license agreement
//     signed by Texas Instruments Incorporated and the licensee, and is
//     subject to the restrictions therein.  No other rights to reproduce,
//     use, or disseminate this computer program, whether in part or in
//     whole, are granted."
//
//----------------------------------------------------------------------------
*/

/*Removes Leading & Trailing spaces */
function trim(str){
        str = str.replace(/^\s*/,'').replace(/\s*$/,'');
        return str;
}

function doValidateIP(Address){
        var address = Address.match("^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$");
        var digits;
        var i;
        if(address == null) {
                return false;
        }
        digits = address[0].split(".");
        for(i=0; i < 4; i++){
                if((Number(digits[i]) > 255 ) || (Number(digits[i]) < 0 ) || (Number(digits[0]) > 223))
                {
                        return false;
                }
        }
        return true;
}

function doValidateMask(Mask){
        var mask = Mask.match("^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$");
        var digits;
        var bMask = 0;
        var watch = false;
        var i;
        if(mask == null) {
                return false;
        }
        digits = mask[0].split(".");
        for(i=0; i < 4; i++){
                if((Number(digits[i]) > 255 ) || (Number(digits[i]) < 0 )){
                        return false;
                }
        bMask = (bMask << 8) | Number(digits[i]);
        }
        bMask = bMask & 0x0FFFFFFFF;
        for(i=0; i<32; i++){
        if((watch==true) && ((bMask & 0x1)==0)) {
                return false;
        }
        bMask = bMask >> 1;
        if((bMask & 0x01) == 1) watch=true;
        }
        return true;
}


/* validation of Empty Field */
function isEmpty(objTemp)
{
        if( trim(objTemp.value) == ""  || objTemp.value.length == 0) {
                return false;
        }
        return true;
}

/* validation of Text Field */
function isText(objTemp){
        if( trim(objTemp.value) == "" || objTemp.value.length == 0){
                return false;
        }
        if(objTemp.value.match("^[a-z A-Z]") != null){
                return true;
        }
        else {
                return false;
        }
}
/*validation of Number ( with or without range) */
function isIntRange(objTemp,startRange,endRange){
        if( trim(objTemp.value) == ""  || objTemp.value.length == 0){
                return false;
        }
        if(isNaN(objTemp.value) ){
                return false;
        }
        if(!(startRange =="" && endRange =="")) {
                if ((objTemp.value < parseInt(startRange))||(objTemp.value > parseInt(endRange)))
                {
                        return false;
                }
        }
        if(!(startRange == "")) {
                if (objTemp.value < parseInt(startRange)){
                return false;
                }
        }
        if(!(endRange =="")){
                if (objTemp.value > parseInt(endRange))
                {
                        return false;
                }
        }
        return true;
}
/*validation of e-mail */
function isEmail(objTemp){
        var emailReg = "^[\\w-_\.]*[\\w-_\.]\@[\\w]\.+[\\w]+[\\w]$";
        var regex = new RegExp(emailReg);
        var value=trim(objTemp.value)
        return regex.test(value);
}
function isHostName(objTemp)
{
  var HostName = trim(objTemp.value);
   if (HostName.match("^[a-zA-Z]+") == null) return (false);
   else if (HostName.match("^([a-zA-Z]+[a-zA-Z0-9_-]*)(\.*[a-zA-Z0-9])+$") == null) return (false);
   else if ((HostName.length == 0) || (HostName.length > 63)) { return(false); }
   return true;
}

function isGateway(Address)
{
  var address = Address.match("^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$");
  var digits;
  var i;
  var error;

  if(address == null) { error="Invalid Gateway IP address"; return error; }
  digits = address[0].split(".");
  for(i=0; i < 4; i++)
  {
    if((Number(digits[i]) > 255 ) || (Number(digits[i]) < 0 ) || (Number(digits[0]) > 223))
    { error="Invalid Gateway IP address"; return error; }
  }
   return true;
}

