// WiFi STA/Client Linux driver server side script (AppWeb ESP)
// Server side script (AppWeb ESP)

// Process the form
if (request['REQUEST_METHOD'] == "POST") {

  // Set the encryption type based on the authorisation and the relevant encryption value.
  var encryptionType = "NONE";
  var authMode = form["id_network_auth"];
  if (authMode == "OPEN") {
    // Map the wep encryption selection to encryption type
    var wepEncryption = form["id_wep_encryption"];
    if (wepEncryption == "disabled") {
      encryptionType = "NONE";
    }
    else {
      encryptionType = "WEP";
    }
  }
  else if (authMode == "SHARED") {
    // Always use encryption since the keys are needed for authorisation anyway.
    encryptionType = "WEP";
  }
  else {
    encryptionType = form["id_wpa_encryption"];
  }

  // Create the RDB command
  var apProfile = "&wlan_sta.0.ap.0.";
  var staCommon = "&wlan_sta.0.";
  var rdbCmd =
    staCommon + "auto_roam_enable="                    + form["id_auto_roam_enable"           ] +
    apProfile + "network_auth="                        + form["id_network_auth"               ] +
    apProfile + "wpa_pre_shared_key="                  + form["id_wpa_pre_shared_key"         ] +
    apProfile + "encryption_type="                     + encryptionType                         +
    apProfile + "ssid="                                + form["id_ssid"                       ] +
    apProfile + "bssid="                               + form["id_bssid"                      ] +
    apProfile + "default_route_metric="                + form["id_default_route_metric"       ] +
    apProfile + "network_key_id="                      + form["id_network_key_id"             ] +
    apProfile + "network_key1="                        + form["id_network_key1"               ] +
    apProfile + "network_key2="                        + form["id_network_key2"               ] +
    apProfile + "network_key3="                        + form["id_network_key3"               ] +
    apProfile + "network_key4="                        + form["id_network_key4"               ] +
    apProfile + "wpa_pki_client_identity="             + form["id_wpa_pki_client_identity"    ] +
    apProfile + "wpa_pki_client_private_key_password=" + form["id_wpa_pki_client_key_password"];

  // Create the list of RDBs and set them.
  if (rdbCmd != "") {
    set_list(rdbCmd, '-p');

    // The radio RDB is the trigger and must be written last to ensure all the configs are
    // processed for this "post" method.
    set_single('wlan_sta.0.radio=' + form['id_radio']);
  }
}
