#!/bin/sh
#
# Shell script to generate a list of available APs via the Linux WiFi driver.
#

nof=`basename $0`           # Program name
radioInstance=0             # Default client radio instance to use.

# To log messages to syslog, prefixed by script name.
log() {
  logger -t $nof -- $@
}

sendHttpOk() {
  cat <<EOF
HTTP/1.0 200 OK
Content-Type: text/plain
Cache-Control: no-cache
Connection: keep-alive

EOF
}

sendHttpHtmlHdr() {
  local msg="$1"
  cat <<EOF
HTTP/1.0 $msg
Content-Type: text/html; charset=iso-8859-1
Connection: keep-alive

EOF
}

sendHttpHtmlDoc() {
  local msg="$1"
  local text="$2"
  cat <<EOF
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HTML><HEAD>
<TITLE>$msg</TITLE>
</HEAD><BODY>
<H2>$msg</H2>
$text <P>
</BODY></HTML>

EOF
}

sendHttpNoSession() {
  sendHttpHtmlHdr "408 Request Timeout"
  sendHttpHtmlDoc "The session timed out"
}

sendHttpBadArg() {
  local argValue="$1"
  sendHttpHtmlHdr "400 Bad Request"
  sendHttpHtmlDoc "The query argument is unknown: $argValue"
}

# Ignore if session not current
if [ -z "${SESSION_ID}" -o "${SESSION_ID}" != "${sessionid}" ] ;then
  sendHttpNoSession
  exit 0
fi

# Process query command and options
for i in $(echo $QUERY_STRING | sed "s/&/ /g")
do
  case $i in
  "cmd=getApScanList") ;;
  radio=*) radioInstance=${i#radio=} ;;
  *)
    log "Unknown cmd: $QUERY_STRING"
    sendHttpBadArg "$QUERY_STRING"
    exit 0
    ;;
  esac
done

# Scan using "wpa_cli" command.
# Note this scan is unreliable.
# Sometimes the results are stale.
doWpaCliScan()
{
  # Initiate a scan
  interface="wlan_sta${radioInstance}"
  if ! wpa_cli -i $interface scan > /dev/null 2>&1 ;then
    sendHttpOk
    cat <<EOF
{
"result":"1"
}
EOF
    exit 0
  fi

  # Get connected AP
  # Note: must be done after scan started, otherwise it will hang.
  bssid=$(wpa_cli -i $interface status | grep "bssid=")
  bssid=${bssid#"bssid="}

  # Send result
  sendHttpOk
  echo "{"
  wpa_cli scan_results | ./wlan_sta_linux_ap_scan.awk

  cat <<EOF
,
  "connectedBssid":"$bssid"
EOF
}

# Scan using "iw" command.
# Note the scan can take around 5 seconds.
doIwScan()
{
  interface="wlan_sta${radioInstance}"

  # Do scan and process result
  sendHttpOk
  echo "{"
  iw dev $interface scan | ./wlan_sta_linux_ap_scan.awk
}

# The "iw" scan is more reliable (but takes longer) so use it now.
#doWpaCliScan
doIwScan

# Send result
cat <<EOF
,
  "result":"0"
}
EOF

exit 0
