#!/bin/sh

radioInstance="0"     # Default client radio instance to use.

if [ -z  "${SESSION_ID}" -o "${SESSION_ID}" != "${sessionid}" ]; then
  exit 0
fi

sendHttpOk() {
  cat <<EOF
HTTP/1.0 200 OK
Content-Type: text/plain
Cache-Control: no-cache
Connection: keep-alive

EOF
}

getChan() {
  case $(iw dev $dev survey dump | awk '/frequency/ { print $2; }') in
  "2412") echo "1"  ;;
  "2417") echo "2"  ;;
  "2422") echo "3"  ;;
  "2427") echo "4"  ;;
  "2432") echo "5"  ;;
  "2437") echo "6"  ;;
  "2442") echo "7"  ;;
  "2447") echo "8"  ;;
  "2452") echo "9"  ;;
  "2457") echo "10" ;;
  "2462") echo "11" ;;
  "2467") echo "12" ;;
  "2472") echo "13" ;;
  "2484") echo "14" ;;
  *)      echo ""   ;;
  esac
}

getState() {
  wpa_cli -i $dev status |
    awk '/wpa_state=/ {
      match($0, "wpa_state=");
      print substr($0, RSTART+RLENGTH);
    }'
}

# Process query
for i in $(echo $QUERY_STRING | sed "s/&/ /g")
do
  case $i in
  radio=*) radioInstance=${i#radio=} ;;
  *)
    log "Unknown cmd: $QUERY_STRING"
    exit 0
    ;;
  esac
done
dev="wlan_sta${radioInstance}"

# Get status and send JSON response
sendHttpOk
chan=$(getChan)
state=$(getState)
[ "$state" = "COMPLETED" ]  && state="Connected"
cat <<EOF
{
  "chan":"$chan",
  "state":"$state"
}
EOF

exit 0
