//~~ envar  Nauth;
//----------------------------------------------------------------------------------------------------
// This file includes Windows popup box overriding function and it these overriding function is
// defined twice it will make web browsers hang up. To prevent this problem, include
// overriding function only once.
//----------------------------------------------------------------------------------------------------
//   UTIL.JS FILE INCLUDING CHECK START
//----------------------------------------------------------------------------------------------------
if ( (typeof(util_js_included) == "undefined") || util_js_included == false )
{
 var util_js_included = true;
//----------------------------------------------------------------------------------------------------
function isHexaDigit(digit) {
var hexVals = new Array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "a", "b", "c", "d", "e", "f");
var len = hexVals.length;
var i = 0;
var ret = false;
 for ( i = 0; i < len; i++ )
  if ( digit == hexVals[i] ) break;
 if ( i < len )
  ret = true;
 return ret;
}
function isValidKey(val, size) {
var ret = false;
var len = val.length;
var dbSize = size * 2;
 if ( len == size )
  ret = true;
 else if ( len == dbSize ) {
  for ( i = 0; i < dbSize; i++ )
   if ( isHexaDigit(val.charAt(i)) == false )
    break;
  if ( i == dbSize )
   ret = true;
 } else
  ret = false;
 return ret;
}
function isValidHexKey(val, size) {
var ret = false;
 if (val.length == size) {
  for ( i = 0; i < val.length; i++ ) {
   if ( isHexaDigit(val.charAt(i)) == false ) {
    break;
   }
  }
  if ( i == val.length ) {
   ret = true;
  }
 }
 return ret;
}
function nameFilter(field) {
 for ( i = 0; i < field.value.length; i++ ) {
  if ( isNameUnsafe(field.value.charAt(i)) == true ) {
   field.value=field.value.replace(field.value.charAt(i), '');
  }
 }
}
// Allows '0-9','a-z','A-Z','-','.'
function hostNameFilter(field) {
 for ( i = 0; i < field.value.length; i++ ) {
  if ( isHostNameUnsafe(field.value.charAt(i)) == true ) {
   field.value=field.value.replace(field.value.charAt(i), '');
  }
 }
}
function isHostNameUnsafe(compareChar) {
 // Numbers are ok
 if ( compareChar.charCodeAt(0) >=48 && compareChar.charCodeAt(0) <= 57 )
  return false;
 // Alphabetic characters are ok
 if ( compareChar.charCodeAt(0) >=65 && compareChar.charCodeAt(0) <= 90 )
  return false;
 // Alphabetic characters are ok
 if ( compareChar.charCodeAt(0) >=97 && compareChar.charCodeAt(0) <= 122 )
  return false;
 // '-' '_' and '.' are ok. '_'=95 '.'=46 '-'=45
 if ( compareChar.charCodeAt(0) == 95 || compareChar.charCodeAt(0) == 46 || compareChar.charCodeAt(0) == 45 )
  return false;
 // Everything else is bad
 return true;
}
// Allowed URL characters from RFC 3986
// * unreserved	= ALPHA / DIGIT / "-" / "." / "_" / "~"
// * reserved	= gen-delims / sub-delims
// * gen-delims	= ":" / "/" / "?" / "#" / "[" / "]" / "@"
// * sub-delims	= "!" / "$" / "&" / "'" / "(" / ")" / "*" / "+" / "," / ";" / "="
function urlFilter(field) {
 for ( i = 0; i < field.value.length; i++ ) {
  if ( isURLUnsafe(field.value.charAt(i)) == true ) {
   field.value=field.value.replace(field.value.charAt(i), '');
  }
 }
}
function isURLUnsafe(compareChar) {
 //var patt=new RegExp("[^a-zA-Z0-9\-._~!*'();:@&=+$,\/?#\[\]]");
 var patt=/[^a-zA-Z0-9-._~!*'();:@&=+$,\/?#\[\]]/
 return patt.test(compareChar);
}
function isNameUnsafe(compareChar) {
var unsafeString = "\"<>%\\^[]`\+\$\,='#&@.:\t";
 if ( unsafeString.indexOf(compareChar) == -1 && compareChar.charCodeAt(0) > 32
   && compareChar.charCodeAt(0) < 123 ) {
  return false; // found no unsafe chars, return false
 }
 else {
  return true;
 }
}
// Check if a name valid
function isValidName(name) {
var i = 0;
 for ( i = 0; i < name.length; i++ ) {
  if ( isNameUnsafe(name.charAt(i)) == true )
   return false;
 }
 return true;
}
// same as is isNameUnsafe but allow spaces
function isCharUnsafe(compareChar) {
var unsafeString = "\"<>%\\^[]`\+\$\,='#&@.:\t";
 if ( unsafeString.indexOf(compareChar) == -1 && compareChar.charCodeAt(0) >= 32
  && compareChar.charCodeAt(0) < 123 )
  return false; // found no unsafe chars, return false
 else
  return true;
}

function isSameSubNet(lan1Ip, lan1Mask, lan2Ip, lan2Mask) {
var count = 0;
 lan1a = lan1Ip.split('.');
 lan1m = lan1Mask.split('.');
 lan2a = lan2Ip.split('.');
 lan2m = lan2Mask.split('.');
 for (i = 0; i < 4; i++) {
  l1a_n = parseInt(lan1a[i]);
  l1m_n = parseInt(lan1m[i]);
  l2a_n = parseInt(lan2a[i]);
  l2m_n = parseInt(lan2m[i]);
  if ((l1a_n & l1m_n) == (l2a_n & l2m_n))
   count++;
 }
 if (count == 4)
  return true;
 else
  return false;
}
function KeyCode(e) {
 if(e&&e.which){ //NN
  e=e;
  return(e.which);
 }
 else{
  e=event;
  return(e.keyCode);
 }
}
function isBlank(s) {
 for (i=0;i<s.length;i++) {
  c=s.charAt(i);
  if ((c!=' ') && (c!='\n') && (c!='\t'))
   return false;
 }
 return true;
}
function isNValidIP(s) {
 if((isBlank(s))||(isNaN(s))||(s<0||s>255))
  return true;
 else
  return false;
}
function IPfieldEntry(field) {
 if(isNaN(field.value.charAt(field.value.length-1))&&field.value.charAt(field.value.length-1)!='.')
  field.value=field.value.slice(0,field.value.length-1);
 field.value=parseInt(field.value);
}
function NumfieldEntry(field) {
 field.value=field.value.replace(/[^0-9]+/g, "");
}
function lastEntryChar(field,spchar) {
 if(field.value.charAt(field.value.length-1)==spchar) {
  field.value=field.value.slice(0,field.value.length-1);
  if(field.value.length)
   return(1);
 }
 return(0);
}
function isValidIpEntry(field,e) {
//	if(KeyCode(e)!=9) {
  IPfieldEntry(field);
  if(lastEntryChar(field,' '))
   field.value=field.value.substring(0,field.value.length);
  if(lastEntryChar(field,'.')||field.value.length==3) {
   if(isNValidIP(field.value)) {
    field.value="255";
    field.select();
    return false;
   }
   else if(field.value.length<3)
    focusOnNext(field);
  }
 //}
 return true;
}
function isValidIpEntry_1(field,e) {
//	if(KeyCode(e)!=9) {
  IPfieldEntry(field);
  if(lastEntryChar(field,' '))
   field.value=field.value.substring(0,field.value.length);
   if(lastEntryChar(field,'.')||field.value.length==3) {
    if(isNValidIP(field.value) || field.value <1 || field.value >223) {
     field.value="192";
     field.select();
     return -1;
    }
   else if(field.value==127) {
    field.value="192";
    field.select();
    return -2;
   }
   else if(field.value.length<3)
    focusOnNext(field);
  }
 //}
 return 1;
}
function printf(fmt) {
var reg = /%s/;
var result = new String(fmt);
 for (var i = 1; i < arguments.length; i++)
  result = result.replace(reg, new String(arguments[i]));
 document.write(result);
}
function isValidSubnetMask(mask) {
//m[0] can be 128, 192, 224, 240, 248, 252, 254, 255
//m[1] can be 128, 192, 224, 240, 248, 252, 254, 255 if m[0] is 255, else m[1] must be 0
//m[2] can be 128, 192, 224, 240, 248, 252, 254, 255 if m[1] is 255, else m[2] must be 0
//m[3] can be 128, 192, 224, 240, 248, 252, 254, 255 if m[2] is 255, else m[3] must be 0
var correct_range = {128:1,192:1,224:1,240:1,248:1,252:1,254:1,255:1,0:1};
var m = mask.split('.');
 for (var i = 0; i <= 3; i ++) {
  if (!(m[i] in correct_range)) {
   return -2;
  }
 }
 if (m.length!=4 || (m[0] != 255 && m[1] != 0) || (m[1] != 255 && m[2] != 0) || (m[2] != 255 && m[3] != 0)) {
  return -1;
 }
 return 1;
}
function isValidPort(port) {
var fromport = 0;
var toport = 100;
 portrange = port.split(':');
 if ( portrange.length < 1 || portrange.length > 2 ) {
  return false;
 }
 if ( isNaN(portrange[0]) )
  return false;
 fromport = parseInt(portrange[0]);
 if ( portrange.length > 1 ) {
  if ( isNaN(portrange[1]) )
   return false;
  toport = parseInt(portrange[1]);
  if ( toport <= fromport )
   return false;
 }
 if ( fromport < 1 || fromport > 65535 || toport < 1 || toport > 65535 )
  return false;
 return true;
}

function getCookie(c_name) {
var i,x,y,ARRcookies=document.cookie.split(";");
 for (i=0;i<ARRcookies.length;i++) {
  x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
  y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
  x=x.replace(/^\s+|\s+$/g,"");
  if (x==c_name) {
   return unescape(y);
  }
 }
 return "";
}

function setCookie(c_name, value) {
 	document.cookie=c_name + "=" + value;
}
function isValidMacAddress(address) {
var c = '';
var i = 0, j = 0;
 // Trim any trailing whitespace first
 address = address.replace(/\s+$/g,'');
 if ( address == 'ff:ff:ff:ff:ff:ff' ) return false;
 addrParts = address.split(':');
 if ( addrParts.length != 6 ) return false;
 for (i = 0; i < 6; i++) {
  if ( addrParts[i] == '' )
   return false;
  for ( j = 0; j < addrParts[i].length; j++ ) {
   c = addrParts[i].toLowerCase().charAt(j);
   if ( (c >= '0' && c <= '9') ||
    (c >= 'a' && c <= 'f') )
    continue;
   else
    return false;
  }
 }
 return true;
}
function IpCheck(IP1,IP2,IP3,IP4) {
 if (((isBlank(IP1))||(isNaN(IP1))||(IP1<0||IP1>255))||((isBlank(IP2))||(isNaN(IP2))||(IP2<0||IP2>255))||((isBlank(IP3))||(isNaN(IP3))||(IP3<0||IP3>255)) || ((isBlank(IP4))||(isNaN(IP4))||(IP4<0||IP4>255)))
  return false;
 else
  return true;
}
function set_var_tag() {
 $("var").css("font-style","normal");
 $("var").each(function(e) {
  this.innerHTML=eval($(this).html());
 });
}
function atoi(str, num) {
i=1;
 if(num != 1 ) {
  while (i != num && str.length != 0){
   if(str.charAt(0) == '.'){
    i++;
   }
   str = str.substring(1);
  }
  if(i != num )
   return -1;
 }
 for(i=0; i<str.length; i++) {
  if(str.charAt(i) == '.') {
   str = str.substring(0, i);
   break;
  }
 }
 if(str.length == 0)
  return -1;
 return parseInt(str, 10);
}
function isAllNum(str) {
 for (var i=0; i<str.length; i++){
  if((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.'))
   continue;
  return 0;
 }
 return 1;
}
function checkRange(str, num, min, max) {
 d = atoi(str,num);
 if(d > max || d < min)
  return false;
 return true;
}
//------------- functions for V2 UI-------------------------------
function set_menu(top, side, user) {
var user="";

var top_menu_list = ["Status", "Internet", "Services", "VoIP", "System"];
var c=new Array();
 $.each(top_menu_list, function(i,j) {c[j]="";});
 c[top]=" class='active'";
 //c["Help"]=" class='help' "

if(user=="root" || user=="admin" ){
  
var h_top="<div class='container'><header class='site-header'>	<a href='http://www.netcommwireless.com' target='_blank'><h1 class='grid-4 alpha'>M2M</h1></a>	<nav class='top-right grid-9 omega'>		<ul class='main-menu list-inline'>			<li"+c["Status"]+"><a href='status.htm'>Status</a></li>";
  h_top+="<li"+c["Internet"]+"><a href='primx.htm?Nwanif=0&Npvc='>Networking</a></li>";
  h_top+="<li"+c["Services"]+"><a href='upnp.htm'>Services</a></li>";
  h_top+="<li"+c["VoIP"]+"><a href='service_domain.htm'>VoIP</a></li>			<li"+c["System"]+"><a href='syslog0.htm'>System</a></li>		</ul>	</nav></header>	<div class='header_bar'>";
 if(typeof(multi_lang)!="undefined" && multi_lang>0) {
  h_top+="<div class='left-item'>";
  if(typeof(current_lang)!="undefined" && current_lang=="en") {
   h_top+="<a href='javascript:setLanguage(\"en\")'>English</a>";
  }
  else {
   h_top+="<a href='javascript:setLanguage(\"en\")' style='color:#aaa'>English</a>";
  }
  h_top+="</div>"
 }
 h_top+="<div class='right-item account-btn'>			<span class='login-foot'></span><span style='color:#fff;margin-left:65px;position:relative;top:-20px'>"+user+"</span>			<a href='index.htm' id='logOff' class='log-off'></a>		</div>	</div>	</div>";
 $("#main-menu").append(h_top);

 if(side!="") {
 switch(top) {
 case "Internet":
 
  //var rhyan_wan_menu_list = ["ADSL", "Ethernet_WAN", "Mobile_Broadband"];
  var rhyan_wan_menu_list = ["Ethernet_WAN", "Mobile_Broadband"];
  var rhyan_wan_menu_o = "";
  var rhyan_wan_menu_h = " hide";
  $.each(rhyan_wan_menu_list, function(i,j) {if (j==side){rhyan_wan_menu_o = " class='open'";rhyan_wan_menu_h = "";} });
 
  var lan_menu_list = ["LAN", "DHCP", "VLAN"];
  var lan_menu_o = "";
  var lan_menu_h = " hide";
  $.each(lan_menu_list, function(i,j) {if (j==side){lan_menu_o = " class='open'";lan_menu_h = "";} });

  var wlan_2_ap_menu_list = ["AP", "WPS", "WDS", "Station_Info"];
  var wlan_2_menu_o = "";
  var wlan_2_menu_h = " hide";
  $.each(wlan_2_ap_menu_list, function(i,j) {if (j==side){wlan_2_menu_o = " class='open'";wlan_2_menu_h = "";} });
  
  var wlan_5_ap_menu_list = ["AP5", "WPS5", "WDS5", "Station_Info5"];
  var wlan_5_menu_o = "";
  var wlan_5_menu_h = " hide";
  $.each(wlan_5_ap_menu_list, function(i,j) {if (j==side){wlan_5_menu_o = " class='open'";wlan_5_menu_h = "";} });

  var routing_menu_list = ["Router_Firewall", "Port_Forwarding", "Port_Triggering", "DMZ", "Packet_Filtering", "MAC_Filtering", "Domain_Filtering", "Static_Routing", "RIP", "URL_Blocking"];
  var routing_menu_o = "";
  var routing_menu_h = " hide";
  $.each(routing_menu_list, function(i,j) {if (j==side){routing_menu_o = " class='open'";routing_menu_h = "";} });

  var vpn_menu_list = ["IPSec", "l2tpClient", "l2tpServer", "pptpClient", "pptpServer"];
  var vpn_menu_o = "";
  var vpn_menu_h = " hide";
  $.each(vpn_menu_list, function(i,j) {if (j==side){vpn_menu_o = " class='open'";vpn_menu_h = "";} });

  var vpn_menu_list = ["IPSec", "l2tpClient", "l2tpServer", "pptpClient", "pptpServer"];
  var vpn_menu_o = "";
  var vpn_menu_h = " hide";
  $.each(vpn_menu_list, function(i,j) {if (j==side){vpn_menu_o = " class='open'";vpn_menu_h = "";} });

  var pocfg_menu_list = ["Port_cfg"];

  var side_menu_list;
  side_menu_list = rhyan_wan_menu_list.concat(lan_menu_list, wlan_2_ap_menu_list, wlan_5_ap_menu_list, routing_menu_list, vpn_menu_list, pocfg_menu_list);
  $.each(side_menu_list, function(i,j) {c[j]=" ";});
  

  
  c[side]=" class='active' ";
  var h_side="<ul>";
  h_side+="<ul>		<li"+rhyan_wan_menu_o+">			<a class='expandable'>WAN</a>			<div class='submenu"+rhyan_wan_menu_h+"'>";
  //h_side+="<a"+c["ADSL"]+"href='adsl.htm'>ADSL</a>";
  h_side+="<a"+c["Ethernet_WAN"]+"href='primx.htm?Nwanif=0&Npvc='>Ethernet WAN</a>";
  h_side+="<a"+c["Mobile_Broadband"]+"href='primx.htm?Nwanif=13&Npvc=&Nvid='>Mobile Broadband</a>";
  h_side+="</div>		</li>";
  
  h_side+="<li"+lan_menu_o+">			<a class='expandable'>LAN</a>			<div class='submenu"+lan_menu_h+"'>				<a"+c["LAN"]+"href='lan.htm'>LAN</a>				<a"+c["DHCP"]+"href='dhcp.htm'>DHCP</a>				<a"+c["VLAN"]+"href='vlan.htm'>VLAN</a>			</div>		</li>";
  
  h_side += "<li" + wlan_2_menu_o + ">              <a class='expandable'>" + "Wireless 2.4Ghz" + "</a>              <div class='submenu" + wlan_2_menu_h + "'>";
  h_side += "<a" + c["AP"] + "href='wlan.htm'>" + "Access" + " " + "Point" + "</a>" +
            "<a" + c["WPS"] + "href='wps.htm'>" + "WP" + "" + "S" + "</a>" +
            "<a" + c["WDS"] + "href='wds.htm'>" + "WD" + "" + "S" + "</a>" +
            "<a" + c["Station_Info"] + "href='wlstationlist.htm'>" + "Station" + " " + "Info" + "</a>";
  h_side += "</div></li>";

  h_side += "<li" + wlan_5_menu_o + "><a class='expandable'>" + "Wireless 5Ghz" + "</a><div class='submenu" + wlan_5_menu_h + "'>";
  h_side += "<a" + c["AP5"] + "href='wlan5.htm'>" + "Access" + " " + "Point" + "</a>" +
            "<a" + c["WPS5"] + "href='wps5.htm'>" + "WP" + "" + "S" + "</a>" +
            "<a" + c["WDS5"] + "href='wds5.htm'>" + "WD" + "" + "S" + "</a>" +
            "<a" + c["Station_Info5"] + "href='wlstationlist5.htm'>" + "Station" + " " + "Info" + "</a>";
  h_side += "</div></li>";

  h_side += "<li" + routing_menu_o + "><a class='expandable'>Routing</a><div class='submenu"+routing_menu_h+"'>";
  h_side += "<a" + c["Router_Firewall"] + "href='frwl.htm'>Router Firewall</a>" +
            "<a" + c["Port_Forwarding"] + "href='smap.htm'>Port Forwarding</a>" +
            "<a" + c["Port_Triggering"] + "href='port_triggering.htm'>Port Triggering</a>" +
            "<a" + c["DMZ"] + "href='dmz.htm'>DMZ</a>" +
            "<a" + c["Packet_Filtering"] + "href='port_filtering.htm'>Packet Filtering</a>" +
            "<a" + c["MAC_Filtering"] + "href='mac_filtering.htm'>MAC Filtering</a>" +
            "<a" + c["Domain_Filtering"] + "href='domain_filtering.htm'>Domain Filtering</a>" +
            "<a" + c["Static_Routing"] + "href='routing.htm'>Static Routing</a>" +
            "<a" + c["RIP"] + "href='rip.htm'>RIP</a>" +
            "<a" + c["URL_Blocking"] + "href='uctl.htm'>URL Blocking</a>";
  h_side += "</div></li>";

  h_side += "<li" + vpn_menu_o + "><a class='expandable'>VPN</a><div class='submenu"+vpn_menu_h+"'>";
  h_side += "<a" + c["IPSec"] + "href='vpn0.htm?rc=_&rf=0&Eb=0'>IPSec</a>" +
            "<a" + c["l2tpClient"] + "href='l2tpc.htm?rc=_&rf=0&Eb=0'>L2TP Client</a>" +
            "<a" + c["l2tpServer"] + "href='l2tps.htm?rc=_&rf=0&Eb=0'>L2TP Server</a>" +
            "<a" + c["pptpClient"] + "href='pptpc.htm?rc=_&rf=0&Eb=0'>PPTP Client</a>" +
            "<a" + c["pptpServer"] + "href='pptps.htm?rc=_&rf=0&Eb=0'>PPTP Server"+"</a>";
  h_side += "</div></li>";

  h_side += "<li><a" + c["Port_cfg"] + "href='port_cfg.htm'>Port Configuration</a></li>";
 break;

 case "Services":
   var side_menu_list = ["UPnP"
  , "DDNS"
  , "QoS"
  , "SNMP"
  , "NTP"
  , "Scheduling"
  , "IPv6"
  , "TR-069"
  ];
  var c=new Array();
  $.each(side_menu_list, function(i,j) {c[j]=" ";});
  
  c[side]=" class='active' ";
  var h_side="<ul>";
  h_side+="<li><a"+c["UPnP"]+"href='upnp.htm'>UPnP Settings</a></li>";
  h_side+="<li><a"+c["DDNS"]+"href='ddns.htm'>DDNS</a></li>";
  h_side+="<li><a"+c["QoS"]+"href='balance.htm'>QoS</a></li>";
  h_side+="<li><a"+c["SNMP"]+"href='snmp.htm'>SNMP</a></li>";
  h_side+="<li><a"+c["NTP"]+"href='ntp.htm'>NTP</a></li>";
  h_side+="<li><a"+c["Scheduling"]+"href='sche.htm'>Scheduling</a></li>";
  h_side+="<li><a"+c["IPv6"]+"href='ipv6.htm'>IPv6</a></li>";
  h_side+="<li><a"+c["TR-069"]+"href='tr069.htm'>TR-069</a></li>";
  
  h_side+="</ul>";
 break;

case "VoIP":
  var configuration_menu_list = ["Service_Domain", "Port_Settings", "CODEC_Settings", "DTMF_Settings", "STUN_Settings", "Telephony_Profile", "Dial_Plan", "Other_Settings"];
  var configuration_menu_o = "";
  var configuration_menu_h = " hide";
  $.each(configuration_menu_list, function(i,j) {if (j==side){configuration_menu_o = " class='open'";configuration_menu_h = "";} });

  var call_features_menu_list = ["Call_Forward", "DND_Settings", "Caller_ID", "Flash_Time", "Call_Waiting", "Hot_Line", "Key_Combination"];
  var call_features_menu_o = "";
  var call_features_menu_h = " hide";
  $.each(call_features_menu_list, function(i,j) {if (j==side){call_features_menu_o = " class='open'";call_features_menu_h = "";} });

  var side_menu_list = ["Service_Domain"
  , "Port_Settings"
  , "CODEC_Settings"
  , "DTMF_Settings"
  , "STUN_Settings"
  , "Telephony_Profile"
  , "Dial_Plan"
  , "Other_Settings"
  , "Call_Forward"
  , "DND_Settings"
  , "Caller_ID"
  , "Flash_Time"
  , "Call_Waiting"
  , "Hot_Line"
  , "Key_Combination"
  , "Phone_Book"
  ];
  var c=new Array();
  $.each(side_menu_list, function(i,j) {c[j]=" ";});

  c[side]=" class='active' ";
  var h_side="<ul>";
  h_side+="<li"+configuration_menu_o+"><a class='expandable'>Configurations</a><div class='submenu"+configuration_menu_h+"'>";
    h_side+="<a"+c["Service_Domain"]+"href='service_domain.htm'>Service Domain</a>";
    h_side+="<a"+c["Port_Settings"]+"href='port_settings.htm'>Port Settings</a>";
    h_side+="<a"+c["CODEC_Settings"]+"href='codec_settings.htm'>CODEC Settings</a>";
    h_side+="<a"+c["DTMF_Settings"]+"href='dtmf_settings.htm'>DTMF Settings</a>";
    h_side+="<a"+c["STUN_Settings"]+"href='stun_settings.htm'>STUN Settings</a>";
    h_side+="<a"+c["Telephony_Profile"]+"href='telephony_profile.htm'>Telephony Profile</a>";
    h_side+="<a"+c["Dial_Plan"]+"href='voip_dialp.htm'>Dial Plan</a>";
    h_side+="<a"+c["Other_Settings"]+"href='voip_other_settings.htm'>Other Settings</a>";
  h_side+="</div></li>";
  h_side+="<li"+call_features_menu_o+"><a class='expandable'>Call Features</a><div class='submenu"+call_features_menu_h+"'>";
    h_side+="<a"+c["Call_Forward"]+"href='call_forward.htm'>Call Forward</a>";
    h_side+="<a"+c["DND_Settings"]+"href='dnd_settings.htm'>DND Settings</a>";
    h_side+="<a"+c["Caller_ID"]+"href='caller_id.htm'>Caller ID</a>";
    h_side+="<a"+c["Flash_Time"]+"href='flash_time.htm'>Flash Time</a>";
    h_side+="<a"+c["Call_Waiting"]+"href='call_waiting.htm'>Call Waiting</a>";
    h_side+="<a"+c["Hot_Line"]+"href='hot_line.htm'>Hot Line</a>";
    h_side+="<a"+c["Key_Combination"]+"href='voip_keycomb.htm'>Key Combination</a>";
  h_side+="</div></li>";
  h_side+="<li><a"+c["Phone_Book"]+"href='phone_book.htm'>Phone Book</a></li>";
  
  h_side+="</ul>";
 break;
 
 case "System":
  var log_menu_list = ["LOG", "LOG_Setting"];
  var log_menu_o = "";
  var log_menu_h = " hide";
  $.each(log_menu_list, function(i,j) {if (j==side){log_menu_o = " class='open'";log_menu_h = "";} });

  var admin_menu_list = ["atbox", "Access_Control_List", "LED_Brightness"];
  var admin_menu_o = "";
  var admin_menu_h = " hide";
  $.each(admin_menu_list, function(i,j) {if (j==side){admin_menu_o = " class='open'";admin_menu_h = "";} });

  var config_menu_list = ["Device_Configuration", "Firmware_Upgrade"];
  var config_menu_o = "";
  var config_menu_h = " hide";
  $.each(config_menu_list, function(i,j) {if (j==side){config_menu_o = " class='open'";config_menu_h = "";} });

   side_menu_list = ["LOG"
   , "LOG_Setting"
   , "atbox"
   , "Access_Control_List"
   , "LED_Brightness"
   , "Diagnostics"
   , "Device_Configuration"
   , "Firmware_Upgrade"
   , "Wizard"
   , "Reboot"];

  var c=new Array();
  $.each(side_menu_list, function(i,j) {c[j]=" ";});
  c[side]=" class='active' ";

   var h_side="<ul><li"+log_menu_o+"><a class='expandable'>Log</a><div class='submenu"+log_menu_h+"'><a"+c["LOG"]+"href='syslog0.htm'>System Log</a><a"+c["LOG_Setting"]+"href='logs.htm'>System log Settings</a></div></li>";
   h_side+="<li"+admin_menu_o+"><a class='expandable'>Administration</a><div class='submenu"+admin_menu_h+"'><a"+c["atbox"]+"href='atbox.htm'>Change Password</a><a"+c["Access_Control_List"]+"href='acl.htm'>System Administration</a><a"+c["LED_Brightness"]+"href='led.htm'>LED Brightness</a></div></li>";
   h_side+="<li><a"+c["Diagnostics"]+"href='diagnostics.htm'>Diagnostics</a></li>";
   h_side+="<li"+config_menu_o+"><a class='expandable'>System Configuration</a><div class='submenu"+config_menu_h+"'><a"+c["Device_Configuration"]+"href='bkconfig.htm'>Device Configuration</a><a"+c["Firmware_Upgrade"]+"href='fwug.htm'>Firmware Upgrade</a></div></li>";
   h_side+="<li><a"+c["Wizard"]+"href='wizard.htm'>Startup Wizard</a></li>";
   h_side+="<li><a"+c["Reboot"]+"href='reboot.htm'>Reboot</a></li></ul>";
 break;
 }

 $("#side-menu").append(h_side);
 //alert(h_side)
 }
 set_var_tag();
 $.get("/cgi-bin/rdb.cgi?service.pppoe.server.0.enable&service.pppoe.server.0.wanipforward_enable", function(v) {
 eval(v);
 if(typeof(service_pppoe_server_0_enable)==="undefined" || typeof(service_pppoe_server_0_wanipforward_enable)==="undefined")
  return;
 if(service_pppoe_server_0_enable=="1" && service_pppoe_server_0_wanipforward_enable=="1") {
  $(".hide_for_pppoe_en").css("display", "none");
  $(".pppoeEnablesMsg").css("display", "");
 }
 });
 $.get("/cgi-bin/usermenu.cgi", function(v) {
  if (v!="") {
   $("#customMenu").css("display", "");
   $("#subCustomMenu").html(v);
  }
 });
 $("input[type=text]").keyup(function(e) {
  var code = e.keyCode || e.which;
  if (code == '9') {
   $(this).select();
  }
 });
 $(document).attr("title", "NetComm Wireless Router");
}else{
	// not login
	var h_top="<div class='container'><header class='site-header'><a href='http://www.netcommwireless.com' target='_blank'><h1 class='grid-4 alpha'>M2M</h1></a><nav class='top-right grid-9 omega'><ul class='main-menu list-inline'>";
	h_top+="<li"+c["Status"]+"><a href='status0.htm' style='cursor:pointer;'>Status</a></li>";
  h_top+="<li"+c["Internet"]+"><a href='index.htm' style='cursor:pointer;'>Networking</a></li>";
  h_top+="<li"+c["Services"]+"><a href='index.htm' style='cursor:pointer;'>Services</a></li>";
  h_top+="<li"+c["VoIP"]+"><a  href='index.htm'style='cursor:pointer;'>VoIP</a></li>";
  h_top+="<li"+c["System"]+"><a href='index.htm' style='cursor:pointer;'>System</a></li></ul></nav></header><div class='header_bar'>";

 if(typeof(multi_lang)!="undefined" && multi_lang>0) {
  h_top+="<div class='left-item'>";
  if(typeof(current_lang)!="undefined" && current_lang=="en") {
   h_top+="<a href='javascript:setLanguage(\"en\")'>English</a>";
  }
  else {
   h_top+="<a href='javascript:setLanguage(\"en\")' style='color:#aaa'>English</a>";
  }
  h_top+="</div>"
 }
 h_top+="<div class='right-item account-btn'>			<span class='login-foot'></span><span style='color:#fff;margin-left:65px;position:relative;top:-20px'>"+user+"</span>			<a href='index.htm' id='logOff' class='log-off'></a>		</div>	</div>	</div>";
 $("#main-menu").append(h_top);
}}

function blockUI_alert(msg, func) {
 if($.type(func)!="undefined") {
  myfunc=func;
 }
 else {
  myfunc=function() {
  };
 }
 $.blockUI( {message: msg+"		<div class='button-raw med'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>OK</button>		</div>", css: {width:'320px', padding:'20px 20px'}
 });
}
function blockUI_alert_l(msg, func) {
 if($.type(func)!="undefined") {
  myfunc=func;
 }
 else {
  myfunc=function() {
  };
 }
 if($.type(msg)!="undefined" && msg.length>50) {
  align="left";
 }
 else {
  align="center";
 }
 $.blockUI( {message: "<div style='text-align:"+align+";'>"+msg+"		<div class='button-raw med'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>OK</button>		</div></div>", css: {width:'320px', padding:'20px 20px'}
 });
}
function blockUI_confirm(msg, func) {
 myfunc=func;
 $.blockUI( {message: msg+"		<div class='button-double'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>"+"OK"+"</button><button class='secondary med' onClick='$.unblockUI();'>"+"Cancel"+"</button>		</div>", css: {width:'380px', padding:'20px 20px'}
 });
}
function blockUI_confirm_l(msg, func) {
 myfunc=func;
  if(msg.length>50) {
  align="left";
 }
 else {
  align="center";
 }
 $.blockUI( {message: "<div style='text-align:"+align+";'>"+msg+"		<div class='button-double'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>"+"OK"+"</button><button class='secondary med' onClick='$.unblockUI();'>"+"Cancel"+"</button>		</div></div>", css: {width:'380px', padding:'20px 20px'}
 });
}
/************************* Validator *******************************/
function validate_alert( t1, t2 ) {
 $.unblockUI();
 if(typeof(t1)=="undefined" || t1=="") {
  t1="Oops, something went wrong...";
 }
 if(typeof(t2)=="undefined" || t2=="") {
  t2=eval(VALIDATOR.config.errors.summary);
 }
 var e=$(window.document.forms[0]), g="form-error";
 a='<li><a class="link-text jump-link" href="#{id}"><span class="icon icon-arrow-r"></span>{error}</a></li>';
 h='<div class="note" id="'+g+'">			<div class="wrap failure">				<h2><span class="access">'+VALIDATOR.config.strings.error+'</span>'+t1+'</h2>				<p>'+t2+'</p>				<ul class="list-plain"></ul>			</div>		</div>';
 h=$(h);
 if(e.attr("data-summary")==="false") {
  return;
 }
 e.prev(".note").remove();
 e.before(h);
 window.location.hash=g;
 $("#form").validationEngine("updatePromptsPosition");
}
function clear_alert() {
 var e=$(window.document.forms[0]);
 e.prev(".note").remove();
 $("#form").validationEngine("hideAll");
}
function success_alert(t1, t2) {
 if(typeof(t1)=="undefined" || t1=="") {
  t1="Success!";
 }
 if(typeof(t2)=="undefined" || t2=="") {
  t2="Your configuration changes were successfully saved and applied";
 }
 var e=$(window.document.forms[0]), g="form-success";
 h='<div class="note" onclick="clear_alert();"><div class="wrap success" style="padding-bottom:6px"><h2>'+t1+'</h2><p>'+t2+'</p></div></div>';
 h=$(h);
 if(e.attr("data-summary")==="false") {
  return;
 }
 e.prev(".note").remove();
 e.before(h);
 window.location.hash=g;
}
(function(){this.VALIDATOR={}}).call(this);
(function() {
VALIDATOR.config={
 strings:{
  error: "'Error'+' - '"
 },
 errors:{
  error: "'Error'+' - '",
  summary: "'Please correct these error(s).'",
  title: "'Sorry there has been {number} error(s)'"
 }
};
}(VALIDATOR));
/*************************************************************/
(function($) {
$.fn.validationEngineLanguage = function(){};
$.validationEngineLanguage = {
 newLang: function(){
  $.validationEngineLanguage.allRules = {
   "required": { // Add your regex rules here, you can take telephone as an example
    "regex": "none",
    "alertText": "'This field is required.'",
    "alertTextCheckboxMultiple": "* Please select an option",
    "alertTextCheckboxe": "* This checkbox is required",
    "alertTextDateRange": "* Both date range fields are required"
   },
   "requiredInFunction": {
    "func": function(field, rules, i, options){
     return (field.val() == "test") ? true : false;
    },
    "alertText": "* Field must equal test"
   },
   "dateRange": {
    "regex": "none",
    "alertText": "* Invalid ",
    "alertText2": "Date Range"
   },
   "dateTimeRange": {
    "regex": "none",
    "alertText": "* Invalid ",
    "alertText2": "Date Time Range"
   },
   "minSize": {
    "regex": "none",
    "alertText": "* Minimum ",
    "alertText2": " characters required"
   },
   "maxSize": {
    "regex": "none",
    "alertText": "* Maximum ",
    "alertText2": " characters allowed"
   },
   "groupRequired": {
    "regex": "none",
    "alertText": "'You must fill in one of these fields'"
   },
   "min": {
    "regex": "none",
    "alertText": "* Minimum value is "
   },
   "max": {
    "regex": "none",
    "alertText": "* Maximum value is "
   },
   "past": {
    "regex": "none",
    "alertText": "* Date prior to "
   },
   "future": {
    "regex": "none",
    "alertText": "* Date past "
   },
   "maxCheckbox": {
    "regex": "none",
    "alertText": "* Maximum ",
    "alertText2": " options allowed"
   },
   "minCheckbox": {
    "regex": "none",
    "alertText": "* Please select ",
    "alertText2": " options"
   },
   "equals": {
    "regex": "none",
    "alertText": "Password mismatched!"
   },
   "creditCard": {
    "regex": "none",
    "alertText": "* Invalid credit card number"
   },
   "phone": {
    // credit: jquery.h5validate.js / orefalo
    "regex": /^([\+][0-9]{1,3}[\ \.\-])?([\(]{1}[0-9]{2,6}[\)])?([0-9\ \.\-\/]{3,20})((x|ext|extension)[\ ]?[0-9]{1,4})?$/,
    "alertText": "* Invalid phone number"
   },
   "email": {
    // HTML5 compatible email regex ( http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#    e-mail-state-%28type=email%29 )
    "regex": /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
    "alertText": "* Invalid email address"
   },
   "integer": {
    "regex": /^[\-\+]?\d+$/,
    "alertText": "* Not a valid integer"
   },
   "number": {
    // Number, including positive, negative, and floating decimal. credit: orefalo
    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,
    "alertText": "* Invalid floating decimal number"
   },
   "date": {
    //	Check if date is valid by leap year
  "func": function (field) {
    var pattern = new RegExp(/^(\d{4})[\/\-\.](0?[1-9]|1[012])[\/\-\.](0?[1-9]|[12][0-9]|3[01])$/);
    var match = pattern.exec(field.val());
    if (match == null)
     return false;
    var year = match[1];
    var month = match[2]*1;
    var day = match[3]*1;
    var date = new Date(year, month - 1, day); // because months starts from 0.
    return (date.getFullYear() == year && date.getMonth() == (month - 1) && date.getDate() == day);
   },
   "alertText": "* Invalid date, must be in YYYY-MM-DD format"
   },
   "ipv4": {
    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,
    "alertText": "* Invalid IP address"
   },
   "url": {
    //"regex": too long for uiwb, removed!
    "alertText": "* Invalid URL"
   },
   "onlyNumberSp": {
    "regex": /^[0-9\ ]+$/,
    "alertText": "* Numbers only"
   },
   "onlyLetterSp": {
    "regex": /^[a-zA-Z\ \']+$/,
    "alertText": "* Letters only"
   },
   "onlyLetterNumber": {
    "regex": /^[0-9a-zA-Z]+$/,
    "alertText": "* No special characters allowed"
   },
   // --- CUSTOM RULES -- Those are specific to the demos, they can be removed or changed to your likings
   "ajaxUserCall": {
    "url": "ajaxValidateFieldUser",
    // you may want to pass extra data on the ajax call
    "extraData": "name=eric",
    "alertText": "* This user is already taken",
    "alertTextLoad": "* Validating, please wait"
   },
   "ajaxUserCallPhp": {
    "url": "phpajax/ajaxValidateFieldUser.php",
    // you may want to pass extra data on the ajax call
    "extraData": "name=eric",
    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
    "alertTextOk": "* This username is available",
    "alertText": "* This user is already taken",
    "alertTextLoad": "* Validating, please wait"
   },
   "ajaxNameCall": {
    // remote json service location
    "url": "ajaxValidateFieldName",
    // error
    "alertText": "* This name is already taken",
    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
    "alertTextOk": "* This name is available",
    // speaks by itself
    "alertTextLoad": "* Validating, please wait"
   },
    "ajaxNameCallPhp": {
     // remote json service location
     "url": "phpajax/ajaxValidateFieldName.php",
     // error
     "alertText": "* This name is already taken",
     // speaks by itself
     "alertTextLoad": "* Validating, please wait"
    },
   "validate2fields": {
    "alertText": "* Please input HELLO"
   },
   //tls warning:homegrown not fielded
   "dateFormat":{
    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/,
    "alertText": "* Invalid Date"
   },
   //tls warning:homegrown not fielded
   "dateTimeFormat": {
    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/,
    "alertText": "* Invalid Date or Date Format",
    "alertText2": "Expected Format: ",
    "alertText3": "mm/dd/yyyy hh:mm:ss AM|PM or ",
    "alertText4": "yyyy-mm-dd hh:mm:ss AM|PM"
   }
  };
 }
};
$.validationEngineLanguage.newLang();
})(jQuery);
//----------------------------------------------------------------------------------------------------
//   UTIL.JS FILE INCLUDING CHECK END
//----------------------------------------------------------------------------------------------------
}
