#!/bin/sh
#
# Dual use CGI and startup script for PAD daemon
# To launch the daemon according to the /etc/cdcs/padd_settings_*.sh files,
# Invoke with nocgi as the first option.

if [ -z  "${SESSION_ID}" -o "${SESSION_ID}" != "${sessionid}" ]; then
	exit 0
fi

override_enable_by_rdb() {
	# override padd enable flag if rdb padd enable flag exists
	RDB_PADD_ENABLE=`rdb_get confv250.padd_enable 2> /dev/null`
	if [ -n "$RDB_PADD_ENABLE" ]; then
		PADD_ENABLE="$RDB_PADD_ENABLE"
	fi
}


if [ "$1" = "nocgi" ]; then
# Just start the local port server, the USB servers have a delayed start
# which is handled by paddusbdetect.sh
	if [ -e /dev/ttyS4 ]; then
		# 882
		DEVNODE=/dev/ttyS4
	else
		# Bovine
		. /etc/variant.sh && DEVNODE="$V_SERIAL"
		if [ -z "${DEVNODE}" ]; then
			DEVNODE=/dev/ttyS2
		fi
	fi
	DEVNAME=LOCAL
	. /etc/cdcs/padd_settings_default.sh $DEVNODE
	SFILE=/etc/cdcs/padd_settings_$DEVNAME.sh
	if [ -f $SFILE ]; then
		. "$SFILE"
	fi

	override_enable_by_rdb

	if [ $PADD_ENABLE = 1 ]; then
		paddrestart.sh $DEVNODE $DEVNAME START
	fi
	exit
fi

echo -e 'Content-type: text/html\n'
echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'
echo '<html xmlns="http://www.w3.org/1999/xhtml">'
echo '<head>'
echo '  <meta http-equiv="Pragma" content="no-cache">'
echo '  <meta http-equiv="Expires" content="-1">'
echo '  <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">'
echo '  <title>PAD Daemon</title>'
if [ -e /www/cdcs.css ]; then
echo '  <link href="/cdcs.css" rel="stylesheet" type="text/css" />'
elif [ -e /www/linkFiles/790.css ]; then
echo '  <link href="/linkFiles/790.css" rel="stylesheet" type="text/css" />'
elif [ -e /www/BovineStyle.css ]; then
echo '  <link href="/BovineStyle.css" rel="stylesheet" type="text/css" />'
fi
echo '</head>'
echo '<body>'

echo '<div id="contentWrapper-2">'
echo '<h2>PAD Daemon</h2>'
echo '<a href="/">Return</a>'
echo '<div class="line" style="margin: 8px 25% 16px 0;"></div>'

# Shows details for a port and generates a link to the port detail page.
portsummary() {
	. /etc/cdcs/padd_settings_default.sh $1
	SFILE="/etc/cdcs/padd_settings_$2.sh"
	if [ -f "$SFILE" ]; then
		. "$SFILE";
	fi
	
	override_enable_by_rdb

	LINK="paddport.cgi?DEVNODE=`echo $1 | awk '{gsub("/","%2F"); print}' -`&DEVNAME=$2"

	echo '  <tr>'
	echo "    <td width=\"30%\">$2</td>"
	echo '    <td>'
	if [ "$PADD_ENABLE" = "1" ]; then
		echo "$PADD_BAUD,$PADD_PAR,$PADD_BITS,$PADD_STOPB - TCP PORT $PADD_PORT - <a href=\"$LINK\">CHANGE</a>"
	else
		echo "DISABLED - <a href=\"$LINK\">CHANGE</a>"
	fi
	echo '    </td>'
	echo '  </tr>'
}

# List available ports with links to paddport.cgi
echo '<table width="75%">'
echo '  <tr><th>AVAILABLE SERIAL PORTS</th></tr>'
echo '</table>'
echo '<table width="75%">'

if [ -e /dev/ttyS4 ]; then
	# 882 / 780 / 790 / etc.
	portsummary /dev/ttyS4 LOCAL
else
	# Bovine
	portsummary /dev/ttyS2 LOCAL
fi
for i in /dev/usb/tts/*; do
	if [ "$i" = "/dev/usb/tts/*" ]; then break; fi
	portsummary $i USB`basename $i`
done

echo '</table>'

echo "<p></p><p></p><pre>"
echo -n "$MESSAGE"
echo "</pre>"

echo '</body>'
echo '</html>'
