// PLEASE NOTE THAT A SPACE BETWEEN TWO WORDS IS TAKEN AS TWO SEPERATE
// WORDS. PLEASE KEEP THIS FILE CONSISTENT.
var portName_L = new Array();
var portName_U = new Array();

// For each Linux interface name in the boardparms.c file, add
// a corresponding Linux interface name and a user-friendly name
// of its equivalent that must be displayed on the WEB UI. It is
// best if the new inteface names are added at the end.

// Wireless interfac Linux interface name
portName_L[0]    = 'wl0';
// Wireless interface user-friendly name
portName_U[0]     = 'Wireless';

// USB interface Linux interface name
portName_L[1]    = 'usb0';
// USB user-friendly name
portName_U[1]    = 'USB';

// Board ID 96338SV Linux name
portName_L[2]     = '96338SV|eth0';
// Board ID 96338SV user-friendly name
portName_U[2]     = '96338SV|ENET';

//Board ID 96338L-2M-8M Linux name
portName_L[3]     = '96338L-2M-8M|eth0';
//Board ID 96338L-2M-8M user-friendly name
portName_U[3]     = '96338L-2M-8M|ENET';

// Board ID 96345R Linux name
portName_L[4]     = '96345R|eth0';
// Board ID 96345R user-friendly name
portName_U[4]     = '96345R|ENET';

// Board ID 96345GW2 Linux names
portName_L[5]     = '96345GW2|eth0';
portName_L[6]     = '96345GW2|eth0.2';
portName_L[7]     = '96345GW2|eth0.3';
portName_L[8]     = '96345GW2|eth0.4';
portName_L[9]     = '96345GW2|eth0.5';
// Board ID 96345GW2 user-friendly names
portName_U[5]     = '96345GW2|ENET(1-4)';
portName_U[6]     = '96345GW2|ENET4';
portName_U[7]     = '96345GW2|ENET3';
portName_U[8]     = '96345GW2|ENET2';
portName_U[9]     = '96345GW2|ENET1';


// Board ID 96345GW Linux name
portName_L[10]    = '96345GW|eth0';
portName_L[11]    = '96345GW|eth0.2';
portName_L[12]    = '96345GW|eth0.3';
portName_L[13]    = '96345GW|eth0.4';
portName_L[14]    = '96345GW|eth0.5';
// Board ID 96345GW user-friendly names
portName_U[10]    = '96345GW|ENET(1-4)';
portName_U[11]    = '96345GW|ENET4';
portName_U[12]    = '96345GW|ENET3';
portName_U[13]    = '96345GW|ENET2';
portName_U[14]    = '96345GW|ENET1';

// Board ID 96335R Linux name
portName_L[15]    = '96335R|eth0';
// Board ID 96335R user-friendly name
portName_U[15]    = '96335R|ENET';

// Board ID 96345R0 Linux name
portName_L[16]    = '96345R0|eth0';
// Board ID 96345R0 user-friendly name
portName_U[16]    = '96345R0|ENET';

// Board ID 96345RS Linux name
portName_L[17]    = '96345RS|eth0';
// Board ID 96345RS user-friendly name
portName_U[17]    = '96345RS|ENET';

// Board ID 96348R Linux name
portName_L[18]    = '96348R|eth0';
// Board ID 96348R user-friendly name
portName_U[18]    = '96348R|ENET';

// Board ID 96348LV Linux name
portName_L[19]    = '96348LV|eth0';
portName_L[20]    = '96348LV|eth1';
// Board ID 96348LV user-friendly name
portName_U[19]    = '96348LV|ENET1';
portName_U[20]    = '96348LV|ENET2';

// Board ID 96348GW Linux name
portName_L[21]    = '96348GW|eth0';
portName_L[22]    = '96348GW|eth1';
portName_L[23]    = '96348GW|eth1.2';
portName_L[24]    = '96348GW|eth1.3';
portName_L[25]    = '96348GW|eth1.4';
// Board ID 96348GW user-friendly name
portName_U[21]    = '96348GW|ENET4';
portName_U[22]    = '96348GW|ENET(1-3)';
portName_U[23]    = '96348GW|ENET1';
portName_U[24]    = '96348GW|ENET2';
portName_U[25]    = '96348GW|ENET3';

// Board ID 96348GW-10 Linux name
portName_L[26]    = '96348GW-10|eth0';
portName_L[27]    = '96348GW-10|eth1';
portName_L[28]    = '96348GW-10|eth1.2';
portName_L[29]    = '96348GW-10|eth1.3';
portName_L[30]    = '96348GW-10|eth1.4';
// Board ID 96348GW-10 user-friendly name
portName_U[26]    = '96348GW-10|ENET4';
portName_U[27]    = '96348GW-10|ENET(1-3)';
portName_U[28]    = '96348GW-10|ENET1';
portName_U[29]    = '96348GW-10|ENET2';
portName_U[30]    = '96348GW-10|ENET3';

// Board ID 96348GW-11 Linux name
portName_L[31]    = '96348GW-11|eth0';
portName_L[32]    = '96348GW-11|eth0.2';
portName_L[33]    = '96348GW-11|eth0.3';
portName_L[34]    = '96348GW-11|eth0.4';
portName_L[35]    = '96348GW-11|eth0.5';
// Board ID 96348GW-11 user-friendly name
portName_U[31]    = '96348GW-11|ENET(1-4)';
portName_U[32]    = '96348GW-11|ENET4';
portName_U[33]    = '96348GW-11|ENET3';
portName_U[34]    = '96348GW-11|ENET2';
portName_U[35]    = '96348GW-11|ENET1';

// Board ID 96348SV Linux name
portName_L[36]    = '96348SV|eth0';
portName_L[37]    = '96348SV|eth1';
// Board ID 96348SV user-friendly name
portName_U[36]    = '96348SV|ENET1';
portName_U[37]    = '96348SV|ENET2';

function getUNameByLName(name) {
   var index = 0;
   var uName   = '';

   // SafetyNet if someone sends a name without prefixing the
   // board ID and |, then return that name.
   if (name.indexOf('|') == -1)
      return name;
   if (name.indexOf('wl0') != -1) {
      return 'Wireless';
   }
   if (name.indexOf('usb0') != -1) {
      return 'USB';
   }
   for (index = 0; index < portName_L.length; index++) {
      if (portName_L[index] == name) {
         uName = portName_U[index].split('|');
         return uName[1];
      }
   }
   uName = name.split('|');
   return uName[1];
}

function getLNameByUName(name) {
   var index = 0;
   var brdIntf = name.split('|');
   var lName   = '';
   var uName   = '';

   // SafetyNet if someone sends a name without prefixing the
   // board ID and |, then return that name.
   if (name.indexOf('|') == -1)
      return name;
   if (name.indexOf('Wireless') != -1)
      return 'wl0';
   if (name.indexOf('USB') != -1)
      return 'usb0';
   for (index = 0; index < portName_U.length; index++) {
      uName = portName_U[index].split('|');
      if (portName_U[index] == name) {
         lName = portName_L[index].split('|');
         return lName[1];
      }
   }
   lName = name.split('|');
   return lName[1];
}
