-- auto generated by luaScriptGen.js.
function isValidSnmpUserName(val)
 if val and #val >= 1 and #val <= 31 and val:match('^[a-zA-Z0-9]+$') then
  return true
 end
 return false
end
objHander = {
  pageURL='/snmp.html',
  authenticatedOnly=true,
  get=function(authenticated)
    local o
    ={}
    luardb.lock()
    o.snmpenable=getRdb('service.snmp.enable')
    o.snmpPort=getRdb('service.snmp.port.new')
    o.secVers=getRdb('service.snmp.version')
    o.snmpROCommunityName=getRdb('service.snmp.name.readonly')
    o.snmpRWCommunityName=getRdb('service.snmp.name.readwrite')
    o.snmpEngineIdSuffix=encode(getRdb('service.snmp.engine_id_suffix'))
    o.snmpUserName=getRdb('service.snmp.username')
    o.snmpSecurityLevel=getRdb('service.snmp.security_level')
    o.snmpAuthProt=getRdb('service.snmp.auth_prot')
    o.snmpAuthPassphrase=encode(getRdb('service.snmp.auth_passphrase'))
    o.snmpPrivProt=getRdb('service.snmp.priv_prot')
    o.snmpPrivPassphrase=encode(getRdb('service.snmp.priv_passphrase'))
    o.isMibFile=file_exists('/www/snmp.mib')
    luardb.unlock()
    return o
  end,
  validate=function(o)
    local v
    v=o.snmpenable if isValid.Bool(v)==false then return false,'oops! '..'snmpenable' end if toBool(v) == false then return true end
    v=o.snmpPort if isValid.BoundedInteger(v,0,65535)==false or (#v<=64)==false then return false,'oops! '..'snmpPort' end
    v=o.secVers if isValid.Enum(v,{'v1v2c','v3'})==false then return false,'oops! '..'secVers' end
    v=o.snmpROCommunityName if isValid.Hostname(v)==false then return false,'oops! '..'snmpROCommunityName' end
    v=o.snmpRWCommunityName if isValid.Hostname(v)==false then return false,'oops! '..'snmpRWCommunityName' end
    if o.secVers=='v3' then v=o.snmpEngineIdSuffix v = decode(v) if #v > 0 then if (#v>=1)==false or (#v<=27)==false then return false,'oops! '..'snmpEngineIdSuffix' end end end
    if o.secVers=='v3' then v=o.snmpUserName if (#v<=31)==false or isValidSnmpUserName(v)==false then return false,'oops! '..'snmpUserName' end end
    if o.secVers=='v3' then v=o.snmpSecurityLevel if isValid.Enum(v,{'noAuthNoPriv','authNoPriv','authPriv'})==false then return false,'oops! '..'snmpSecurityLevel' end end
    if o.secVers=='v3' and o.snmpSecurityLevel ~= 'noAuthNoPriv' then v=o.snmpAuthProt if isValid.Enum(v,{'md5','sha'})==false then return false,'oops! '..'snmpAuthProt' end end
    if o.secVers=='v3' and o.snmpSecurityLevel ~= 'noAuthNoPriv' then v=o.snmpAuthPassphrase v = decode(v) if (#v>=8)==false or (#v<=128)==false then return false,'oops! '..'snmpAuthPassphrase' end end
    if o.secVers=='v3' and o.snmpSecurityLevel == 'authPriv' then v=o.snmpPrivProt if isValid.Enum(v,{'des','aes'})==false then return false,'oops! '..'snmpPrivProt' end end
    if o.secVers=='v3' and o.snmpSecurityLevel == 'authPriv' then v=o.snmpPrivPassphrase v = decode(v) if (#v>=8)==false or (#v<=128)==false then return false,'oops! '..'snmpPrivPassphrase' end end
    return true
  end,
  set=function(authenticated,o)
    local v
    luardb.lock()
    repeat
    v=o.snmpenable setRdb('service.snmp.enable', v) if toBool(v) == false then break end
    v=o.snmpPort setRdb('service.snmp.port.new', v)
    v=o.secVers setRdb('service.snmp.version', v)
    v=o.snmpROCommunityName setRdb('service.snmp.name.readonly', v)
    v=o.snmpRWCommunityName setRdb('service.snmp.name.readwrite', v)
    if o.secVers=='v3' then v=o.snmpEngineIdSuffix v=decode(v) setRdb('service.snmp.engine_id_suffix', v) end
    if o.secVers=='v3' then v=o.snmpUserName setRdb('service.snmp.username', v) end
    if o.secVers=='v3' then v=o.snmpSecurityLevel setRdb('service.snmp.security_level', v) end
    if o.secVers=='v3' and o.snmpSecurityLevel ~= 'noAuthNoPriv' then v=o.snmpAuthProt setRdb('service.snmp.auth_prot', v) end
    if o.secVers=='v3' and o.snmpSecurityLevel ~= 'noAuthNoPriv' then v=o.snmpAuthPassphrase v=decode(v) setRdb('service.snmp.auth_passphrase', v) end
    if o.secVers=='v3' and o.snmpSecurityLevel == 'authPriv' then v=o.snmpPrivProt setRdb('service.snmp.priv_prot', v) end
    if o.secVers=='v3' and o.snmpSecurityLevel == 'authPriv' then v=o.snmpPrivPassphrase v=decode(v) setRdb('service.snmp.priv_passphrase', v) end
    until(true)
    luardb.unlock()
  end
}
