function _(str){
    if ((typeof xlat !== "undefined")){
        var newStr=xlat[str];
        if(newStr) {
            newStr = newStr.replace(/&#x2F;/g, '/');
            newStr = newStr.replace(/&amp;/g, '&');
            return newStr;
        }
    }
    return str;
}
function encode(data) {return Base64.encode(data);}
function decode(data) {return Base64.decode(data);}
function toBool(b) {
    if (typeof b === "string")
        return b !== '0' && b !== '';
    if (typeof b === "number")
        return b !== 0;
    if (typeof b === "boolean")
        return b;
    return false;
}
function validateEmail(email) {
    return email.indexOf("@") > 0;
}
function htmlTag(tag, attrs, contents) {
  var closeTag = true;
  switch(tag) {
    case 'input':
    case 'img':
    case 'link':
    case 'meta':
      closeTag = false;
  }
  var attrStr = '';
  for(var attr in attrs){
    attrStr += ' ' + attr + '="' + attrs[attr] + '"';
  }
  var html = "<" + tag + attrStr + ">";
  if (closeTag) return html + contents + "</" + tag + ">";
  return html;
}
function htmlDiv(attrs, contents) {
  return htmlTag("div", attrs, contents);
}
function helperText(pe) {
  if (pe.helperText)
    return htmlDiv({}, htmlTag('span', {id: pe.memberName + "_helperText", class:"normal-text"}, "&nbsp;" + _(pe.helperText)));
  return "";
}
function setVisible(div,v) {
  if (typeof v == "string")
    v = v !== '0';
  if(div) $(div).css("display", v ? "":"none");
  return v;
}
function setToggle(tName,v) {
  var name = "#" + tName;
  if(v=='1') {
    $(name + "_0").prop("checked", true);
    $(name + "_1").removeAttr('checked');
  }
  else {
    $(name + "_1").prop("checked", true);
    $(name + "_0").removeAttr('checked');
  }
  $(name).val(v);
}
function setVisibilityToggle(name,val) {
  setToggle(name,val);
  setVisible("#objwrapper"+name,val);
}
function genLink() {
  return htmlTag("a", {id: "link_" + this.getHtmlId()}, "");
}
function genToggleHtml(toggleName, onClick) {
  function halfSwitch(whch) {
    var inpAttrs = { type:"radio",
                      name: toggleName + "_radio",
                      id: toggleName + (whch? "_0": "_1"),
                      class:"access", value: (whch? "1": "0") };
    if (!onClick) onClick = "setToggle"
    inpAttrs.onClick = onClick + "('" + toggleName + "','" + (whch? "1": "0") + "');";
    return htmlTag('input', inpAttrs, "") +
            htmlTag('label',
                    {for: toggleName + (whch ? "_0": "_1"), class: (whch? "on": "off")},
                    whch? "ON": "OFF"
                  )
  }
  var radioSwitch = halfSwitch(true) + halfSwitch(false);
  return htmlTag('input',
            {type: "hidden", id: toggleName }, "")
            + htmlDiv( {class: "location-settings"},
                              htmlDiv({class: "radio-switch"}, radioSwitch)
                      );
}
function setToggleEnable(togName, en){
  en = !en;
  $("#" + togName + "_0").attr("disabled", en);
  $("#" + togName + "_1").attr("disabled", en);
}
function genRadioButtonHtml(btnName, onClick) {
  var id = btnName + "_btn";
  return htmlDiv({class: "radio-box"},
              htmlTag('input',
                      {type: "radio", class: "access", id: id, name: id, onClick: onClick + "('" + id + "');"}) +
              htmlTag('label', {for: id}, "&nbsp;")
            );
}
function setRadioButtonEnable(btnName, en){
  $("#" + btnName + "_btn").attr("disabled", !en);
}
function getRadioButtonVal(id) {
  var id = "#" + id + "_btn";
  var attr = $(id).attr('checked');
  if (typeof attr !== typeof undefined && attr !== false) {
      return true;
  }
  return false;
}
function setRadioButtonVal(id, val){
  var id = "#" + id + "_btn";
  if (val == '0')
      $(id).removeAttr('checked');
  else
      $(id).prop('checked',true);
}
function setOption(name, options, v) {
  var select = document.getElementById("sel_" + name);
  if (select == null) return;
  if (select.options)
    while (select.options.length > 0)
        select.remove(0);
  for(var i = 0; i < options.length; i++) {
      var opt = options[i];
      var el = document.createElement("option");
      if ( typeof opt == "string") {
        el.textContent = _(opt);
        el.value = opt;
      }
      else {
        el.textContent = _(opt[1]);
        el.value = opt[0];
      }
      if (el.value == v)
        el.selected = "selected";
      select.appendChild(el);
  }
}
function genBodyHtml(alert){
    var menu = htmlDiv({class: "header-wrap", id: "main-menu"}, "" );
    if (pageData.multiColumn) {
        var body =
          htmlTag("form", {class:"validate", name:"form", id:"form", novalidate:"novalidate"}, "") +
          htmlDiv({class: "site-content", id: "content"},
                      htmlDiv({class: "container dashboard"},
                        htmlDiv({class: "grid-9 alpha", id: "htmlGoesHere"}, "") +
                        htmlDiv({class: "grid-3 omega", id: "rightGoesHere"}, "")
                    )
                  );
    }
    else {
        var body = htmlDiv({id:"content", class: "site-content"},
                      htmlDiv({class: "container"},
                        htmlTag("aside", {class: "grid-3 alpha sidemenu", id:"side-menu"}, "") +
                        htmlDiv({class: "grid-9 omega"},
                            alert +
                            htmlTag("form", {class:"validate", name:"form", id:"form", novalidate:"novalidate"},
                              htmlDiv({class: "right-column white-box"},
                                htmlDiv({class: "pad", id: "htmlGoesHere"}, "")
                              )
                            )
                        )
                      )
                    );
    }
    var footer = htmlTag("footer", {class: "footer"},
                  htmlDiv({class: "container"},
                    htmlTag("p", {class: "copy-right"}, "Powered by NetComm Wireless Limited")));
    return menu + body + footer;
}
function genSaveRefreshCancel(isSave,isRefresh,isCancel) {
  var numButtons = 0;
  function genButton(isActive, id, labelText) {
      var attrs = {type:"button", id: id};
      if (isActive)
        numButtons++;
      else
        attrs.style = "display: none;"
      return htmlTag("button", attrs, _(labelText));
  }
  var html = genButton(isRefresh,"refreshButton", "refresh") +
              genButton(isSave,"saveButton", "CSsave") +
              genButton(isCancel,"cancelButton", "cancel");
  var attribs = {id: "buttonRow"};
  attribs.class = "submit-row form-row";
  if (numButtons > 1) attribs.class += " multi-button";
  if (numButtons === 0) attribs.style = "display: none;"
  return htmlDiv(attribs, html);
}
function disablePageIfPppoeEnabled()
{
  if ((typeof service_pppoe_server_0_enable !== "undefined") && service_pppoe_server_0_enable == '1') {
    if ((typeof service_pppoe_server_0_wanipforward_enable !== "undefined") && service_pppoe_server_0_wanipforward_enable == '1') {
      pageData.disabled = true;
      pageData.alertHeading = "pppoeEnabled";
      pageData.alertText = "functionNotAvailable";
    }
  }
}
function mergeObject(mainObj, extraObj) {
  var obj = mainObj
  for (var key in extraObj) {
    if (extraObj.hasOwnProperty(key)) {
      obj[key] = extraObj[key];
    }
  }
  return obj;
}
var validaters = {};
function validateField(field){
  var field0 = field[0];
  var name = field0.name;
  if (name != ""){
    var pe = validaters[name];
    if ((typeof pe !== "undefined") && (typeof pe.fnValidateField !== "undefined")) {
      for (var i = 0; i < pe.fnValidateField.length; i++) {
        if (pe.fnValidateField[i](field0.value) === false) {
          return pe.errMsg[i];
        }
      }
    }
  }
}
function validateKey(field){
    var name = field.name;
    if (name != ""){
      var member = validaters[name];
      if (member.fnValidateKey) {
        member.fnValidateKey(field);
      }
    }
}
function PageEl(name) {
    var pe = {memberName: name};
    pe.attr = {};
    pe.validateLua = [];
    pe.conditionsForCheck = [];
    pe.setEncode = function(encode){this.encode = encode;return this;};
    pe.setLabel = function(label){this.labelText = label;return this;};
    pe.getHtmlId = function() {return this.htmlId ? this.htmlId : this.memberName;}
    pe.setIsVisible = function(fnIsVisible) {this.fnIsVisible = fnIsVisible; return this;}
    pe.getThis = function (){return this;}
    pe.setValidate = function (fnValidateField, errMsg, fnValidateKey, luaValidateFn)
    {
      if ((typeof fnValidateKey !== "undefined")) {
        this.fnValidateKey = fnValidateKey;
      }
      if ((typeof luaValidateFn !== "undefined")){
        this.validateLua.push(luaValidateFn);
      }
      this.attr.onKeyUp = "validateKey(this);"
      var id = "inp_"+this.memberName;
      if (!(typeof this.fnValidateField !== "undefined")){
        this.fnValidateField = [];
        this.errMsg = [];
      }
      this.fnValidateField.push(fnValidateField);
      this.errMsg.push(_(errMsg));
      this.validate = "validate[" + (this.required === false ? "": "required,") + "funcCall[validateField]]";
      validaters[id] = this;
      return this;
    }
    pe.setAuthenticatedOnly = function() {this.authenticatedOnly=true;return this;}
    return pe;
}
function createMember(memberName, extras) {
  var pe = PageEl(memberName);
  return mergeObject(pe, extras);
}
function hiddenVariable(memberName, rdbName) {
  return createMember(memberName, {hidden: true}).getThis();
}
function shownVariable(memberName, labelText, extras) {
  var pe = createMember(memberName, extras).setLabel(labelText);
  pe.setGenHtml = function(fn) {this.genHtml = fn; return this;}
  pe.setSetVal = function(fn) {this.setVal = fn; return this;}
  return pe;
}
function staticTextVariable( name, label) {
  return shownVariable(name, label,
    {
      getVal: function () { return $("#"+this.getHtmlId()).html(); },
      setVal: function(obj, val){$("#"+this.getHtmlId()).html(val);},
      genHtml: function() {
        return htmlTag('span', {id: this.getHtmlId()}, "");
      },
      style: "margin:6px 0 0 3px;"
    });
}
function staticText(name, label, text) {
  return shownVariable(name, label,
    {
      readOnly: true,
      getVal: function () { return text; },
      setVal: function(obj, val){},
      genHtml: function() {
        return htmlTag('span', {id: this.getHtmlId()}, text);
      },
      style: "margin:6px 0 0 3px;"
    });
}
function editableTextVariable(memberName, labelText, extras) {
  var pe = mergeObject( PageEl(memberName).setLabel(labelText), extras);
  if ( !(typeof pe.required !== "undefined") || pe.required !== false ) {
    pe.validate = "validate[required]";
  }
  else {
    pe.validate = "";
  }
  pe.setVerify = function(label) {this.verifyLabelText = label; return this;}
  pe.setMaxLength = function(len) {
    this.maxlength = len;
    this.validateLua.push("(#v<="+len+")");
    return this;
  }
  pe.setMinLength = function(len) {
    this.minlength = len;
    this.validateLua.push("(#v>="+len+")");
    return this;
  }
  pe.setSmall = function() {this.makeSmall = true; return this;}
  pe.inputType = pe.inputType || "text";
  pe.getVal = function () { return $("#"+this.getHtmlId()).val(); };
  pe.setVal = function(obj, val){
              $("#"+this.getHtmlId()).val(val);
              if (this.mirrorHtmlId) $("#"+this.mirrorHtmlId).val(val);
            };
  pe.genHtml = function() {
                var id = this.getHtmlId();
                this.labelFor = id;
                var attr = mergeObject(this.attr, {name: id, id: id, type: this.inputType, value: "??"});
                if((typeof this.maxlength !== "undefined")) attr.maxlength = this.maxlength;
                attr.class = this.validate + (this.makeSmall ? " sml": " large")
                return htmlTag('input', attr );
              };
  return pe;
}
function editablePasswordVariable(memberName, labelText) {
  var pe = editableTextVariable(memberName, labelText, {inputType: "password"});
  pe.encode = true;
  return pe;
}
function checkPassStrength(th, memberName) {
 updatePassStrength(th, document.getElementById(memberName+"PassStrength"));
}
function editableStrongPasswordVariable(memberName, labelText) {
  var pe = editableTextVariable(memberName, labelText, {inputType: "password"});
  pe.encode = true;
  pe.attr = {onkeyup:"checkPassStrength(this, '"+memberName+"')"};
  pe.super_genHtml = pe.genHtml;
  pe.genHtml = function() {
    return this.super_genHtml() +
      htmlTag('a', {href: 'javascript:showStrongPasswordInfo();', id: "passwordInfo", style: 'background-color:transparent;'},
        htmlTag('i', {id: "net-info", style: "margin:5px;"}, ""))+
      htmlTag("span", {class:"normal-text", id:memberName+"PassStrength"}, "");
  }
  pe.setValidate(
    function (val) {
      return getPassStrength(val) == 'strong';
    },
    "passwordNotStrongEnough"
  );
  return pe;
}
function editableIpAddressVariable(memberName, labelText, _fnGenIPBlocks) {
  var fnGenIPBlocks = _fnGenIPBlocks;
  if (!(typeof _fnGenIPBlocks !== "undefined"))
    fnGenIPBlocks = genHtmlIpBlocks;
  var pe = shownVariable(memberName, labelText,
          {
            getVal: function () { return parse_ip_from_fields(this.memberName);},
            setVal: function(obj, val){parse_ip_into_fields(val,this.memberName);},
            genHtml: function(){ return this.fnGenIPBlocks(this.memberName);},
            fnGenIPBlocks: fnGenIPBlocks
          });
  pe.validateLua.push("isValid.IpAddress(v)");
  return pe;
}
function editableIpMaskVariable(memberName, labelText, _fnGenIPBlocks) {
  var fnGenIPBlocks = _fnGenIPBlocks;
  if (!(typeof _fnGenIPBlocks !== "undefined"))
    fnGenIPBlocks = genHtmlMaskBlocks;
  var pe =shownVariable(memberName, labelText,
          {
            getVal: function () { return parse_ip_from_fields(this.memberName);},
            setVal: function(obj, val){parse_ip_into_fields(val,this.memberName);},
            genHtml: function(){ return this.fnGenIPBlocks(this.memberName);},
            setEnable: function(en) {},
            fnGenIPBlocks: fnGenIPBlocks
          });
  pe.validateLua.push("isValid.IpMask(v)");
  return pe;
}
function editableURL(memberName, labelText, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  pe.setValidate(
          function (val) { return true;}, "",
          function (field) {return urlFilter(field);},
          "isValid.URL(v)"
        );
  return pe;
}
function editableHostname(memberName, labelText, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  pe.setValidate(
          function (val) { return true;}, "",
          function (field) {return hostNameFilter(field);},
          "isValid.Hostname(v)"
        );
  return pe;
}
function editableUsername(memberName, labelText, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  pe.setValidate(
          function (val) { return true;}, "Invalid user name.",
          function (field) {return nameFilter(field);},
          "isValid.Username(v)"
        );
  return pe;
}
function editableUserOrEmail(memberName, labelText, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  pe.setValidate(
          function (val){ return true;}, "Invalid user name.",
          function (field) {return emailFilter(field);},
          "isValid.UserOrEmail(v)"
        );
  return pe;
}
function editableEmailAddress(memberName, labelText, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  pe.setValidate(
          function (val) {
            if (pe.required === false && val === "") {
              return true;
            }
            return validateEmail(val);
          }, "Invalid email address.",
          function (field) { },
          "isValid.EmailAddress(v)"
        );
  return pe;
}
function editableInteger(memberName, labelText, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  pe.setValidate(
          function (val) { return true;}, "",
          function (field) {return NumfieldEntry(field);},
           "isValid.Integer(v)"
        );
  return pe;
}
function editableBoundedInteger(memberName, labelText, lower, upper, msg, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  if (lower < 0) {
      pe.setValidate(
              function (val) { val = parseInt(val); return val >= lower && val <= upper;}, msg,
              function (field) {return SignedNumfieldEntry(field);},
              "isValid.BoundedSignedInteger(v," + lower + "," + upper + ")"
            );
  } else {
      pe.setValidate(
              function (val) { val = parseInt(val); return val >= lower && val <= upper;}, msg,
              function (field) {return NumfieldEntry(field);},
              "isValid.BoundedInteger(v," + lower + "," + upper + ")"
            );
  }
  return pe;
}
function toggleVariable(memberName, labelText, onClick) {
  var pe = shownVariable(memberName, labelText,
          {
            getVal: function () { return $("#"+this.getHtmlId()).val();},
            setVal: function(obj, val){ setToggle(this.getHtmlId(), val);},
            genHtml: function() { return genToggleHtml(this.getHtmlId(), this.onClick);},
            setEnable: function(en) { setToggleEnable(this.getHtmlId(), en);}
          });
  pe.onClick = onClick;
  pe.validateLua.push("isValid.Bool(v)");
  return pe;
}
function radioButtonVariable(memberName, labelText, onClick) {
  var pe = shownVariable(memberName, labelText,
          {
            getVal: function () {
              return getRadioButtonVal(this.getHtmlId());
            },
            setVal: function(obj, val){
              setRadioButtonVal(this.getHtmlId(), val);
            },
            genHtml: function() { return genRadioButtonHtml(this.getHtmlId(), this.onClick);},
            setEnable: function(en) { setRadioButtonEnable(this.getHtmlId(), en);}
          });
  pe.onClick = onClick;
  pe.validateLua.push("isValid.Bool(v)");
  return pe;
}
function buttonAction(memberName, buttonText, onClick, labelText, extras) {
  if(!(typeof labelText !== "undefined")) {
    labelText = ""
  }
  var pe = shownVariable(memberName, labelText, extras);
  pe.getVal = function (){},
  pe.setVal = function(obj, val){},
  pe.genHtml = function() {
    var id = this.getHtmlId();
    return htmlTag( "button", {
      class:"secondary", id:id, type:"button", onClick: onClick + "('" + id + "');",
      style:"width:auto;margin-left:0;"
    },_(buttonText));
  }
  pe.onClick = onClick;
  return pe;
}
function objVisibilityVariable(memberName, labelText) {
  var pe = toggleVariable(memberName, labelText, "");
  pe.visibilityVar = true;
  return pe;
}
function selectVariable(memberName, labelText, fnOptions, onChange) {
  var pe = PageEl(memberName).setLabel(labelText);
  pe.fnOptions = fnOptions;
  pe.onChange = onChange;
  pe.getVal = function () { return $("#sel_"+this.memberName).val(); };
  pe.setVal = function(obj, val){setOption(this.memberName, this.fnOptions(obj),val);};
  pe.genHtml = function(){
    var attr = {id: "sel_"+this.memberName, style:"width:auto"};
    if((typeof this.onChange !== "undefined")) {
      attr.onChange = this.onChange + "(this);";
    }
    return htmlTag('select', attr, "");
  };
  var options = fnOptions();
  var luaOptions = [];
  options.forEach(function(opt){
      if ( typeof opt == "string") {
        luaOptions.push(opt);
      }
      else {
        luaOptions.push(opt[0]);
      }
  });
  if (luaOptions.length > 0) {
    pe.validateLua.push("isValid.Enum(v,{'" + luaOptions.join("','") + "'})");
  }
  return pe;
}
function iconLink(icon, labelText) {
  var pe = {};
  pe.labelText = labelText;
  pe.icon = icon;
    pe.genHtml = function(){ return htmlTag('a', {href: "", class: 'secondary sml', style: 'padding:0;border:0;'},
                                htmlTag('i', {class: 'icon ' + icon}, ''));};
  return pe;
}
function editableHostnameWPort(memberName, labelText, extras) {
  var pe = editableTextVariable(memberName, labelText, extras);
  pe.setValidate(
          function (val) { return true;}, "",
          function (field) {
            var tokens=field.value.split(":");
            var host={value:tokens[0]};
            hostNameFilter(host);
            if (tokens.length > 1) {
              var port={value:tokens[1]};
              NumfieldEntry(port);
              host.value=host.value.concat(":",port.value);
            }
            if (field.value.length != host.value.length){
              field.value = host.value;
            }
          },
          "isValid.HostnameWPort(v)"
        );
  return pe;
}
function sectionHeader(labelText) {
  var pe = {};
  pe.labelText = _(labelText);
  pe.unwrapped = true;
  pe.genHtml = function(){
                    return htmlTag('h2', {}, this.labelText );
              };
  return pe;
}
function fileUploader(memberName, labelText, targetFile, fileExt, getParams, errExt, errLoad) {
  var pe = PageEl(memberName).setLabel(labelText);
  pe.helperText = "Not uploaded";
  pe.genHtml = function() {
    var attrs = {id: "inp_" + memberName, type: "file", onchange: "onUploaderFileChange(this);"};
    if ((typeof fileExt !== "undefined")) {
      attrs.accept = fileExt.join(",");
    }
    return htmlTag("span", {class: "file-wrapper"},
                htmlTag("input", attrs, "") +
                htmlTag("span", {class: "secondary button"}, "Choose a file"));
  };
  pe.onUploaderFileChange = function (url, fileName ) {
    var pe = this;
    var params = (typeof getParams === "function")? getParams(): [];
    var startIndex = fileName.lastIndexOf("\\");
    if (startIndex != -1) {
        fileName = fileName.substr(startIndex);
    }
    if ((typeof fileExt !== "undefined") && (typeof errExt !== "undefined")){
      var extIndex = fileName.lastIndexOf(".");
      if ((extIndex == -1) || fileExt.indexOf(fileName.substr(extIndex))==-1) {
        blockUI_alert(_(errExt));
        return;
      }
    }
    setFileUploadStatus(pe.memberName, "not uploaded");
    var formData = new FormData();
    formData.append(pe.memberName, document.getElementById("inp_" + pe.memberName).files[0]);
    params.forEach(function(p,i){
      formData.append("param"+i, p);
    });
    formData.append("csrfTokenPost",csrfToken);
    blockUI_wait("Please wait");
    $.ajax({
      url: url,
      data: formData,
      processData: false,
      contentType: false,
      type: 'post',
      success: function(respObj) {
        $.unblockUI();
        if ( respObj.result == "0" ) {
          setFileUploadStatus(pe.memberName, "uploaded", fileName);
        }
        else {
          blockUI_alert(_(errLoad));
        }
      },
      error: function(XMLHttpRequest, textStatus, errorThrown) {
        $.unblockUI();
      }
    });
  }
  return pe;
}
function setFileUploadStatus(name, sts, fileName) {
  $("#" + name + "_helperText").html(((typeof fileName !== "undefined") && fileName != "" ? "File '" + fileName + "' - ": "") + _(sts));
}
function onUploaderFileChange(_this) {
  function searchMembers(members) {
    members.forEach(function(pe){
      if (_this.id.indexOf(pe.memberName) >= 0) {
        pe.onUploaderFileChange("/" + this.relUrlOfPage, _this.value);
      }
    });
  }
  pageData.pageObjects.forEach(function(pObj){
    if ((typeof pObj.editMembers !== "undefined")) {
      searchMembers(pObj.editMembers);
    }
    else if ((typeof pObj.members !== "undefined")) {
      searchMembers(pObj.members);
    }
  });
}
function PageObj(name, label, extras) {
    var Obj = {
      objName: name,
      labelText: label,
      packageObj: function packageObj() {
        if (this.readOnly) return;
        var pgeObj = this;
        var obj = {};
        pgeObj.members.forEach(function(mem){
          if (mem.readOnly) return;
          if (mem.getVal) {
            if ((typeof mem.encode !== "undefined") && mem.encode === true)
              obj[mem.memberName] = encode(mem.getVal());
            else
              obj[mem.memberName] = mem.getVal();
          }
          else {
              obj[mem.memberName] = pgeObj.obj[mem.memberName];
          }
        });
        if (pgeObj.encodeRdb) {
          obj = pgeObj.encodeRdb(obj);
        }
        obj.name = pgeObj.objName;
        return obj;
      },
      populate: function () {
        var obj = this.obj;
        this.members.forEach(function(mem) {
          if (mem.hidden) return;
          var val = obj[mem.memberName];
          if ((typeof val !== "undefined")) {
            if ((typeof mem.encode !== "undefined") && (mem.encode === true)) {
              val = decode(val);
            }
          }
          else {
            val = "";
          }
          if ((typeof mem.setVal !== "undefined")) {
            mem.setVal(obj,val);
          }
        });
      }
    };
    var pageObj = mergeObject(Obj, extras);
    pageObj.members.forEach(function(mem){
      if (mem.visibilityVar){
        pageObj.visibilityVar = mem.memberName;
        mem.onClick = "onClick" + pageObj.visibilityVar;
      }
    });
    return pageObj;
}
function PageTableObj(name, label, extras) {
  var pgeObj = PageObj(name, label, extras);
  pgeObj.genObjHtml = genTable;
  pgeObj.populate = populateTable;
  pgeObj.packageObj = function () {
    if (this.readOnly) return;
    var obj = {};
    if (this.encodeRdb) {
      obj.objs = this.encodeRdb(this.obj);
    }
    else
      obj.objs = this.obj;
    obj.name = this.objName;
    return obj;
  }
  return pgeObj;
}
function _genVariableList(members) {
  var list = "";
  if (members) {
    members.forEach( function(mem) {
      function labelAndField(field) {
        var divAttr = {class:"field"};
        if (mem.style) divAttr.style = mem.style;
        var lfor = {};
        if (mem.labelFor) lfor = { "for": mem.labelFor};
        return htmlTag('label', lfor, _(mem.labelText)) +
                                htmlDiv(divAttr, field) + helperText(mem);
      }
      if (mem.hidden) return;
      var id = "inp_" + mem.memberName;
      mem.htmlId = id;
      if (mem.verifyLabelText) {
        function addVerification(html, matchName) {
          var replacement = html.replace(
              "[required,funcCall[validateField]]",
              "[required,equals[inp_" + matchName + "]]"
          );
          return replacement.replace("[required]", "[required,equals[inp_" + matchName + "]]");
        }
        var orgLabel = mem.labelText;
        var orgName = mem.memberName;
        var newName = orgName + "_verify"
        var field1 = htmlDiv({id: "div_" + mem.memberName, class: "form-row"},
                              labelAndField(mem.genHtml(), newName));
        mem.memberName = newName;
        mem.labelText = mem.verifyLabelText;
        mem.htmlId = id + "_verify";
        mem.mirrorHtmlId = mem.htmlId;
        if (mem.attr.onkeyup && mem.attr.onkeyup.indexOf("checkPassStrength") == 0) {
            mem.attr.onkeyup = null;
        }
        list += field1 + htmlDiv({id: "div_" + mem.memberName, class: "form-row"},
                                labelAndField(addVerification(mem.genHtml(), orgName)));
        mem.memberName = orgName;
        mem.labelText = orgLabel;
        mem.htmlId = id;
      }
      else
        list += mem.unwrapped === true ? mem.genHtml(): htmlDiv({id: "div_" + mem.memberName, class: "form-row"}, labelAndField(mem.genHtml()));
     });
  }
  return list;
}
function genTable() {
  var pgeObj = this;
  var button = "";
  var colgroup = "";
  var thead = "";
  var heading = "";
  if (this.colgroup) {
    this.colgroup.forEach(function (col) {
      colgroup += htmlTag("col",{width:col}, "" );
    });
    colgroup = htmlTag("colgroup", {},colgroup);
  }
  function getThAttr(col) {
    if ((typeof pgeObj.thAttr !== "undefined")) {
       var len = pgeObj.thAttr.length;
       if (col >= len) col = len - 1;
       return pgeObj.thAttr[col];
    }
    return {class:"align10"};
  }
  var idx = 0;
  this.members.forEach(function (mem){
    if (mem.hidden) return;
    thead += htmlTag("th", getThAttr(idx++), _(mem.labelText) );
  });
  if (this.arrayEditAllowed) {
    thead += htmlTag("th", getThAttr(idx++), "");
    thead += htmlTag("th", getThAttr(idx++), "");
    button = htmlDiv({class: "submit-row-condensed"},
                      htmlTag("button",
                            {type: "button", onClick: "table_add('" + this.objName + "');", class: "secondary sml fr"},
                            htmlTag("i", {class: "icon plus"}, "" ) + "Add"));
    heading = htmlDiv({class: "grid-33"},
                      htmlTag("h2",{}, _(this.labelText)) ) +
               htmlDiv({class: "grid-66"}, button );
  }
  else {
    heading = htmlTag("h2",{}, _(this.labelText));
  }
  thead = htmlTag("thead", {}, htmlTag("tr", {}, thead));
  var tableAttribs = {id: this.objName};
  if ((typeof this.tableAttribs !== "undefined")) tableAttribs = mergeObject(tableAttribs, this.tableAttribs);
  var table = htmlDiv({id: "table" + this.objName},
                  heading +
                  htmlTag("table", tableAttribs,
                    colgroup + thead + htmlTag("tbody", {},"")
                  )
                );
  if (this.arrayEditAllowed) {
    table += htmlDiv({id: "edit" + this.objName, style:"display:none"},
                htmlTag("h2",{}, _(this.editLabelText)) +
                    _genVariableList(this.editMembers)
              );
  }
  var members = htmlDiv({id: "objwrapper"+this.objName}, table);
  return htmlDiv({class: "grey-box form-row", id: "objouterwrapper" + this.objName}, members);
}
function genVariableList() {
  var heading = htmlTag("h2",{}, _(this.labelText));
  var members = htmlDiv({id: "objwrapper" + this.objName},
                        _genVariableList(this.members));
  this.setVisible = function(v){
    var pgeObj = this;
    var visVar = pgeObj.visibilityVar;
    if (!(typeof visVar !== "undefined")) {
      return;
    }
    if((typeof v !== "undefined")) {
      if ((typeof pgeObj.setEnabled === "function")) {
        pgeObj.setEnabled(v=="1");
      }
    }
    else {
      v = this.obj[visVar];
    }
    setToggle("inp_" + visVar, v);
    var objShown = toBool(v);
    pgeObj.members.forEach(function(pe){
      if (pe.hidden) {
        return;
      }
      if(pe.memberName !== pgeObj.visibilityVar) {
        var show = objShown;
        if (show && (typeof pe.fnIsVisible === "function")) {
          show = pe.fnIsVisible();
        }
        setVisible("#div_" + pe.memberName, show);
        if (pe.verifyLabelText) {
          setVisible("#div_" + pe.memberName + "_verify", show);
        }
      }
    });
  };
  return htmlDiv({id: "objouterwrapper" + this.objName}, heading + members);
}
function genCols() {
  var html = "";
  var cols = [{
                heading:"status system up time",
                members:[1]
              },
              {
                heading:"routerVersion",
                members:[1,2,3]
              },
              {
                heading:"advStatus phoneModule",
                members:[1,2]
              }];
  cols.forEach(function(col,i) {
    var colhtml = "";
    col.members.forEach(function(mem){
      colhtml += htmlTag("dt", {}, "dt") +
                  htmlTag("dd", {}, "dd")
    });
    colhtml = htmlTag("dl", {}, colhtml)
    var each_box = "each-box";
    if (i === 0) each_box += " alpha"
    else if (i === cols.length-1) each_box += " omega"
    html += htmlDiv({class: each_box},
              htmlTag("h3", {}, _(col.heading)) + colhtml);
  });
  html = htmlDiv({class: "box"},
              htmlDiv({class: "box-header"}, htmlTag("h2", {},"System information")) +
              htmlDiv({class: "row"},
                htmlDiv({id:"system-information", class:"box-content"}, html )));
  return html;
}
function displayAlert(heading, text) {
   var alert = htmlDiv({class:"grid-9 alpha"},
                  htmlDiv({class: "note-lrg"},
                  htmlDiv({class: "wrap alert clearfix" },
                     htmlTag("h2", {}, heading) +
                     htmlTag("p", {}, text)
                 )));
   document.body.innerHTML = genBodyHtml(alert);
   setVisible('#form','0');
   setVisible("#body","1");
   set_menu(pageData.menuPos[0], pageData.menuPos[1], user);
}
function genPage() {
    if (pageData.disabled === true) {
      displayAlert(_(pageData.alertHeading), _(pageData.alertText));
      return;
    }
    document.body.innerHTML = genBodyHtml("");
    var columns = []; columns[0] = ""; columns[1] = "";
    pageData.pageObjects.forEach(function(pgeObj) {
        var col = 0;
        if (typeof pgeObj.column !== "undefined") col = pgeObj.column - 1;
        if (!pgeObj.genObjHtml) {
          pgeObj.genObjHtml = genVariableList
        }
        columns[col] += pgeObj.genObjHtml();
    });
    $("#htmlGoesHere").append(columns[0]);
    if( columns[1].length > 0) $("#rightGoesHere").append(columns[1]);
    setVisible('#alertMsg','0');
    pageData.pageObjects.forEach(function(pgeObj) {
      if(pgeObj.onPageGenerated) {
        pgeObj.onPageGenerated();
      }
      pgeObj.members.forEach(function(mem) {
        if(mem.onPageGenerated) {
          mem.onPageGenerated();
        }
      });
      if ((typeof pgeObj.editMembers !== "undefined")) {
        pgeObj.editMembers.forEach(function(mem){
          if(mem.onPageGenerated) {
            mem.onPageGenerated();
          }
        });
      }
    });
   set_menu(pageData.menuPos[0], pageData.menuPos[1], user);
}
function populateTable(){
  var pgeObj = this;
  var table = document.getElementById(pgeObj.objName);
  if (!table) return;
  table = table.getElementsByTagName("tbody")[0];
  if (!table) return;
  while(table.rows.length > pgeObj.obj.length)
    table.deleteRow(table.rows.length-1);
  pgeObj.obj.forEach(function(ob,rowIndex) {
    var row = table.rows[rowIndex];
    if (!row) row = table.insertRow(-1);
    var colIndex = 0;
    pgeObj.members.forEach(function(mem){
      if (mem.hidden) return;
      mem.htmlId = pgeObj.objName + "_" + rowIndex + "_" + mem.memberName;
      var genHtml = false;
      var cell = row.cells[colIndex++];
      if(!cell) {
         cell = row.insertCell(-1);
         genHtml = true;
      }
      cell.id = mem.htmlId;
          var val = ob[mem.memberName];
          if (genHtml && (typeof mem.genHtml !== "undefined")) cell.innerHTML = mem.genHtml();
          if ((typeof val !== "undefined")) mem.setVal(ob, val);
    });
    if (pgeObj.arrayEditAllowed) {
      function addIcon(type) {
        var cell = row.cells[colIndex++];
        if(!cell) cell = row.insertCell(-1);
        var icon = iconLink(type, "", "");
        var properHref = "javascript:table_" + icon.icon + "('" + pgeObj.objName + "'," + ob.id + ");";
        cell.innerHTML = icon.genHtml(ob).replace('href=""', 'href="'+properHref+'"');
      }
      addIcon("edit");
      addIcon("close");
    }
  });
}
function _table_edit(pgeObj, obj) {
  var tableName = pgeObj.objName;
  clear_alert();
  function cancelTableEdit() {
    setVisible("#edit"+tableName, "0");
    setVisible("#cancelButton", "0");
    setVisible("#table"+tableName, "1");
    $("#saveButton").off('click').on('click', sendObjects);
    if ((typeof pgeObj.offEdit !== "undefined")) pgeObj.offEdit();
  }
  function saveTableEdit() {
    pgeObj.editMembers.forEach(function(mem){
      if ((typeof mem.memberName !== "undefined") && (typeof mem.getVal === "function")) {
        obj[mem.memberName] = mem.getVal();
      }
    });
    if ((typeof pgeObj.saveObj === "function")) pgeObj.saveObj(obj);
    obj.dirty = true;
    if ((typeof pgeObj.getValidationError === "function")) {
      var errMsg = pgeObj.getValidationError(obj);
      if ((typeof errMsg !== "undefined")) {
        validate_alert("", _(errMsg));
        return;
      }
    }
    sendObjects(function() {
      pgeObj.populate();
      cancelTableEdit();
    });
  }
  if ((typeof pgeObj.onEdit === "function")) pgeObj.onEdit(obj);
  setVisible("#table"+tableName, "0");
  pgeObj.editMembers.forEach(function(mem){
    if ((typeof mem.setVal === "function")) {
      mem.setVal(obj, (typeof mem.memberName !== "undefined")? obj[mem.memberName]: undefined);
    }
  });
  setVisible("#edit"+tableName, "1");
  $("#cancelButton").click(cancelTableEdit);
  $("#saveButton").off('click').on('click', saveTableEdit);
  setVisible("#cancelButton", "1");
}
function table_edit(tableName, id) {
  pageData.pageObjects.forEach(function(pgeObj) {
    if (pgeObj.objName == tableName) {
      pgeObj.obj.forEach(function(obj){
        if (obj.id === id)
        _table_edit(pgeObj, obj);
      });
    }
  });
}
function table_close(tableName, id) {
  pageData.pageObjects.forEach(function(pgeObj) {
    if (pgeObj.objName == tableName){
      var delObj = true;
      if ((typeof pgeObj.delObj === "function")) {
        delObj = pgeObj.delObj(id);
      }
      if (delObj) {
        var arr = pgeObj.obj;
        arr.splice(id,1);
        for (var idx = 0; idx < arr.length; idx++) {
          arr[idx].id = idx;
        }
      }
      sendObjects();
    }
  });
}
function table_add(tableName) {
  pageData.pageObjects.forEach(function(pgeObj) {
    if (pgeObj.objName == tableName) {
      var idx = pgeObj.obj.length;
      var newObj = {};
      if ((typeof pgeObj.initObj === "function")) {
        newObj = pgeObj.initObj();
      }
      if ((typeof newObj !== "undefined")) {
        if (!(typeof newObj.id !== "undefined")) {
          newObj.id = idx;
        }
        pgeObj.obj[idx] = newObj;
        _table_edit(pgeObj, pgeObj.obj[idx]);
      }
    }
  });
}
function cachedScriptLoad(url, options) {
  options = $.extend(options || {}, {
    dataType: "script",
    cache: true,
    url: url
  });
  return jQuery.ajax( options );
};
function requestPageObjects() {
  var objectsToRequest = [];
  pageData.pageObjects.forEach(function(pgeObj) {
    objectsToRequest[objectsToRequest.length] = pgeObj.objName;
  });
  requestObjects(objectsToRequest,receiveFirstObjects);
}
function getObjectsToSend() {
  var objs=[];
  pageData.pageObjects.forEach(function(pgeObj) {
    var obj = pgeObj.packageObj();
    if (obj) objs[objs.length] = obj;
  });
  return objs;
}
function receiveObjects(resp){
  requestPending = false;
  if (resp.result !== 0) {
    if (resp.text.indexOf("Invalid csrfToken") >= 0) {
      alertInvalidCsrfToken();
    }
    else if ((typeof resp.errorText !== "undefined")){
      validate_alert( "Invalid request", _(resp.errorText));
    }
    else {
      alertInvalidRequest();
    }
  }
  pageData.pageObjects.forEach(function(pgeObj) {
    var obj = resp[pgeObj.objName];
    if (obj) {
      if ((typeof pgeObj.decodeRdb !== "undefined")) {
        obj = pgeObj.decodeRdb(obj);
      }
      pgeObj.obj = obj;
      pgeObj.populate();
      if ((typeof pgeObj.setVisible !== "undefined")) {
        pgeObj.setVisible();
      }
    }
  });
}
function isFormValid(form) {
  if (!(typeof form !== "undefined")) {
    form = "#form";
  }
  if(!$(form).validationEngine("validate")) {
    validate_alert("","");
    return false;
  }
  return true;
}
function sendObjects(fnSuccess) {
  if (isFormValid()) {
    var objs = getObjectsToSend();
    sendTheseObjects(objs, fnSuccess);
  }
}
function sendObjectsThenShowTop(fnSuccess) {
  sendObjects(fnSuccess);
  $('html,body').scrollTop(0);
}
var cgiUrl = '/cgi-bin/jsonSrvr.lua'
function sendTheseObjects(objs, fnSuccess) {
  $("button").attr("disabled", true);
  $.post(cgiUrl, JSON.stringify({setObject: objs, csrfToken: csrfToken}), null, "json")
  .done(function(resp) {
      receiveObjects(resp);
      if (resp.result === 0) {
        var success = "";
        if ((typeof pageData.alertSuccessTxt !== "undefined")) {
          success = (typeof pageData.alertSuccessTxt === "function") ? _(pageData.alertSuccessTxt()): _(pageData.alertSuccessTxt);
        }
        success_alert("", success);
        if ((typeof fnSuccess === "function")) {
          fnSuccess();
        }
      }
      $("button").attr("disabled", false);
  })
  .fail(function(err) {
    alertInvalidRequest();
    $("button").attr("disabled", false);
  });
}
function requestObjects(objectstoRequest, fnCallback) {
  $.getJSON(cgiUrl, JSON.stringify({getObject: objectstoRequest, csrfToken: csrfToken}))
    .done(fnCallback)
    .fail(function(err) {
        setVisible("#body","1");
    });
}
function startPagePolls() {
  var pollPeriods = [];
  pageData.pageObjects.forEach(function(pgeObj) {
    if ((typeof pgeObj.pollPeriod !== "undefined")) {
      var period = pgeObj.pollPeriod;
      if (!(typeof pollPeriods[period] !== "undefined")) pollPeriods[period] = [];
      var objNames = pollPeriods[period];
      objNames[objNames.length] = pgeObj.objName;
    }
  });
  pollPeriods.forEach(function(objNames, period){
    setInterval(function() {requestObjects(objNames, receiveObjects);}, period);
  });
}
var pageGenerated = false;
var objectsReceived = null;
function receiveFirstObjects(resp){
  if (pageGenerated === false) {
    objectsReceived = resp;
    return;
  }
  receiveObjects(resp);
  if ((typeof pageData.onReady !== "undefined")) {
    pageData.onReady();
  }
  setVisible("#body","1");
  if (!(typeof pageData.validateOnload !== "undefined") || pageData.validateOnload === true ) {
    $("#form").validationEngine();
  }
  $.blockUI.defaults.css.border="3px solid #008bc6";
  $.blockUI.defaults.css.padding="20px 0 20px 0";
  startPagePolls();
}
$(document).ready(function() {
  genPage();
  pageGenerated = true;
  if (objectsReceived !== null) {
      receiveFirstObjects(objectsReceived);
      objectsReceived = null;
  }
});
function WinExpIP(field,event) {
 if( field.value=="") {
  if($(field).hasClass("required")) {
   $(field).valid();
  }
 }
 else {
  if(!isValidIpEntry(field,event))
   validate_alert( "", "You must enter a value between 0 and 255. Please try again.");
  else
   clear_alert();
 }
}
function WinExpIP_1(field,event) {
 if( field.value=="") {
  if($(field).hasClass("required")) {
   $(field).valid();
  }
 }
 else {
  switch(isValidIpEntry_1(field,event)) {
  case -1:
   validate_alert( "", "You must enter a value between 1 and 223. Please try again.");
  break;
  case -2:
   validate_alert( "", "An IP address can't start with 127. Please try another value between 1 and 223.");
  break;
  default:
   clear_alert();
  break;
  }
 }
}
function hostMin(ip, mask) {
 var host_array=[];
 ip_array = ip.split('.');
 mask_array = mask.split('.');
 for (i = 0; i < 4; i++) {
  host_array[i] = parseInt(ip_array[i])&parseInt(mask_array[i]);
 }
 host_array[3]++;
 return host_array.join(".");
}
function hostMax(ip, mask) {
 var host_array=[];
 var wildcard_array=[];
 ip_array = ip.split('.');
 mask_array = mask.split('.');
 for (i = 0; i < 4; i++) {
  wildcard_array[i]=~parseInt(mask_array[i])&255;
  host_array[i] = parseInt(ip_array[i])&parseInt(mask_array[i])|wildcard_array[i];
 }
 host_array[3]--;
 return host_array.join(".");
}
function checkIPrange(ipMin, ipMax, myip) {
var fromArr = ipMin.split(".");
var toArr = ipMax.split(".");
var myipArr = myip.split(".");
var fromip=0; toip=0; myip=0;
 for(i=0;i<4;i++) {
  fromip=fromip*1000+parseInt(fromArr[i]);
  toip=toip*1000+parseInt(toArr[i]);
  myip=myip*1000+parseInt(myipArr[i]);
 }
 if(myip<fromip || myip>toip) {
  return false;
 }
 return true;
}
function isWithinHostIpRange(ip, mask, myip) {
 return checkIPrange(hostMin(ip, mask), hostMax(ip, mask), myip);
}
function checkIpAddr(field, ismask, msg) {
 if (field.value == "") {
  if (ismask) {
   validate_alert( "", typeof(msg)!="undefined"?msg+"You must enter a netmask. Please try again.":"You must enter a netmask. Please try again.");
  }
  else {
   validate_alert( "", typeof(msg)!="undefined"?msg+"The IP address is empty. Please try again.":"The IP address is empty. Please try again.");
  }
  field.value = field.defaultValue;
  field.focus();
  return false;
 }
 if (isAllNum(field.value) == 0) {
  validate_alert( "", typeof(msg)!="undefined"?msg+"You must enter a number between [1-9]. Please try again.":"You must enter a number between [1-9]. Please try again.");
  field.value = field.defaultValue;
  field.focus();
  return false;
 }
 if (ismask) {
  if ((!checkRange(field.value, 1, 0, 256)) ||
   (!checkRange(field.value, 2, 0, 256)) ||
   (!checkRange(field.value, 3, 0, 256)) ||
   (!checkRange(field.value, 4, 0, 256)))
  {
   validate_alert( "", typeof(msg)!="undefined"?msg+"You have entered the netmask incorrectly. Please try again.":"You have entered the netmask incorrectly. Please try again.");
   field.value = field.defaultValue;
   field.focus();
   return false;
  }
 }
 else {
  if ((!checkRange(field.value, 1, 0, 255)) ||
   (!checkRange(field.value, 2, 0, 255)) ||
   (!checkRange(field.value, 3, 0, 255)) ||
   (!checkRange(field.value, 4, 1, 254)))
  {
   if (ismask) {
    validate_alert( "", typeof(msg)!="undefined"?msg+"You have entered the netmask incorrectly. Please try again.":"You have entered the netmask incorrectly. Please try again.");
   }
   else {
    validate_alert( "", typeof(msg)!="undefined"?msg+"You have entered the IP address incorrectly. Please try again.":"You have entered the IP address incorrectly. Please try again.");
   }
   field.value = field.defaultValue;
   field.focus();
   return false;
  }
 }
 clear_alert();
 return true;
}
function parse_ip_into_fields(ipaddr, name) {
 var i;
 var ip_array;
 ip_array=ipaddr.split(".");
 if(ip_array.length != 4 ) {ip_array[0]=''; ip_array[1]='';ip_array[2]=''; ip_array[3]='';}
 for(i=0;i<4;i++) {
  $("input[name="+name+(i+1)+"]").val(ip_array[i]||"");
 }
}
function parse_ip_from_fields(documentItem) {
 var ip_array=[];
 var val;
 var j=0;
 for(var i=0;i<4;i++) {
  val=$("input[name="+documentItem+(i+1)+"]").val();
  if(val!="") {
   ip_array[j++]=val;
  }
  else {
   return "";
  }
 }
 return ip_array.join(".");
}
function ValidSubnetMask(n, t){
 NumfieldEntry(t);
 if(isValidSubnetMask(parse_ip_from_fields(n))<0) {
  for(i=0;i<4;i++) {
   $("input[name="+n+(i+1)+"]").removeClass("success-text").addClass("failure-text");
  }
 }
 else {
  for(i=0;i<4;i++) {
   $("input[name="+n+(i+1)+"]").removeClass("failure-text").addClass("success-text");
  }
 }
}
function _genHtmlIpBlocks(name, classes, onKeyUp) {
 var html = "";
 if(!(typeof onKeyUp !== "undefined")) onKeyUp = "NumfieldEntry(this);";
 [".",".",".",""].forEach(function(dot, i) {
  var id = name + (i+1);
  var inputAttribs = {type:'text', class: classes[i] +" ip-adress", maxLength: 3, name: id, id: id, onkeyup: onKeyUp, onchange: "validate_group('" + name + "')"};
  html += htmlDiv( {class:'field'}, htmlTag("input", inputAttribs, "")) + htmlTag("label", {for: id, class:'input-connect-dot'}, dot);
 });
 return html;
}
function getValidateStr(parm, func) {return "validate[" + parm + ",funcCall[" + func + "]]";}
function getRequiredValidateStr(func) {return getValidateStr("required", func);}
function genHtmlIpBlocks(n) {
 var val1 = getRequiredValidateStr("validate_ip_1");
 var valx = getRequiredValidateStr("validate_ip");
 return _genHtmlIpBlocks(n, [val1, valx, valx, valx]);
}
function genHtmlIpBlocks0(n) {
 var val = getRequiredValidateStr("validate_ip_0");
 return _genHtmlIpBlocks(n, [val, val, val, val]);
}
function genHtmlIpBlocks127(n) {
 var val1 = getRequiredValidateStr("validate_ip_127");
 var valx = getRequiredValidateStr("validate_ip");
 return _genHtmlIpBlocks(n, [val1, valx, valx, valx]);
}
function genHtmlMaskBlocks(n) {
 var valx = "success-text " + getRequiredValidateStr("validate_netmask");
 return _genHtmlIpBlocks(n, [valx, valx, valx, valx], "ValidSubnetMask('" + n + "',this)");
}
function getcondRequired(n) {
 return "condRequired[" + n + "1," + n + "2," + n + "3," + n + "4]";
}
function genHtmlIpBlocksWithoutRequired(n) {
 var condRequired = getcondRequired(n);
 var val1 = "validate[" + condRequired + ",funcCall[validate_ip_1]]";
 var valx = "validate[" + condRequired + ",funcCall[validate_ip]]";
 return _genHtmlIpBlocks(n, [val1, valx, valx, valx]);
}
function genHtmlIpBlocksWithoutRequired0(n) {
 var valx = "validate[" + getcondRequired(n) + ",funcCall[validate_ip_0]]";
 return _genHtmlIpBlocks(n, [valx, valx, valx, valx]);
}
function genHtmlMaskBlocksWithoutRequired(n) {
 var valx = "validate[" + getcondRequired(n) + ",funcCall[validate_ip]]";
 return _genHtmlIpBlocks(n, [valx, valx, valx, valx]);
}
function clear_ip_group(group) {
 for(var i=4; i>=1; i--) {
  $("#"+group+i).val("");
 }
}
function validate_group( group ) {
 var err_counter=0;
 for(var i=4; i>=1; i--) {
  if($("#"+group+i).validationEngine("validate")) {
   if($("#"+group+i).val()!="") {
    err_counter++;
    for(var j=i+1; j<=4; j++) {
     $("#"+group+j).validationEngine("hide");
    }
   }
   else if(err_counter++) {
    $("#"+group+i).validationEngine("hide");
   }
  }
 }
 return err_counter;
}
function validate_ip_1(field, rules, i, options) {
 if(isNValidIP(field.val()) || field.val() <1 || field.val() >223) {
  field.value="192";
  return "Please specify a value between 1 and 223.";
 }
 else if(field.val()==127) {
  field.value="192";
  return "An IP address can't start with 127. Please try another value between 1 and 223.";
 }
 field.val(parseInt(field.val()));
 return true;
}
function validate_ip_127(field, rules, i, options) {
 if(isNValidIP(field.val()) || field.val() <1 || field.val() >223) {
  field.value="192";
  return "Please specify a value between 1 and 223.";
 }
 field.val(parseInt(field.val()));
 return true;
}
function validate_ip_0(field, rules, i, options) {
 if(isNValidIP(field.val())) {
  return "Please specify a value between 0 and 255.";
 }
 field.val(parseInt(field.val()));
 return true;
}
function validate_ip(field, rules, i, options) {
 if(isNValidIP(field.val())) {
  return "Please specify a value between 1 and 255.";
 }
 field.val(parseInt(field.val()));
 return true;
}
function validate_netmask(field, rules, i, options) {
 if(isNValidIP(field.val())) {
  return "Please specify a value between 0 and 255.";
 }
 field.val(parseInt(field.val()));
 return true;
}
function ip_to_decimal(addr) {
 var deci;
 deci = parseInt(addr[0])*16777216 + parseInt(addr[1])*65536 + parseInt(addr[2])*256 + parseInt(addr[3]);
 return deci;
}
function decimal_to_ip(deci) {
 var addr = [];
 deci_int = deci - (deci % 16777216);
 addr[0] = deci_int / 16777216;
 addr[1] = (deci & 0x00ff0000) >> 16;
 addr[2] = (deci & 0x0000ff00) >> 8;
 addr[3] = deci & 0x000000ff;
 return addr;
}
function is_large(addr1, addr2) {
 var gap;
 gap = ip_to_decimal(addr1) - ip_to_decimal(addr2);
 if (gap >=0 )
  return 1;
 else
  return 0;
}
function ip_gap(addr1, addr2) {
 var gap;
 if (is_large(addr1, addr2))
  gap = ip_to_decimal(addr1) - ip_to_decimal(addr2);
 else
  gap = ip_to_decimal(addr2) - ip_to_decimal(addr1);
 return gap;
}
function subnetID(ip, mask) {
 var host_array=[];
 ip_array = ip.split('.');
 mask_array = mask.split('.');
 for (i = 0; i < 4; i++) {
  host_array[i] = parseInt(ip_array[i])&parseInt(mask_array[i]);
 }
 return host_array.join(".");
}
function broadcastIP(ip, mask) {
 var host_array=[];
 var wildcard_array=[];
 ip_array = ip.split('.');
 mask_array = mask.split('.');
 for (i = 0; i < 4; i++) {
  wildcard_array[i]=~parseInt(mask_array[i])&255;
  host_array[i] = parseInt(ip_array[i])&parseInt(mask_array[i])|wildcard_array[i];
 }
 return host_array.join(".");
}
function totalSubnet(mask) {
var sum=0;
 mask_array = mask.split('.');
 for (i = 0; i < 4; i++) {
  sum=sum*256+(~parseInt(mask_array[i])&255);
 }
 return sum-1;
}
function netInfo() {
 clear_alert();
 $("#lan_addr").val(parse_ip_from_fields("lan_addr"));
 $("#mask").val(parse_ip_from_fields("mask"));
 switch(isValidSubnetMask($("#mask").val())) {
  case -1:
   validate_alert("","You have entered an invalid subnet mask. Please try again.");
   return;
  break;
  case -2:
   validate_alert("","The subnet mask must be contiguous. Please try again.");
   return;
  break;
 }
 if(!isValidIpAddress($("#lan_addr").val())) {
  validate_alert("","Invalid ip address.");
  return;
 }
 var msg="<div class='message_box' style='text-align:left;'>"+"Subnet ID: "+subnetID($("#lan_addr").val(), $("#mask").val())+" / "+maskBits($("#mask").val()) +"<br/>"+"Broadcast address: "+broadcastIP($("#lan_addr").val(), $("#mask").val()) +"<br/>"+"Subnet IP address range: "+hostMin($("#lan_addr").val(), $("#mask").val())+"-"+hostMax($("#lan_addr").val(), $("#mask").val()) +"<br/>"+"Hosts per subnet: "+totalSubnet($("#mask").val()) +"<br/></div><div style='margin-left:180px'><button class='secondary mini' onClick='$.unblockUI();'>"+"OK"+"</button><div/>";
 $.blockUI({message:msg});
 return;
}
if ( (typeof(util_js_included) == "undefined") || util_js_included == false )
{
 var util_js_included = true;
function isHexaDigit(digit) {
 return (digit >= '0' && digit <= '9') || (digit >= 'a' && digit <= 'f') || (digit >= 'A' && digit <= 'F');
}
function isValidKey(val, size) {
var ret = false;
var len = val.length;
var dbSize = size * 2;
 if ( len == size )
  ret = true;
 else if ( len == dbSize ) {
  for ( i = 0; i < dbSize; i++ )
   if ( isHexaDigit(val.charAt(i)) == false )
    break;
  if ( i == dbSize )
   ret = true;
 } else
  ret = false;
 return ret;
}
function isValidHexKey(val, size) {
var ret = false;
 if (val.length == size) {
  for ( i = 0; i < val.length; i++ ) {
   if ( isHexaDigit(val.charAt(i)) == false ) {
    break;
   }
  }
  if ( i == val.length ) {
   ret = true;
  }
 }
 return ret;
}
function filterUsingFn(field, unsafefn ) {
var i = 0;
 for ( i = 0; i < field.value.length; i++ ) {
  if ( unsafefn(field.value.charAt(i)) == true ) {
   field.value=field.value.replace(field.value.charAt(i), '');
   i--;
  }
 }
}
function nameFilter(field) {
 filterUsingFn( field, isNameUnsafe );
}
function emailFilter(field) {
 filterUsingFn( field, isEmailUnsafe );
}
function nameFilterWSpace(field) {
 filterUsingFn( field, isCharUnsafe );
}
function hostNameFilter(field) {
 filterUsingFn( field, isHostNameUnsafe );
}
function isHostNameUnsafe(compareChar) {
 var charCode = compareChar.charCodeAt(0);
 if ( charCode >=48 && charCode <= 57 )
  return false;
 if ( charCode >=65 && charCode <= 90 )
  return false;
 if ( charCode >=97 && charCode <= 122 )
  return false;
 if ( charCode == 95 || charCode == 46 || charCode == 45 )
  return false;
 return true;
}
function urlFilter(field) {
 filterUsingFn( field, isURLUnsafe );
}
function isURLUnsafe(compareChar) {
 var patt=/[^a-zA-Z0-9-._~!*'();:@&=+$,\/?#\[\]]/
 return patt.test(compareChar);
}
function ssidFilter(field) {
 filterUsingFn( field, isSSIDUnsafe );
}
function isSSIDUnsafe(compareChar) {
 var unsafeString = "\"\t\\$";
 if ( unsafeString.indexOf(compareChar) == -1 && compareChar.charCodeAt(0) >= 32
  && compareChar.charCodeAt(0) < 123 )
  return false;
 return true;
}
function isNameUnsafe(compareChar) {
var unsafeString = "\"<>%\\^[]`\+\$\,='#&@.:\t";
 if ( unsafeString.indexOf(compareChar) == -1 && compareChar.charCodeAt(0) > 32
   && compareChar.charCodeAt(0) < 123 ) {
  return false;
 }
 return true;
}
function isEmailUnsafe(compareChar) {
var unsafeString = "\"<>%\\^[]`\+\$\,='#&:\t";
 if ( unsafeString.indexOf(compareChar) == -1 && compareChar.charCodeAt(0) > 32
   && compareChar.charCodeAt(0) < 123 ) {
  return false;
 }
 return true;
}
function isValidName(name) {
var i = 0;
 for ( i = 0; i < name.length; i++ ) {
  if ( isNameUnsafe(name.charAt(i)) == true )
   return false;
 }
 return true;
}
function isCharUnsafe(compareChar) {
var unsafeString = "\"<>%\\^[]`\+\$\,='#&@.:\t";
 if ( unsafeString.indexOf(compareChar) == -1 && compareChar.charCodeAt(0) >= 32
  && compareChar.charCodeAt(0) < 123 )
  return false;
 return true;
}
function isValidNameWSpace(name) {
var i = 0;
 for ( i = 0; i < name.length; i++ ) {
  if ( isCharUnsafe(name.charAt(i)) == true )
   return false;
 }
 return true;
}
function isSameSubNet(lan1Ip, lan1Mask, lan2Ip, lan2Mask) {
var count = 0;
 lan1a = lan1Ip.split('.');
 lan1m = lan1Mask.split('.');
 lan2a = lan2Ip.split('.');
 lan2m = lan2Mask.split('.');
 for (i = 0; i < 4; i++) {
  l1a_n = parseInt(lan1a[i]);
  l1m_n = parseInt(lan1m[i]);
  l2a_n = parseInt(lan2a[i]);
  l2m_n = parseInt(lan2m[i]);
  if ((l1a_n & l1m_n) == (l2a_n & l2m_n))
   count++;
 }
 if (count == 4)
  return true;
 return false;
}
function KeyCode(e) {
 if(e&&e.which){
  e=e;
  return(e.which);
 }
 e=event;
 return(e.keyCode);
}
function isBlank(s) {
 for (i=0;i<s.length;i++) {
  c=s.charAt(i);
  if ((c!=' ') && (c!='\n') && (c!='\t'))
   return false;
 }
 return true;
}
function isNValidIP(s) {
 if((isBlank(s))||(isNaN(s))||(s<0||s>255))
  return true;
 return false;
}
function IPfieldEntry(field) {
 if(isNaN(field.value.charAt(field.value.length-1))&&field.value.charAt(field.value.length-1)!='.')
  field.value=field.value.slice(0,field.value.length-1);
 field.value=parseInt(field.value);
}
function SignedNumfieldEntry(field) {
  field.value=field.value.replace(/(?!^)-/g, "").replace(/[^-0-9]+/g, "");
}
function NumfieldEntry(field) {
 field.value=field.value.replace(/[^0-9]+/g, "");
}
function lastEntryChar(field,spchar) {
 if(field.value.charAt(field.value.length-1)==spchar) {
  field.value=field.value.slice(0,field.value.length-1);
  if(field.value.length)
   return(1);
 }
 return(0);
}
function isValidIpEntry(field,e) {
  IPfieldEntry(field);
  if(lastEntryChar(field,' '))
   field.value=field.value.substring(0,field.value.length);
  if(lastEntryChar(field,'.')||field.value.length==3) {
   if(isNValidIP(field.value)) {
    field.value="255";
    field.select();
    return false;
   }
   else if(field.value.length<3)
    focusOnNext(field);
  }
 return true;
}
function isValidIpEntry_1(field,e) {
  IPfieldEntry(field);
  if(lastEntryChar(field,' '))
   field.value=field.value.substring(0,field.value.length);
   if(lastEntryChar(field,'.')||field.value.length==3) {
    if(isNValidIP(field.value) || field.value <1 || field.value >223) {
     field.value="192";
     field.select();
     return -1;
    }
   else if(field.value==127) {
    field.value="192";
    field.select();
    return -2;
   }
   else if(field.value.length<3)
    focusOnNext(field);
  }
 return 1;
}
function is_valid_domain_name(addr) {
 var valid=false;
 $.each(addr.split("."),function(i,v){
  valid=v.match(/^[a-zA-Z]([a-zA-Z0-9\\-]*[a-zA-Z0-9]$|[a-zA-Z0-9]*$)/)!=null;
  return valid;
 });
 return valid;
}
function isDomainNameFormat(addr) {
 addrParts = addr.split('.');
 return ( addrParts.length != 4 || isNaN(addrParts[0]) || isNaN(addrParts[1]) ||
    isNaN(addrParts[2]) || isNaN(addrParts[3]) );
}
function isValidIpAddress(address) {
var i = 0;
 if ( address == '0.0.0.0' || address == '255.255.255.255' )
  return false;
 addrParts = address.split('.');
 if ( addrParts.length != 4 ) return false;
 for (i = 0; i < 4; i++) {
  if (isNaN(addrParts[i]) || addrParts[i] =="")
   return false;
  num = parseInt(addrParts[i]);
  if ( num < 0 || num > 255 )
   return false;
 }
 return true;
}
function isValidIpAddress0(address) {
var i = 0;
 if ( address == '255.255.255.255' )
  return false;
 addrParts = address.split('.');
 if ( addrParts.length != 4 ) return false;
 for (i = 0; i < 4; i++) {
  if (isNaN(addrParts[i]) || addrParts[i] =="")
   return false;
  num = parseInt(addrParts[i]);
  if ( num < 0 || num > 255 )
   return false;
 }
 return true;
}
function isValidIpv6Address(addr) {
var ipv6RegexpPattern=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/
 return ipv6RegexpPattern.test(addr);
}
function getLeftMostZeroBitPos(num) {
var i = 0;
var numArr = [128, 64, 32, 16, 8, 4, 2, 1];
 for ( i = 0; i < numArr.length; i++ )
  if ( (num & numArr[i]) == 0 )
   return i;
 return numArr.length;
}
function getRightMostOneBitPos(num) {
var i = 0;
var numArr = [1, 2, 4, 8, 16, 32, 64, 128];
 for ( i = 0; i < numArr.length; i++ )
  if ( ((num & numArr[i]) >> i) == 1 )
   return (numArr.length - i - 1);
 return -1;
}
function printf(fmt) {
var reg = /%s/;
var result = new String(fmt);
 for (var i = 1; i < arguments.length; i++)
  result = result.replace(reg, new String(arguments[i]));
 document.write(result);
}
function RevIpBlocks(address, blocks){
var addrParts = address.split('.');
 if ( addrParts.length != 4 ) return false;
 for (i = 0; i < 4; i++) {
  if (isNaN(addrParts[i]) || addrParts[i] =="")
   return false;
  num = parseInt(addrParts[i]);
  if ( num < 0 || num > 255 )
   return false;
  eval(blocks+(i+1)+".value="+num);
 }
 return true;
}
function isValidSubnetMask(mask) {
var correct_range = {128:1,192:1,224:1,240:1,248:1,252:1,254:1,255:1,0:1};
var m = mask.split('.');
 for (var i = 0; i <= 3; i ++) {
  if (!(m[i] in correct_range)) {
   return -2;
  }
 }
 if (m.length!=4 || (m[0] != 255 && m[1] != 0) || (m[1] != 255 && m[2] != 0) || (m[2] != 255 && m[3] != 0)) {
  return -1;
 }
 return 1;
}
function isValidPort(port) {
var fromport = 0;
var toport = 100;
 portrange = port.split(':');
 if ( portrange.length < 1 || portrange.length > 2 ) {
  return false;
 }
 if ( isNaN(portrange[0]) )
  return false;
 fromport = parseInt(portrange[0]);
 if ( portrange.length > 1 ) {
  if ( isNaN(portrange[1]) )
   return false;
  toport = parseInt(portrange[1]);
  if ( toport <= fromport )
   return false;
 }
 if ( fromport < 1 || fromport > 65535 || toport < 1 || toport > 65535 )
  return false;
 return true;
}
function isValidNatPort(port) {
var fromport = 0;
var toport = 100;
 portrange = port.split('-');
 if ( portrange.length < 1 || portrange.length > 2 ) {
  return false;
 }
 if ( isNaN(portrange[0]) )
  return false;
 fromport = parseInt(portrange[0]);
 if ( portrange.length > 1 ) {
  if ( isNaN(portrange[1]) )
   return false;
  toport = parseInt(portrange[1]);
  if ( toport <= fromport )
   return false;
 }
 if ( fromport < 1 || fromport > 65535 || toport < 1 || toport > 65535 )
  return false;
 return true;
}
function isValidMacAddress(address) {
var c = '';
var i = 0, j = 0;
 address = address.replace(/\s+$/g,'');
 if ( address == 'ff:ff:ff:ff:ff:ff' ) return false;
 addrParts = address.split(':');
 if ( addrParts.length != 6 ) return false;
 for (i = 0; i < 6; i++) {
  if ( addrParts[i].length!=2 )
   return false;
  for ( j = 0; j < addrParts[i].length; j++ ) {
   c = addrParts[i].toLowerCase().charAt(j);
   if ( (c >= '0' && c <= '9') ||
    (c >= 'a' && c <= 'f') )
    continue;
   else
    return false;
  }
 }
 return true;
}
function maskBits(mask) {
 var bits=0;
 mask_array = mask.split('.');
 for (i = 0; i < 4; i++) {
  bits+=parseInt(mask_array[i]).toString(2).replace(/0/g, "").length;
 }
 return bits;
}
var hexVals = new Array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
              "A", "B", "C", "D", "E", "F");
var unsafeString = "\"<>%\\^[]`\+\$\,'#&";
function isUnsafe(compareChar) {
 if ( unsafeString.indexOf(compareChar) == -1 && compareChar.charCodeAt(0) > 32
   && compareChar.charCodeAt(0) < 123 )
  return false;
 return true;
}
function decToHex(num, radix) {
var hexString = "";
 while ( num >= radix ) {
  temp = num % radix;
  num = Math.floor(num / radix);
  hexString += hexVals[temp];
 }
 hexString += hexVals[num];
 return reversal(hexString);
}
function reversal(s) {
var len = s.length;
var trans = "";
 for (i = 0; i < len; i++)
  trans = trans + s.substring(len-i-1, len-i);
 s = trans;
 return s;
}
function convert(val) {
var hstr = decToHex(val.charCodeAt(0), 16);
 if (hstr.length > 1)
  return "%" + hstr;
 else if (hstr.length > 0)
  return "%0" + hstr;
}
function encodeUrl(val) {
var len = val.length;
var i = 0;
var newStr = "";
var original = val;
 for ( i = 0; i < len; i++ ) {
  if ( val.substring(i,i+1).charCodeAt(0) < 255 ) {
   if (isUnsafe(val.substring(i,i+1)) == false)
    newStr = newStr + val.substring(i,i+1);
   else
    newStr = newStr + convert(val.substring(i,i+1));
  } else {
   validate_alert ( "", "Found a non-ISO-8859-1 character at position: " + (i+1) + ",\nPlease eliminate before continuing.");
   newStr = original;
   i = len;
  }
 }
 return newStr;
}
function convertCharToAscii(val) {
    var pad = "00";
    var hstr = val.charCodeAt(0).toString(16);
    hstr = pad.substring(0, pad.length - hstr.length) + hstr;
    return "\\x" + hstr;
}
function convertCharToEntity(val) {
    var pad = "00";
    var hstr = val.charCodeAt(0).toString();
    hstr = pad.substring(0, pad.length - hstr.length) + hstr;
    return "&#" + hstr + ";";
}
function specialCharEscape(val, method, esc_chars) {
    var len = val.length;
    var i = 0;
    var newStr = "";
    if (typeof method === 'undefined') {
        method = 'e';
    }
    if (typeof esc_chars === 'undefined') {
        esc_chars = method == 'e' ? "\"'&<>" : "\"'\\";
    }
    for ( i = 0; i < len; i++ ) {
        var nextChar = val.substring(i,i+1);
        if (esc_chars.indexOf(nextChar) == -1) {
            newStr = newStr + nextChar;
        } else {
            newStr = newStr + (method == 'e' ? convertCharToEntity(nextChar) :
                                               convertCharToAscii(nextChar));
        }
    }
    return newStr;
}
function hex2a (hexx)
{
    var hex = hexx.toString();
    var str = '';
    for (var ix = 0; ix < hex.length; ix += 2) {
        str += String.fromCharCode(parseInt(hex.substr(ix, 2), 16));
    }
    return str;
}
function percent_decode (str)
{
    var percent_index;
    var search_index = 0;
    var result_str = '';
    var hex;
    percent_index = str.indexOf("%", search_index);
    while (percent_index != -1) {
        hex = str.slice(percent_index + 1, percent_index + 3);
        result_str += str.slice(search_index, percent_index) + hex2a(hex);
        search_index = percent_index + 3;
        percent_index = str.indexOf("%", search_index);
    }
    result_str += str.slice(search_index);
    return result_str;
}
var markStrChars = "\"'";
function isMarkStrChar(compareChar) {
 if ( markStrChars.indexOf(compareChar) == -1 )
  return false;
 return true;
}
function processMarkStrChars(str) {
var i = 0;
var retStr = '';
 for ( i = 0; i < str.length; i++ ) {
  if ( isMarkStrChar(str.charAt(i)) == true )
   retStr += '\\';
  retStr += str.charAt(i);
 }
 return retStr;
}
function showhide(element, sh) {
var status;
 if (document.getElementById) {
  if (sh == 1)
   status = "";
  else
   status = "none"
  document.getElementById(element).style.display = status;
 }
 else if (document.all) {
  if (sh == 1)
   status = "block";
  else
   status = "none"
  document.all[element].style.display = status;
 }
 else if (document.layers) {
  if (sh == 1)
   status = "block";
  else
   status = "none"
  document.layers[element].display = status;
 }
}
function getSelect(item) {
var idx;
 if (item.options.length > 0) {
     idx = item.selectedIndex;
     return item.options[idx].value;
 }
 return '';
}
function setSelect(item, value) {
 for (i=0; i<item.options.length; i++) {
  if (item.options[i].value == value) {
   item.selectedIndex = i;
   break;
  }
 }
}
function setCheck(item, value) {
 if ( value == '1' )
  item.checked = true;
 else
  item.checked = false;
}
function setDisable(item, value) {
 if ( value == 1 || value == '1' )
  item.disabled = true;
 else
  item.disabled = false;
}
function submitText(item) {
 return '&' + item.name + '=' + item.value;
}
function submitSelect(item) {
 return '&' + item.name + '=' + getSelect(item);
}
function submitCheck(item) {
var val;
 if (item.checked == true) {
  val = 1;
 }
 else {
  val = 0;
 }
 return '&' + item.name + '=' + val;
}
function HostDate() {
var currentTime = new Date();
var seconds = currentTime.getUTCSeconds();
var minutes = currentTime.getUTCMinutes();
var hours = currentTime.getUTCHours();
var month = currentTime.getUTCMonth() + 1;
var day = currentTime.getUTCDate();
var year = currentTime.getFullYear();
var seconds_str = " ";
var minutes_str = " ";
var hours_str = " ";
var month_str = " ";
var day_str = " ";
var year_str = " ";
 if(seconds < 10)
  seconds_str = "0" + seconds;
 else
  seconds_str = ""+seconds;
 if(minutes < 10)
  minutes_str = "0" + minutes;
 else
  minutes_str = ""+minutes;
 if(hours < 10)
  hours_str = "0" + hours;
 else
  hours_str = ""+hours;
 if(month < 10)
  month_str = "0" + month;
 else
  month_str = ""+month;
 if(day < 10)
  day_str = "0" + day;
 else
  day_str = day;
 return year+"."+month_str+"."+day_str+"-"+hours_str+":"+minutes_str;
}
function f_filterResults(n_win, n_docel, n_body) {
var n_result = n_win ? n_win : 0;
 if (n_docel && (!n_result || (n_result > n_docel)))
  n_result = n_docel;
 return n_body && (!n_result || (n_result > n_body)) ? n_body : n_result;
}
function f_clientWidth() {
 return f_filterResults (
  window.innerWidth ? window.innerWidth : 0,
  document.documentElement ? document.documentElement.clientWidth : 0,
  document.body ? document.body.clientWidth : 0
 );
}
var pre_wwidth = 0;
var left;
var currentLeft;
var top;
var currentTop;
function init_moveGUI() {
 var wwidth = f_clientWidth();
 if(wwidth>1024) {
  left = currentLeft = 558;
  top = currentTop = 110;
  document.getElementById( "banner" ).style['display']='';
 }
 else if(wwidth>666) {
  left = currentLeft = wwidth-460;
  top = currentTop = 110;
  document.getElementById( "banner" ).style['display']='';
 }
 else {
  left = currentLeft = 20;
  top = currentTop = 20;
  document.getElementById( "banner" ).style['display']='none';
 }
 document.getElementById( "basicGUI" ).style['left']=currentLeft+'px';
 document.getElementById( "basicGUI" ).style['top']=currentTop+'px';
}
function moveGUI() {
 var wwidth = f_clientWidth();
 if( Math.abs(wwidth - pre_wwidth)>20 ) {
  pre_wwidth = wwidth;
  if(wwidth>1024) {
   left=558;
   top=110;
   document.getElementById( "banner" ).style['display']='';
  }
  else if(wwidth>666) {
   left=wwidth-460;
   top=110;
   document.getElementById( "banner" ).style['display']='';
  }
  else {
   left=20;
   top=20;
   document.getElementById( "banner" ).style['display']='none';
  }
 }
 diff=Math.abs( currentLeft-left );
 if( diff>=2 ) {
  if( currentLeft<left )
   currentLeft=currentLeft+diff/2;
  else if( currentLeft>left )
   currentLeft=currentLeft-diff/2;
  document.getElementById( "basicGUI" ).style['left']=currentLeft+'px';
 }
 diff=Math.abs( currentTop-top );
 if( diff>=2 ) {
  if( currentTop<top )
   currentTop=currentTop+diff/2;
  else if( currentTop>top )
   currentTop=currentTop-diff/2;
  document.getElementById( "basicGUI" ).style['top']=currentTop+'px';
 }
}
function toAdvV(url) {
 $('#basicGUI').animate({
 opacity: 0.25,
 left: '+=50',
 height: 'toggle'
 }, 1000, function() {
   location.href=url;
 });
}
function IpCheck(IP1,IP2,IP3,IP4) {
 if (((isBlank(IP1))||(isNaN(IP1))||(IP1<0||IP1>255))||((isBlank(IP2))||(isNaN(IP2))||(IP2<0||IP2>255))||((isBlank(IP3))||(isNaN(IP3))||(IP3<0||IP3>255)) || ((isBlank(IP4))||(isNaN(IP4))||(IP4<0||IP4>255)))
  return false;
 return true;
}
function set_var_tag() {
 $("var").css("font-style","normal");
 $("var").each(function(e) {
  this.innerHTML=eval($(this).html());
 });
}
function sprintf(fmt) {
 var reg = /%s/;
 var result = new String(fmt);
 for (var i = 1; i < arguments.length; i++) {
  result = result.replace(reg, new String(arguments[i]));
 }
 return result;
}
function isValidNameEntry(field,e) {
 if(KeyCode(e)!=9){
  if(isCharUnsafe(field.value.charAt(field.value.length-1))) {
   field.value=field.value.slice(0,field.value.length-1);
   return false;
  }
 }
 return true;
}
function atoi(str, num) {
i=1;
 if(num != 1 ) {
  while (i != num && str.length != 0){
   if(str.charAt(0) == '.'){
    i++;
   }
   str = str.substring(1);
  }
  if(i != num )
   return -1;
 }
 for(i=0; i<str.length; i++) {
  if(str.charAt(i) == '.') {
   str = str.substring(0, i);
   break;
  }
 }
 if(str.length == 0)
  return -1;
 return parseInt(str, 10);
}
function isAllNum(str) {
 for (var i=0; i<str.length; i++){
  if((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.'))
   continue;
  return 0;
 }
 return 1;
}
function isAllNumAndSlash(str) {
 for (var i=0; i<str.length; i++){
  if( (str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.') || (str.charAt(i) == '/'))
   continue;
  return 0;
 }
 return 1;
}
function isNumOnly(str) {
 for (var i=0; i<str.length; i++){
  if((str.charAt(i) >= '0' && str.charAt(i) <= '9') )
   continue;
  return 0;
 }
 return 1;
}
function checkRange(str, num, min, max) {
 d = atoi(str,num);
 if(d > max || d < min)
  return false;
 return true;
}
function hasSubStr(str, substr) {
 return str.search(substr) >= 0;
}
function multiLangRadio(txt) {
 if(Butterlate.getLang()=="ar")
  document.write("<font dir=\"rtl\">"+_(txt));
 else
  document.write("<font>"+_(txt));
}
function toUpTime( uptime ) {
var upday = parseInt(uptime / (24 * 3600));
var uphr = parseInt((uptime - upday * 24 * 3600) / (3600));
var upmin = parseInt((uptime - upday * 24 * 3600 - uphr * 3600) / 60);
var upsec = parseInt(uptime - upday * 24 * 3600 - uphr * 3600 - upmin * 60);
 uphr=uphr<10?"0"+uphr.toString():uphr.toString();
 upmin=upmin<10?"0"+upmin.toString():upmin.toString();
 upsec=upsec<10?"0"+upsec.toString():upsec.toString();
 if (upday) {
  var buf2=upday.toString() + " Day";
  if (upday > 1)
   buf2=buf2+"s";
  buf2=buf2+"  ";
 }
 else {
  buf2="";
 }
 return buf2+uphr+":"+upmin+":"+upsec;
}
function checkIE10() {
var pos=navigator.userAgent.indexOf("MSIE");
 if(pos!=-1 && (parseInt(navigator.userAgent.substr(pos+4, 10))>=9) ) {
  $('.Rotate-90').removeClass('Rotate-90').addClass('Rotate-90-IE10');
 }
}
function breakWord(inString, maxWordLength, htmlEncode) {
 if( inString=="" || inString==null || inString.length==null ) {
  return "";
 }
 var mystr = inString.match(new RegExp('[\\S]{1,}', 'g'));
 var retstr="";
 for(x=0;x<mystr.length;x++) {
  var mystr2 = mystr[x].match(new RegExp('[\\s\\S]{1,'+maxWordLength+'}', 'g'));
  if(mystr2.length==1) {
   retstr+=htmlEncode==1?htmlNumberEncode(mystr[x]):mystr[x]+" ";
  }
  else {
   for(y=0;y<mystr2.length;y++) {
    retstr+=htmlEncode==1?htmlNumberEncode(mystr2[y]):mystr2[y]+"<br/>";
   }
  }
 }
 return retstr;
}
function add_options(myid, mylist, def) {
 $.each( ["#"+myid], function(idx,el) {
  $.each(
   mylist, function(val,txt) { $(el).append("<option value='"+val+"'>"+txt+"</option>");}
  );
 });
 if(def!="") {
  $("#"+myid).val(def);
 }
}
function set_menu(top, side, user) {
 function genHtmlForSimpleMenu(label,name,url) {
  var active = ' ';
  if (label==side)
   active=" class='active' ";
  return "<li><a"+active+"href="+url+">"+name+"</a></li>";
 }
 function generateHtmlForMenu(menuName, subMenus) {
  var open ="";
  var hide = " hide";
  var html="";
  var numMenus = subMenus.length;
  if (numMenus==0)
   return "";
  for ( var i = 0; i < numMenus; i++ )
  {
   var subMenu=subMenus[i];
   if (subMenu.length < 3 ) {
    continue;
   }
   var subMenuLabel=subMenu[0];
   var subMenuName=subMenu[1];
   var subMenuUrl=subMenu[2];
   var active = " ";
   if (subMenuLabel==side) {
    active =" class='active' ";
    open = " class='open'";
    hide = "";
   }
   html += "<a"+active+"href="+subMenuUrl+">"+subMenuName+"</a>";
  }
  html += "</div></li>";
  return "<li"+open+"><a class='expandable'>"+menuName+"</a><div class='submenu"+hide+"'>"+html;
 }
 var top_menu_list = ["Status", "Internet", "Services", "System", "Help"];
 var c=new Array();
 $.each(top_menu_list, function(i,j) {c[j]="";});
 c[top]=" class='active'";
 c["Help"]=" class='help' ";
var h_top="<div class='container'><header class='site-header'>	<a href='http://www.netcommwireless.com' target='_blank'><h1 class='grid-4 alpha'>M2M</h1></a>	<nav class='top-right grid-9 omega'>		<ul class='main-menu list-inline'>			<li"+c["Status"]+"><a href='status.html'>"+"Status"+"</a></li>";
  h_top+="<li"+c["Internet"]+"><a href='Profile_Name_List.html'>"+"Networking"+"</a></li>";
  h_top+="<li"+c["Services"]+"><a href='ddns.html'>"+"Services"+"</a></li>";
  h_top+="<li"+c["System"]+"><a href='administration.html'>"+"System"+"</a></li>			<li"+c["Help"]+"><a href='help.html'>"+"Help"+"</a></li>		</ul>	</nav></header>	<div class='header_bar'>";
 if(typeof(multi_lang)!="undefined" && multi_lang>0) {
  h_top+="<div class='left-item'>";
  if(typeof(current_lang)!="undefined" && current_lang=="en") {
   h_top+="<a href='javascript:setLanguage(\"en\")'>English</a>";
  }
  else {
   h_top+="<a href='javascript:setLanguage(\"en\")' style='color:#aaa'>English</a>";
  }
  h_top+="</div>"
 }
 h_top+="<div class='right-item account-btn'>			<span class='login-foot'></span><span style='color:#fff;margin-left:65px;position:relative;top:-20px'>"+user+"</span>			<span id='logOff'><a class='log-off' href='index.html?logoff'></a></span>		</div>	</div>	</div>";
 $("#main-menu").append(h_top);
 if(side!="") {
 switch(top) {
 case "Internet":
  var h_side="<ul>";
  h_side += generateHtmlForMenu("Wireless WAN", [
    ["Profile_List","Data connection",'Profile_Name_List.html'],
    ["DOD","Connect on demand",'dod.html'],
    ["BAND","Operator settings",'setband.html'],
    ["SIMMGMT","SIM management",'sim_management.html'],
    ["SIM_Security","SIM security settings",'pinsettings.html']
    ]);
  h_side += generateHtmlForMenu("LAN", [
    ["LAN", "LAN", 'LAN.html'],
    ["DHCP","DHCP",'DHCP.html']
    ]);
  h_side += generateHtmlForMenu("Ethernet LAN/WAN", [
    ["LANWAN_Switch", "Interface assignment", 'lanwan_switch.html'],
    ["ETHWAN","WAN configuration",'ethwan.html']
    ]);
  h_side+=genHtmlForSimpleMenu("PPPOE","PPPoE",'pppoe.html');
  h_side+=genHtmlForSimpleMenu("WAN","WAN failover",'wan_summary.html');
  dynamicMenus = [];
  dynamicMenus.push(["STATIC_ROUTING", "Static", 'routing.html']);
  dynamicMenus.push(["RIP", "RIP", 'RIP.html']);
  dynamicMenus.push(["VRRP", "Redundancy (VRRP)", 'VRRP.html']);
  dynamicMenus.push(["NAT", "Port forwarding", 'NAT.html']);
  dynamicMenus.push(["DMZ", "DMZ", 'DMZ.html']);
  if(user == "root") {
   dynamicMenus.push(["FIREWALL", "Router firewall", 'firewall.html']);
  }
  dynamicMenus.push(["PORT_FILTER", "MAC / IP / Port filtering", 'port_filtering.html']);
  h_side += generateHtmlForMenu("Routing", dynamicMenus );
  h_side += generateHtmlForMenu("VPN", [
    ["IP_Sec", "IPSec", 'VPN_ipsec.html'],
    ["OpenVPN","Open VPN",'VPN_openvpn.html'],
    [ "pptpClient", "PPTP client",'VPN_pptpc.html'],
    [ "GRE","GRE tunnelling",'VPN_gre.html']
    ]);
        h_side+="</ul>";
 break;
 case "Services":
  var h_side="<ul>";
  h_side += genHtmlForSimpleMenu("DDNS","Dynamic DNS",'ddns.html');
  h_side += genHtmlForSimpleMenu("NTP","Network time (NTP)",'NTP.html');
  h_side += generateHtmlForMenu("Data stream manager", [
    ["EDP","Endpoints",'end_points.html'],
    ["DSS","Streams",'data_stream.html']
   ]);
  h_side += genHtmlForSimpleMenu("PADD","PADD",'padd.html');
  var remoteManagementMenus = [];
  remoteManagementMenus.push( ["SNMP","SNMP",'snmp.html']);
  remoteManagementMenus.push(["TR","TR-069",'TR069.html'] );
  remoteManagementMenus.push(["LWM2M","OMA-LWM2M",'LWM2M.html']);
  h_side += generateHtmlForMenu("Remote management", remoteManagementMenus );
  h_side += generateHtmlForMenu("GPS", [
    ["GPS","GPS configuration",'gps.html']
    ,["MSB","MSB (A-GPS)",'msb.html']
    ,["ODOMETER","Odometer",'odometer.html']
    ,["GEOFENCE","Geofence",'gps_geofence.html']
   ]);
  h_side += genHtmlForSimpleMenu("IOCONFIG","IO configuration", 'IO_configuration.html');
  h_side += generateHtmlForMenu("Event notification", [
    ["EVENT_NOTI","Notification configuration",'event_noti.html'],
    ["EVENT_DEST","Destination configuration",'event_dest.html']
   ]);
  h_side += genHtmlForSimpleMenu("EMAIL_CLIENT","Email settings",'email_client.html');
  h_side += generateHtmlForMenu("SMS messaging", [
    ["SMS_Setup","Setup",'SMS_Setup.html'],
    ["SMS_NewMag","New message",'SMS_New_Message.html'],
    ["SMS_Inbox","Inbox",'SMS_Inbox.html'],
    ["SMS_Outbox","Sent items",'SMS_Outbox.html'],
    ["SMS_Diag","Diagnostics",'SMS_Diagnostics.html']
   ]);
  h_side += "</ul>";
 break;
 case "System":
  var h_side="<ul>";
  h_side+= generateHtmlForMenu("Log", [
    ["LOG","System log",'logfile.html']
    ,["DIAGNOSTICLOG","Diagnostic Log",'diagnosticlog.html']
    ,["IPSECLOG","IPSec log",'ipseclog.html']
    ,["EVENTNOTILOG","Event notification log",'eventnotilog.html']
    ,["LOGSETTINGS","System log settings",'logsettings.html']
   ]);
  if(user=="root") {
   h_side+= generateHtmlForMenu("System configuration", [
     ["SETTINGS","Settings backup and restore",'SaveLoadSettings.html']
     ,["UPLOAD","Upload",'AppUpload.html']
     ,["PKG_MANAGER","Package manager",'pkManager.html']
    ]);
  }
  h_side+= generateHtmlForMenu("Administration", [
    ["ADMINISTRATION","Administration settings",'administration.html']
    ,["CERTIFICATE","Server certificate",'server_certificate.html']
    ,["SSH","SSH key management",'SSH.html']
    ,["LED","LED operation mode",'led_mode.html']
   ]);
  h_side+="<li id='customMenu' style='display:none'>				<a class='expandable'>"+"Custom menu"+"</a>				<div class='submenu' id='subCustomMenu'></div>			</li>";
  h_side+= genHtmlForSimpleMenu("Sys_Monitor","Watchdogs",'ltph.html');
  h_side+= genHtmlForSimpleMenu("POWERSAVE","Power management",'low_power_standby.html');
  if(user=="root") {
   h_side+=genHtmlForSimpleMenu("USBOTG","USB-OTG",'usbotg.html');
   if (nas_installed == "1") {
    h_side+=genHtmlForSimpleMenu("NAS","Storage",'nas.html');
   }
  }
  h_side+= genHtmlForSimpleMenu("RESET","Reboot",'Reboot.html')
   + "</ul>";
 break;
 }
 $("#side-menu").append(h_side);
 }
 set_var_tag();
 hidePPPoE();
 $.get("/cgi-bin/usermenu.cgi", function(v) {
  if (v!="") {
   $("#customMenu").css("display", "");
   $("#subCustomMenu").html(v);
  }
 });
 $("input[type=text]").keyup(function(e) {
  var code = e.keyCode || e.which;
  if (code == '9') {
   $(this).select();
  }
 });
 $(document).attr("title", "NetComm Wireless Router");
}
function hidePPPoE()
{
 if(service_pppoe_server_0_enable=="1" && service_pppoe_server_0_wanipforward_enable=="1") {
  $(".hide_for_pppoe_en").css("display", "none");
  $(".pppoeEnablesMsg").css("display", "");
 }
}
function blockUI_alert(msg, func) {
 if($.type(func)!="undefined") {
  myfunc=func;
 }
 else {
  myfunc=function() {
  };
 }
 $.blockUI( {message: msg+"		<div class='button-raw med'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>"+"OK"+"</button>		</div>", css: {width:'320px', padding:'20px 20px'}
 });
}
function blockUI_alert_l(msg, func) {
 if($.type(func)!="undefined") {
  myfunc=func;
 }
 else {
  myfunc=function() {
  };
 }
 if($.type(msg)!="undefined" && msg.length>50) {
  align="left";
 }
 else {
  align="center";
 }
 $.blockUI( {message: "<div style='text-align:"+align+";'>"+msg+"		<div class='button-raw med'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>"+"OK"+"</button>		</div></div>", css: {width:'320px', padding:'20px 20px'}
 });
}
function blockUI_confirm(msg, func1, func2) {
 myfunc=func1;
 myfunc2=function(){return;}
 if (typeof func2 == 'function') {
  myfunc2=func2
 }
 $.blockUI( {message: msg+"		<div class='button-double'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>"+"OK"+"</button><button class='secondary med' onClick='$.unblockUI();" + "myfunc2();'>"+"Cancel"+"</button>		</div>", css: {width:'380px', padding:'20px 20px'}
 });
}
function blockUI_confirm_l(msg, func1, func2) {
 myfunc=func1;
 myfunc2=function(){return;}
 if (typeof func2 == 'function') {
  myfunc2=func2
 }
 if(msg.length>50) {
  align="left";
 }
 else {
  align="center";
 }
 $.blockUI( {message: "<div style='text-align:"+align+";'>"+msg+"		<div class='button-double'>		<button class='secondary med' onClick='$.unblockUI();myfunc();'>"+"OK"+"</button><button class='secondary med' onClick='$.unblockUI();" + "myfunc2();'>"+"Cancel"+"</button>		</div></div>", css: {width:'380px', padding:'20px 20px'}
 });
}
function validate_alert( t1, t2, t3 ) {
 $.unblockUI();
 if(typeof(t1)=="undefined" || t1=="") {
  t1="Oops, something went wrong...";
 }
 if(typeof(t2)=="undefined" || t2=="") {
  t2=eval(VALIDATOR.config.errors.summary);
 }
 var e=$(window.document.forms[0]), g="form-error";
 a='<li><a class="link-text jump-link" href="#{id}"><span class="icon icon-arrow-r"></span>{error}</a></li>';
 h='<div class="note" id="'+g+'">			<div class="wrap failure">				<h2><span class="access">'+VALIDATOR.config.strings.error+'</span>'+t1+'</h2>';
    if (t3==true) {
     var len = t2.length;
     for (i = 0; i < len; i++)
      h+='<p>'+t2[i]+'</p>';
    } else {
     h+='<p>'+t2+'</p>';
    }
    h+='<ul class="list-plain"></ul>			</div>		</div>';
 h=$(h);
 if(e.attr("data-summary")==="false") {
  return;
 }
 e.prev(".note").remove();
 e.before(h);
 window.location.hash=g;
 $("#form").validationEngine("updatePromptsPosition");
}
function clear_alert() {
 var e=$(window.document.forms[0]);
 e.prev(".note").remove();
 $("#form").validationEngine("hideAll");
}
function success_alert(t1, t2) {
 if(typeof(t1)=="undefined" || t1=="") {
  t1="Success!";
 }
 if(typeof(t2)=="undefined" || t2=="") {
  t2="Your configuration changes were successfully saved and applied";
 }
 var e=$(window.document.forms[0]), g="form-success";
 h='<div class="note">			<div class="wrap success" style="padding-bottom:6px">				<h2>'+t1+'</h2>				<p>'+t2+'</p>			</div>		</div>';
 h=$(h);
 if(e.attr("data-summary")==="false") {
  return;
 }
 e.prev(".note").remove();
 e.before(h);
 window.location.hash=g;
}
(function(){this.VALIDATOR={}}).call(this);
(function() {
VALIDATOR.config={
 strings:{
  error: "Error"+' - '
 },
 errors:{
  error: "Error"+' - ',
  summary: "Please correct these error(s)",
  title: "Sorry there has been {number} error(s)"
 }
};
}(VALIDATOR));
(function($) {
$.fn.validationEngineLanguage = function(){};
$.validationEngineLanguage = {
 newLang: function(){
  $.validationEngineLanguage.allRules = {
   "required": {
    "regex": "none",
    "alertText": "This field is required.",
    "alertTextCheckboxMultiple": "* Please select an option",
    "alertTextCheckboxe": "* This checkbox is required",
    "alertTextDateRange": "* Both date range fields are required"
   },
   "requiredInFunction": {
    "func": function(field, rules, i, options){
     return (field.val() == "test") ? true : false;
    },
    "alertText": "* Field must equal test"
   },
   "dateRange": {
    "regex": "none",
    "alertText": "* Invalid ",
    "alertText2": "Date Range"
   },
   "dateTimeRange": {
    "regex": "none",
    "alertText": "* Invalid ",
    "alertText2": "Date Time Range"
   },
   "minSize": {
    "regex": "none",
    "alertText": "* Minimum ",
    "alertText2": " characters required"
   },
   "maxSize": {
    "regex": "none",
    "alertText": "* Maximum ",
    "alertText2": " characters allowed"
   },
   "groupRequired": {
    "regex": "none",
    "alertText": "You must fill in one of these fields"
   },
   "min": {
    "regex": "none",
    "alertText": "* Minimum value is "
   },
   "max": {
    "regex": "none",
    "alertText": "* Maximum value is "
   },
   "past": {
    "regex": "none",
    "alertText": "* Date prior to "
   },
   "future": {
    "regex": "none",
    "alertText": "* Date past "
   },
   "maxCheckbox": {
    "regex": "none",
    "alertText": "* Maximum ",
    "alertText2": " options allowed"
   },
   "minCheckbox": {
    "regex": "none",
    "alertText": "* Please select ",
    "alertText2": " options"
   },
   "equals": {
    "regex": "none",
    "alertText": "Password mismatched!"
   },
   "creditCard": {
    "regex": "none",
    "alertText": "* Invalid credit card number"
   },
   "phone": {
    "regex": /^([\+][0-9]{1,3}[\ \.\-])?([\(]{1}[0-9]{2,6}[\)])?([0-9\ \.\-\/]{3,20})((x|ext|extension)[\ ]?[0-9]{1,4})?$/,
    "alertText": "* Invalid phone number"
   },
   "email": {
    "regex": /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
    "alertText": "* Invalid email address"
   },
   "integer": {
    "regex": /^[\-\+]?\d+$/,
    "alertText": "* Not a valid integer"
   },
   "number": {
    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,
    "alertText": "* Invalid floating decimal number"
   },
   "date": {
  "func": function (field) {
    var pattern = new RegExp(/^(\d{4})[\/\-\.](0?[1-9]|1[012])[\/\-\.](0?[1-9]|[12][0-9]|3[01])$/);
    var match = pattern.exec(field.val());
    if (match == null)
     return false;
    var year = match[1];
    var month = match[2]*1;
    var day = match[3]*1;
    var date = new Date(year, month - 1, day);
    return (date.getFullYear() == year && date.getMonth() == (month - 1) && date.getDate() == day);
   },
   "alertText": "* Invalid date, must be in YYYY-MM-DD format"
   },
   "ipv4": {
    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,
    "alertText": "* Invalid IP address"
   },
   "url": {
    "regex": /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i,
    "alertText": "* Invalid URL"
   },
   "coapurl": {
    "regex": /^(coaps?):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?$/i,
    "alertText": "* Invalid URL; example: coap://server.com"
   },
   "onlyNumber": {
    "regex": /^[0-9]+$/,
    "alertText": "* Numbers only"
   },
   "onlyNumberSp": {
    "regex": /^[0-9\ ]+$/,
    "alertText": "* Numbers only"
   },
   "onlyLetterSp": {
    "regex": /^[a-zA-Z\ \']+$/,
    "alertText": "* Letters only"
   },
   "onlyLetterNumber": {
    "regex": /^[0-9a-zA-Z]+$/,
    "alertText": "* No special characters allowed"
   },
   "ajaxUserCall": {
    "url": "ajaxValidateFieldUser",
    "extraData": "name=eric",
    "alertText": "* This user is already taken",
    "alertTextLoad": "* Validating, please wait"
   },
   "ajaxUserCallPhp": {
    "url": "phpajax/ajaxValidateFieldUser.php",
    "extraData": "name=eric",
    "alertTextOk": "* This username is available",
    "alertText": "* This user is already taken",
    "alertTextLoad": "* Validating, please wait"
   },
   "ajaxNameCall": {
    "url": "ajaxValidateFieldName",
    "alertText": "* This name is already taken",
    "alertTextOk": "* This name is available",
    "alertTextLoad": "* Validating, please wait"
   },
    "ajaxNameCallPhp": {
     "url": "phpajax/ajaxValidateFieldName.php",
     "alertText": "* This name is already taken",
     "alertTextLoad": "* Validating, please wait"
    },
   "validate2fields": {
    "alertText": "* Please input HELLO"
   },
   "dateFormat":{
    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/,
    "alertText": "* Invalid Date"
   },
   "dateTimeFormat": {
    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/,
    "alertText": "* Invalid Date or Date Format",
    "alertText2": "Expected Format: ",
    "alertText3": "mm/dd/yyyy hh:mm:ss AM|PM or ",
    "alertText4": "yyyy-mm-dd hh:mm:ss AM|PM"
   }
  };
 }
};
$.validationEngineLanguage.newLang();
})(jQuery);
function blockUI_wait(msg) {
 $.blockUI({centerX: true, centerY: true, css: { left: parseInt($(window).width()/2-150)+"px", top:"320px", width: "300px", padding: "20px 30px"}, message: msg+"&nbsp;&nbsp;<i class='progress-sml' style='padding-bottom:2px;'></i>"});
}
function rdb_tool(token) {
 var opt_idx=1;
 var opt_obj=new Object();
 var csrf_token=token;
 opt_obj["csrfTokenGet"]=csrf_token;
 this.reset=function() {
  opt_idx=1;
  opt_obj=new Object();
  opt_obj["csrfTokenGet"]=csrf_token;
 };
 this.set_flag=function(flags) {
  opt_obj["flag"]=flags;
 };
 this.add_to_mget=function(cfg){
  var rdb=this;
  $.each(cfg,function(i,o){
   if((typeof o != 'undefined') && (o.el != null))
    rdb.add(o.rdb);
  });
 };
 this.add_to_mset=function(cfg) {
  var rdb=this;
  $.each(cfg,function(i,o){
   var val;
   if(typeof o != 'undefined')
    if(o.el == null)
     val=o.def;
    else
     val=load_value_from_element(o.el);
   if((typeof o != 'undefined') && (o.el != null))
    rdb.add(o.rdb,val);
  });
 };
 this.get_ctrls=function(cfg) {
  var ctrls=new Array();
  $.each(cfg,function(i,o){
   if((typeof o == 'undefined') || (o.el == null))
    return;
   if(is_ip_address_element(o.el))
    ctrls.push(get_ip_address_elements(o.el));
   else
    ctrls.push(o.el);
  });
  return ctrls.join(",");
 };
 this.disable_ctrl=function(cfg,dis) {
  $(this.get_ctrls(cfg)).attr("disabled",dis);
 };
 this.pour_to_ctrl=function(res,cfg) {
  $.each(cfg,function(i,o){
   if((typeof o == 'undefined') || (o.el == null))
    return true;
   var val;
   if($.type(res[o.rdb]) === "undefined" || $.type(res[o.rdb]) === "null" || res[o.rdb] == "")
    val=o.def;
   else
    val=res[o.rdb];
   load_value_to_element(o.el,val);
  });
 };
 this.add=function(rdb_var,rdb_val) {
  var rdbs=Array();
  if(rdb_var instanceof Array) {
   $.merge(rdbs,rdb_var)
  }
  else {
   rdbs.push(rdb_var);
  }
  if(rdb_val instanceof Array) {
   $.merge(rdbs,rdb_val)
  }
  else if(rdb_val!==undefined) {
   rdbs.push(rdb_val);
  }
  $.each(rdbs,function(i,v){
   opt_obj["opt"+opt_idx]=v;
   opt_idx++;
  });
 };
 this.mget=function(func) {
  opt_obj["cmd"]="rdb_mget";
  $.getJSON(
   "./cgi-bin/rdb_tool.cgi",
   opt_obj,
   func
  );
 };
 this.mset=function(func) {
  opt_obj["cmd"]="rdb_mset";
  $.getJSON(
   "./cgi-bin/rdb_tool.cgi",
   opt_obj,
   func
  );
 };
 this.wait_for_rdb_chg=function(rdb_to_wait,cur,timeout,func) {
  var timer;
  var s;
  var n;
  s=$.now();
  var rdb=this;
  var timer_func=function(){
   n=$.now();
   if( n-s >= timeout ) {
    func(cur);
    return;
   }
   rdb.reset();
   rdb.add(rdb_to_wait);
   rdb.mget(function(res){
    if(res[rdb_to_wait]==cur) {
     timer=setTimeout(timer_func,500);
    }
    else {
     func(res[rdb_to_wait]);
    }
   });
  };
  timer=setTimeout(timer_func,500);
 };
 this.wait_for_rdb_result=function(rdb_to_wait,timeout,func) {
  this.wait_for_rdb_chg(rdb_to_wait,"",timeout,func);
 }
}
function cgi(bin, token) {
 var url=bin;
 var opt_idx=1;
 var opt_obj=new Object();
 var csrf_token;
 if (token !== undefined) {
  csrf_token=token;
  opt_obj["csrfTokenGet"]=csrf_token;
 }
 this.reset=function() {
  opt_idx=1;
  opt_obj=new Object();
  if (csrf_token !== undefined) {
   opt_obj["csrfTokenGet"]=csrf_token;
  }
 };
 this.dn=function(cmd,func) {
  opt_obj["cmd"]=cmd;
  var form=$("<form/>");
  form.attr("action",url+"?"+$.param(opt_obj));
  form.attr("method","post");
  form.attr("encType","multipart/form-data");
  form.attr("style","display:none");
  form.appendTo("body");
  form.submit();
  form.remove();
 }
 this.reset_up=function(el) {
  $(el).closest("form").each(function(){
   this.reset();
  });
 }
 this.up=function(el,complete_func,preserveResponseFormatting) {
  if (preserveResponseFormatting === undefined) {
   preserveResponseFormatting = false;
  }
  var upload_input=$(el);
  if(!$("#postiframe").length) {
   $("<iframe id='postiframe' name='postiframe' style='width: 0; height: 0; border: none;'></iframe>").appendTo("body");
  }
  var form = $(el).closest("form");
  $("#postiframe").unbind("load");
  $("#postiframe").load(function(){
   var doc=$("#postiframe").contents();
   if (preserveResponseFormatting) {
    var res=doc.find("body pre").text();
   } else {
    var res=doc.find("body pre").html();
   }
   complete_func($.parseJSON(res));
  });
  form.attr("action", url+"?"+$.param(opt_obj));
  form.attr("method", "post");
  form.attr("enctype", "multipart/form-data");
  form.attr("encoding", "multipart/form-data");
  form.attr("target", "postiframe");
  form.submit();
 };
 this.add=function(opt) {
  var opts=Array();
  if(opt instanceof Array) {
   $.merge(opts,opt)
  }
  else {
   opts.push(opt);
  }
  $.each(opts,function(i,v){
   opt_obj["opt"+opt_idx]=v;
   opt_idx++;
  });
 };
 this.setcmd=function(cmd) {
  opt_obj["cmd"]=cmd;
 };
 this.run=function(cmd,func) {
  opt_obj["cmd"]=cmd;
  $.getJSON(
   url,
   opt_obj,
   func
  );
 };
 this.poll=function(interval,cmd,func) {
  var this_cgi=this;
  this.run(cmd,function(r){
   var res=func(r);
   if((res===undefined || res==true) && (interval>0))
    setTimeout(
     function() {
      this_cgi.poll(interval,cmd,func);
     },
     interval
    );
  });
 }
}
var windowConfirm;
var windowPrompt;
function check_insert_rtl( txt ) {
 if(Butterlate.getLang()!="ar")
  return txt;
 var ray = new Array();
 var retStr="";
 ray = txt.split("\n");
 for(i=0; i<ray.length; i++)
  retStr = retStr+"\u202b"+ray[i]+"\n";
 return retStr;
}
function check_phoneRegex(e) {
var phoneRegEx = /[^(\d+\+)]/g;
 e.value=e.value.replace(phoneRegEx,'');
}
function overridewindowAlert() {
 windowConfirm=window.confirm;
 windowPrompt=window.prompt;
 window.alert = function(txt) {
  blockUI_alert_l( check_insert_rtl( txt ) );
 }
 window.confirm = function(txt) {
  return windowConfirm( check_insert_rtl( txt ) );
 }
 window.prompt = function(txt,def) {
  return windowPrompt(check_insert_rtl( txt ),check_insert_rtl( def ));
 }
}
overridewindowAlert();
function row_display(id, display) {
 if(document.getElementById){
  var el = document.getElementById(id);
  el.style.display = display ? '' : 'none';
 }
}
function get_ip_address_elements(el) {
 if(el[0]=="#")
  return false;
 var els=new Array();
 for(i=1;i<=4;i++)
  els.push("#" + el + i);
 var ids=els.join(",");
 if( $(ids).filter(".ip-adress").length==4 )
  return ids;
 return "";
}
function is_ip_address_element(el) {
 return get_ip_address_elements(el)!="";
}
function load_value_from_element(el) {
 if(is_ip_address_element(el))
  return parse_ip_from_fields(el);
 else if($(el).is("input:radio.access")) {
  if( $(el).filter(":checked").length>0 )
   return $(el).filter(":checked").val();
 }
 return $(el).val();
}
function load_value_to_element(el,val) {
 var toggle_element;
 if($(el).is("input:checkbox"))
  $(el).prop("checked",val);
 else if($(el).is("input:radio.access")) {
  if($.type(val)=="string") {
   val=(val=="on" || val=="1")?true:false;
  }
  else if($.type(val)=="number") {
   val=(val>0)?true:false;
  }
  if($.type(val)=="boolean") {
   if( $(el).filter("[value=on]").length>0 )
    filter=val?"[value=on]":"[value=off]";
   if( $(el).filter("[value=yes]").length>0 )
    filter=val?"[value=yes]":"[value=no]";
   else if( $(el).filter("[value=1]").length>0 )
    filter=val?"[value=1]":"[value=0]";
   else
    filter=val?":first":":last";
  }
  else if ( ($.type(val)=="undefined") || (val=="") )
   filter=":first";
  else
   filter="[value="+val+"]";
  $(el).filter(filter).prop("checked",true);
  $(el).blur();
  toggle_element=$(el).parent().attr("data-toggle-element");
  if(toggle_element!==undefined) {
   $("#"+toggle_element).toggle(val);
  }
 }
 else if($(el).is("select")) {
  $(el).children("[value='"+val+"']").attr("selected",true);
  $(el).val(val);
 }
 else if(is_ip_address_element(el)) {
  parse_ip_into_fields(val,el);
 }
 else if($(el).is("span")) {
  $(el).html(val);
 }
 else {
  $(el).val(val);
 }
}
function load_values_from_elements(cfg) {
 var res={};
 $.each(cfg, function(el,rdb) {
  res[rdb]=load_value_from_element(el);
 });
 return res;
}
function load_values_to_elements(cfg) {
 $.each(cfg,
  function(el,val) {
   load_value_to_element(el,val);
  }
 );
}
function lang_sentence(stc, arr) {
 for(i in arr) {
  stc=stc.replace("%%"+i, arr[i]);
 }
 return stc;
}
function is_touch_device() {
 return ('ontouchstart' in window) || (navigator.userAgent.indexOf('IEMobile') !== -1);
}
function is_edge_browser() {
 return (navigator.userAgent.indexOf('Edge') !== -1);
}
function parseQueryString(queryString) {
 var params = {};
 queryString.split("&").forEach ( function(param) {
   temp = param.split('=');
   params[temp[0]] = temp[1];
  } );
 params.getParamByName = function ( paramName ) {
  param = this[paramName];
  if ( param === undefined )
   return "";
  return param;
 };
 return params;
};
function htmlNumberEncode(input) {
 var i = 0;
 var c = 0;
 var string = "";
 for (i = 0; i < input.length; i++) {
  c = input.charCodeAt(i);
  string += "&#" + c + ";";
 }
 return string;
}
var Base64 = {
    _keyStr : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
    encode : function (input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        input = Base64._utf8_encode(input);
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }
            output = output +
            this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
            this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);
        }
        return output;
    },
    decode : function (input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;
        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
        while (i < input.length) {
            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;
            output = output + String.fromCharCode(chr1);
            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }
        }
        output = Base64._utf8_decode(output);
        return output;
    },
    _utf8_encode : function (string) {
        string = string.replace(/\r\n/g,"\n");
        var utftext = "";
        for (var n = 0; n < string.length; n++) {
            var c = string.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    },
    _utf8_decode : function (utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;
        while ( i < utftext.length ) {
            c = utftext.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i+1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i+1);
                c3 = utftext.charCodeAt(i+2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}
function alertInvalidCsrfToken() {
 validate_alert( "Invalid security token", "Your browser sent an invalid security token. Please close the browser and try again.");
}
function alertInvalidRequest() {
 validate_alert( "Invalid request", "The submitted request is invalid. Please try again.");
}
function getUtf8StringLengthInBytes(string) {
 var length = 0;
 for (var n = 0; n < string.length; n++) {
  var c = string.charCodeAt(n);
  if (c < 128) {
   length++;
  }
  else if((c > 127) && (c < 2048)) {
   length += 2;
  }
  else {
   length += 3;
  }
 }
 return length;
}
function passStrengthValidation(PassStr, score) {
 var token, PassLen, result, passScore;
 var nUpper=0, nLower=0, nSpecial=0, nNum=0, nCons=0;
 PassLen = PassStr.length;
 if (typeof(score) == "undefined") {
  result = zxcvbn(PassStr);
  passScore = result.score;
 } else {
  passScore = score;
 }
 token = PassStr.match(/[A-Z]/g);
 if (token)
  nUpper = token.length;
 token = PassStr.match(/[a-z]/g);
 if (token)
  nLower = token.length;
 token = PassStr.match(/[0-9]/g);
 if (token)
  nNum = token.length;
 nSpecial = PassLen - (nUpper + nLower + nNum);
 return (PassLen <= 128 && PassLen >= 8 && nNum > 0 && nUpper > 0 && nSpecial > 0 && passScore >= 2);
}
function getPassStrength(PassStr) {
 var result;
 if (PassStr.length == 0)
  return 'none';
 if (PassStr.length > 128)
  return 'too_long';
 var result = zxcvbn(PassStr.substring(PassStr.length - 48));
 if (result.score >= 2) {
  if (passStrengthValidation(PassStr, result.score))
   return 'strong';
  else
   return 'medium';
 } else if (result.score >= 1) {
  return 'medium';
 } else if (result.score >= 0) {
  return 'weak';
 }
 return 'none';
}
function updatePassStrengthField(t, strength, title) {
 if (strength == 'strong') {
  if (title)
   t.title = "Strong password";
  else
   t.innerHTML = "Strong password";
  t.style.color="Green";
 } else if (strength == 'medium') {
  if (title)
   t.title = "Medium password";
  else
   t.innerHTML = "Medium password";
  t.style.color="Orange";
 } else if (strength == 'weak') {
  if (title)
   t.title = "Weak password";
  else
   t.innerHTML = "Weak password";
  t.style.color="Red";
 } else if (strength == 'too_long') {
  if (title)
   t.title = "Password is too long";
  else
   t.innerHTML = "Password is too long";
  t.style.color="Red";
 } else {
  if (title)
   t.title = "";
  else
   t.innerHTML = "";
  t.style.color="Black";
 }
}
function updatePassStrength(f, t) {
 var PassStr, strength = 0;
 PassStr = f.value;
 strength = getPassStrength(PassStr);
 updatePassStrengthField(t, strength, 0);
}
function smsPassStrength(f, t) {
 var PassStr, strength = 0;
 updatePassStrength(f, t);
}
function convert_to_html_entity(value) {
    var newStr = "";
 var patt=/[a-zA-Z0-9]/
    for ( i = 0; i < value.length; i++ ) {
        var nextChar = value.charAt(i);
  if (patt.test(nextChar))
   newStr = newStr + nextChar;
  else
   newStr = newStr + convertCharToEntity(nextChar);
    }
    return newStr;
}
var bulletHead=convert_to_html_entity("  • ");
function showStrongPasswordInfo() {
 clear_alert();
 var msg="<div class='message_box' style='text-align:left;'>";
 msg+="Passwords configured on the router must meet the following criteria:"+"<br/>";
 msg+=bulletHead+"is at least 8 characters and no more than 128 characters in length."+"<br/>";
 msg+=bulletHead+"contains at least one upper case letter and one number (0-9)."+"<br/>";
 msg+=bulletHead+"contains at least one special character, such as: "+convert_to_html_entity('`~!@#$%^&*()-_=+[{]}\|;:\'\",\<.>/?.')+"<br/>";
 msg+="Additionally, the password must also satisfy an algorithm which analyses the characters as you type them, searching for commonly used patterns, passwords, names and surnames according to US census data, popular English words from Wikipedia and US television and movies and other common patterns such as dates, repeated characters (aaa), sequences (abcd), keyboard patterns (qwertyuiop) and substitution of numbers for letters.";
 msg+="<br/></div><div style='margin-left:180px'><button class='secondary mini' onClick='$.unblockUI();'>"+"OK"+"</button><div/>";
 $.blockUI({message:msg});
 return;
}
function showStrongSmsPasswordInfo() {
 clear_alert();
 var msg="<div class='message_box' style='text-align:left;'>";
 msg+="Passwords configured on the router must meet the following criteria:"+"<br/>";
 msg+=bulletHead+"is at least 8 characters and no more than 128 characters in length."+"<br/>";
 msg+=bulletHead+"contains at least one upper case letter and one number (0-9)."+"<br/>";
 msg+=bulletHead+"Contain at least one of the following special characters: "+ convert_to_html_entity('!*()?/.')+"<br/>";
 msg+="Additionally, the password must also satisfy an algorithm which analyses the characters as you type them, searching for commonly used patterns, passwords, names and surnames according to US census data, popular English words from Wikipedia and US television and movies and other common patterns such as dates, repeated characters (aaa), sequences (abcd), keyboard patterns (qwertyuiop) and substitution of numbers for letters.";
 msg+="<br/></div><div style='margin-left:180px'><button class='secondary mini' onClick='$.unblockUI();'>"+"OK"+"</button><div/>";
 $.blockUI({message:msg});
 return;
}
}
