-- auto generated by luaScriptGen.js.
local rdbPrefix = 'link.profile'
local rdbMembers = 
  {'dev', 'conntype', 'snat', 'iplocal', 'mask', 'gw', 'dns1', 'dns2', 'defaultroutemetric'}
function getWanProfiles(auth)
  -- read upto 16 ethernet network interfaces
  local interfaces = getRdbArray(auth, 'network.interface.eth', 0, 16, false, {'mode'})
  -- read upto 16 ethernet wan profiles, which starts at index 7
  local allProfiles = getRdbArray(auth, rdbPrefix, 7, 23, false, rdbMembers)
  -- build a list of Ethernet WAN interface name
  local wanList={}
  for i=1, #interfaces do
    if interfaces[i].mode == 'wan' then
      table.insert(wanList, 'eth.' .. interfaces[i].id)
    end
  end
  -- select profile that matches interface name in WAN list
  local wanProfiles = {}
  for i=1, #allProfiles do
    if allProfiles[i].dev ~= '' then
      for j=1, #wanList do
        if wanList[j] == allProfiles[i].dev then
          table.insert(wanProfiles, allProfiles[i])
          break
        end
      end
    end
  end
  -- ensure un-used ipv4 members has valid default value
  for i=1, #wanProfiles do
    if wanProfiles[i].conntype == 'dhcp' then
      local ipvars={'iplocal', 'mask', 'gw', 'dns1', 'dns2'}
      for j=1, #ipvars do
        if wanProfiles[i][ipvars[j]] == '' then
          local val = ipvars[j]=='mask' and '255.255.255.255' or '0.0.0.0'
          wanProfiles[i][ipvars[j]] = val
        end
      end
    end
  end
  return wanProfiles
end
objHander = {
  pageURL='/ethwan.html',
  authenticatedOnly=true,
  get=function(authenticated)
    local o
    =getWanProfiles(authenticated)
    return o
  end,
  validate=function(o)
    local v
    v=o.conntype if isValid.Enum(v,{'static','dhcp'})==false then return false,'oops! '..'conntype' end
    v=o.snat if isValid.Bool(v)==false then return false,'oops! '..'snat' end
    v=o.iplocal if isValid.IpAddress(v)==false then return false,'oops! '..'iplocal' end
    v=o.mask if isValid.IpMask(v)==false then return false,'oops! '..'mask' end
    v=o.gw if isValid.IpAddress(v)==false then return false,'oops! '..'gw' end
    v=o.dns1 if isValid.IpAddress(v)==false then return false,'oops! '..'dns1' end
    v=o.dns2 if isValid.IpAddress(v)==false then return false,'oops! '..'dns2' end
    v=o.defaultroutemetric if isValid.BoundedInteger(v,0,65535)==false then return false,'oops! '..'defaultroutemetric' end
    return true
  end,
  set=function(authenticated,o)
    --put the single profile obj into array so we can use setRdbArray to save it.
    local array={objs={o}}
    return setRdbArray(authenticated, rdbPrefix, rdbMembers, array)
  end
}
