 

function isValidIpAddr(ipAddr, flag)
{
    if( flag == undefined )
        flag = 0;
    if ( (flag == 0 && ipAddr == "0.0.0.0") ||
        ipAddr == "255.255.255.255" )
    return false;

    var re = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
    if (re.test(ipAddr)) {
        var parts = ipAddr.split(".");
        if ( flag == 0 && parseInt(parseFloat(parts[0])) == 0) { return false; }
        for (var i=0; i<parts.length; i++) {
            if (parseInt(parseFloat(parts[i])) > 255) { return false; }
        }
        return true;
    } else {
        return false;
    }
}

function ipToNum(ip)
{
    var dummy = ip.split(".");
    var retval = dummy[0], i;
    for(i = 1; i < 4; i++)
	retval = 256 * retval + parseInt(dummy[i]);
    return retval;
}

function isValidDHCPRange(ip, start, end)
{
    var tip = ipToNum(ip);
    var tstart = ipToNum(start);
    var tend = ipToNum(end);

    if ((tip >= tstart && tip <= tend) || (tstart > tend))
	return false;
    return true;
}

function isSameNet(ipAddr1, ipAddr2, mask)
{
    var count = 0;
    
    ip1Part = ipAddr1.split(".");
    ip2Part = ipAddr2.split(".");
    maskPart = mask.split(".");

    for (i = 0; i < 4; i++) {
        ip1Num = parseInt(ip1Part[i]);
        ip2Num = parseInt(ip2Part[i]);
        maskNum = parseInt(maskPart[i]);
        if ((ip1Num & maskNum) == (ip2Num & maskNum))
            count++;
    }
    if (count == 4)
        return true;
    else
        return false;
}

function isValidNetMask(netMask)
{
    var bitZero = false;

    if (netMask == "0.0.0.0")
        return false;

    parts = netMask.split(".");
    if (parts.length != 4) return false;

    for (i=0; i<4; i++) {
        if (isNaN(parts[i]) == true) {
            return false;
        }
        if (parseInt(parseFloat(parts[i])) > 255) {
            return false;
        }
        for (j=0; j<8; j++) {
            if (parseInt(parts[i], 10) & (0x80 >> j)) {
                if (bitZero == true) {
                    return false;
                }
            }
            else {
                bitZero = true;
            }
        }
    }
    return true;
}

function isValidMac(mac)
{
    var macVar0 = /^[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}$/;
    var macVar1 = /^[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2}-[0-9A-Fa-f]{2}$/;
    var macVar2 = /^[0-9A-Fa-f]{12}$/;

    if (macVar0.test(mac)||macVar1.test(mac)||macVar2.test(mac)) {
        return true;
    }
    return false;
}

/*
 * formating Mac Address, ensure check isValidMac() before formatMac()
 */
function formatMac(mac)
{
    if ( -1 != mac.indexOf('-',2)){ // if match '-'
        mac = mac.replace(/\-/g,':');
    }else if ( -1 == mac.indexOf(':',2)){ // if all numgers
        mac = mac.substr(0,2)+":"+mac.substr(2,2)+":"+mac.substr(4,2)+":"+mac.substr(6,2)+":"+mac.substr(8,2)+":"+mac.substr(10,2);
    }
    return mac.toUpperCase();
}

function isValidNumRange(num, min, max)
{ 
   if (isNaN(num)) {return false;}
    else if (num - parseInt(num, 10) != 0) {return false;}
    else if (num < min || num > max) {return false;}

    return true;
}

function isValidWepKey(key, method, keylen)
{
    var len;
    var hexChars = /^[0-9A-Fa-f]{10,32}$/;
    var asciiChars = /^[\x21-\x7e]{5,16}$/;

    if (keylen == "64") {len=40;}
    else if (keylen == "128") {len=104;}
    else if (keylen == "152") {len=128;}
    else {return false;}

    if (method == "ascii") {
        if ( key.length != (len/8)) {
            alert("Invalid key length, it should be " + len/8 + " not " + key.length);
            return false;
        }
        if (!asciiChars.test(key)) {
            alert("Invalid key chars, it should be ASCII code");
            return false;
        }
    }
    else if (method == "hex") {
        if (key.length != (len/4)) {
            alert("Invalid key length, it should be " + len/4 + " not " + key.length);
            return false;
        }
        if (!hexChars.test(key)) {
            alert("Invalid key chars, it should be A-F, a-f, 0-9");
            return false;
        }
    }
    else
        return false;

    return true;
}

function isValidPassPhrase(key, type)
{
    if ( type == "passphrase" ){
        var asciiChars = /^[\x21-\x7e]{8,63}$/;
        if (key.length < 8 || key.length > 63) {
            alert("Invaild Passphrase length, it should be (8-63) chars");
            return false;
        }
        if (!asciiChars.test(key)) {
            alert("Invalid Passphrase characters, it should be ASCII code");
            return false;
        }
    }else{
        var hex = /^[0-9A-Fa-f]{64}$/;
        if ( key.length != 64 ){
            alert("Invaild PSK(Hex) length, it should be 64 characters");
            return false;
        }
        if (!hex.test(key)) {
            alert("Invalid PSK(Hex) characters, it should be 0-9 , a-f");
            return false;
        }
    }
}
 
function isValidPasswd(passwd)
{
    // The bad chars are """, "<", ">", "\", "[", "]", "'", "`", "~"
    var asciiChars = /^[\x21-\x7e]+$/;
    var badChars = /^[^\"\'\<\>\[\]\\\`\~]+$/;

    if(passwd.length == 0) {
        alert("Empty password is not allowed.");
        return false ;
    }
    
    if (!asciiChars.test(passwd)) {
        alert("Illegal characters is contained in password.") ;
        return false; //the char should be on ascii code 33 - 126
    }

    if (!badChars.test(passwd)){
        alert("Password is not allowed to include\n\t \" < > \\ [ ] ' ` ~ ");
        return false; // found bad chars, return false
    }
        return true;
}

function isValidName(name)
{
    var goodChars = /^[\w\#\@\-\_\?\:\*\|\.\s,]+$/;

    if (!goodChars.test(name)) {
        alert("The valid chars are A-Z, a-z, 0-9, space, -, _, *, :, #, @, |, ., ? and comma"); 
        return false; // found bad chars, return false
    }
    else
        return true;
}

function isValidPostfix(name)
{
    var goodChars = /^[\w\-\_\.]+$/;

    if (!goodChars.test(name)) {
        alert("The valid chars are \"A-Z\", \"a-z\", \"0-9\", \"-\", \"_\", \".\"."); 
        return false; // found bad chars, return false
    }
    else
        return true;
}

function MM_preloadImages() { //v3.0
  var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
    var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i<a.length; i++)
    if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
}

function isConfigSync(sync){
    if ( sync == 1 ){
        var msg = document.getElementById('reboot_message');
        msg.style.display = '';
    }else{
        var msg = document.getElementById('reboot_message');
        msg.style.display = 'none';
    }
}

function isValidDomain(domain, type)
{
    var spcchr = "\\(\\)<>@,;:#$`&'../login.asp\"\\.\\[\\]";
    var valchr = "\[^\\s" + spcchr + "\]";
    var regdn1 = new RegExp("^" + valchr + "+(\\." + valchr + "+)+$");
    // var regdn2 = new RegExp("^" + valchr + "+(\\." + valchr + "+)*$");
    // var regdn3 = new RegExp("^[\\.]{0,1}" + valchr + "+(\\." + valchr + "+)*$");
    // var regdn4 = new RegExp("^" + valchr + "+(\\." + valchr + "+)*[\\.]{0,1}$");
    var regdn5 = new RegExp("^[\\.]{0,1}" + valchr + "+(\\." + valchr + "+)*[\\.]{0,1}$");

    if (domain.length >= 256) return false;
    // extended domain style
    if (!regdn5.test(domain)) return false;
    // host
    if (type == "2" || type == "3") {
            if (!regdn1.test(domain)) return false;
	    else
		return true;
    }
    // // domain
    // if (type == "4" || type == "5") {
    // 	if (!regdn2.test(domain)) return false;
    // }
    // // L-extended domain
    // if (type == "6" || type == "7") {
    // 	if (!regdn3.test(domain)) return false;
    // }
    // // R-extended domain
    // if (type == "8" || type == "9") {
    // 	if (!regdn4.test(domain)) return false;
    // }

    // IP Address
    var re = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
    if (re.test(domain)) {
        var parts = domain.split(".");
        if (parseInt(parseFloat(parts[0])) == 0) { return false; }
        for (var i=0; i<parts.length; i++) {
            if (parseInt(parseFloat(parts[i])) > 255) { return false; }
        }
    }
    else
	return false;
    return true;
}

function trim(str) 
{ 
    return str.replace(/^\s+|\s+$/g,""); 
} 

function isValidPort(port)
{
    var re = /^\d{1,5}$/;
    var val=parseInt(port);
    if (re.test(port) && val>=1 && val<=65535)
        return true;
    return false;
}

function getCookie(name) {

     pham = document.cookie;

     name += "="; // append '=' to name string
     var i = 0; // index of first name=value pair
     while (i < pham.length) {
         var offset = i + name.length;

         if (pham.substring(i, offset) == name) { // if string matches
             var endstr = pham.indexOf(";", offset);
             if (endstr == -1)
                        endstr = pham.length;
             return unescape(pham.substring(offset, endstr));
         }
         i = pham.indexOf(" ", i) + 1; // move i to next name=value pair
         if (i == 0) break; // no more values in cookie string
      }

      return null; // cookie not found
}

function SetCookie(cookieName,cookieValue,nDays) {

var today = new Date();
var expire = new Date();

if (nDays==null || nDays==0)
        nDays=1;
expire.setTime(today.getTime() + 3600000*24*nDays);
document.cookie = cookieName+"="+escape(cookieValue)
            + ";expires="+expire.toGMTString();
}


function urlGetValue(var_name)
{
var searchString = document.location.search;
var i;

// strip off the leading '?'
searchString = searchString.substring(1);
var nvPairs = searchString.split("&");

for(i=0; i< nvPairs.length; i++) {
   var nvPair = nvPairs[i].split("=");
   if( nvPair[0] == var_name )
        return nvPair[1];
}

return null;

}

function htmlspecialchars(str) {
	str = str.replace(/&/g, '&amp;');
	str = str.replace(/"/g, '&quot;');
	return str;
}

function Validate_Zero_IP(ip)
{
	part = ip.split("/");

	if ( part[0] == "0.0.0.0" )
		if ( part[1] != "0.0.0.0" )
			return true;


	if ( part[0] != "0.0.0.0" )
		if ( ( part[1] == "0.0.0.0" ) || (part[1] == "0" ) )
			return true;

	return false;
}

function Validate_Segment(ip)
{
    part = ip.split("/");
    if ( part[1] == "255.255.255.255" )
        return false;
    
    return true;
}

function Validate_IP_Segment(ip)
{
	var re  = new RegExp("^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}/[0-9]{1,3}$");
	var re1 = new RegExp("^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})/([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$");
	

	if(re.test(ip))
	{
		part = ip.split(".");
		part1 = part[3].split("/");
		if(part[0] <= 255 && part[1] <=255 && part[2] <= 255 && part1[0] <= 255 && part1[1] <= 32)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	else if(re1.test(ip))
	{
		part = ip.split("/");
		part1 = part[0].split(".");
		part2 = part[1].split(".");
		if(part1[0] <= 255 && part1[1] <=255 && part1[2] <= 255 && part1[3] <= 255 && part2[0] <= 255 && part2[1] <=255 && part2[2] <= 255 && part2[3] <= 255)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	return false;
}

function isValidUserName(name)
{
    var regexp = /^[\w\.-]+$/;

    if (!regexp.test(name)) {
        alert("The valid chars are A-Z, a-z, 0-9, _, - and dot."); 
        return false; // found bad chars, return false
    }
    else
        return true;
}
