// PLEASE NOTE THAT A SPACE BETWEEN TWO WORDS IS TAKEN AS TWO SEPERATE
// WORDS. PLEASE KEEP THIS FILE CONSISTENT.
//
// For each Linux interface name in the boardparms.c file, add
// a corresponding Linux interface name and a user-friendly name
// of its equivalent that must be displayed on the WEB UI. It is
// best if the new inteface names are added at the end.
// Make sure modifications to portName_L are consistent with
//portName_U and viceversa

 portName_L = [
// Wireless interfac Linux interface name
'wl0',
// USB interface Linux interface name
'usb0',
// Board ID 96368VVW Linux name
'96368VVW|eth0',
'96368VVW|eth1',
'96368VVW|eth2',
'96368VVW|eth3',
// Board ID 96368E Linux name
'96368E|eth0',
'96368E|eth1',
'96368E|eth2',
'96368E|eth3',
// Board ID 96368U1027 Linux name
'96368U1027|eth0',
'96368U1027|eth1',
'96368U1027|eth2',
'96368U1027|eth3',
// Board ID 96362ADVNG Linux name
'96362ADVNG|eth0',
'96362ADVNG|eth1',
'96362ADVNG|eth2',
'96362ADVNG|eth3',
'96362ADVNG|eth4',

// Board ID 96328rng Linux name
'96328rng|eth0',
// Board ID 96368R Linux name
'96368R|eth0',

// Board ID 963168_T132A_C Linux name
'963168_T132A_C|eth0',
'963168_T132A_C|eth1',
'963168_T132A_C|eth2',
'963168_T132A_C|eth3',
'963168_T132A_C|eth4',
'963168_T132A_C|eth0(wan)',
'963168_T132A_C|eth1(wan)',
'963168_T132A_C|eth2(wan)',
'963168_T132A_C|eth3(wan)',
'963168_T132A_C|eth4(wan)',
];

var portName_U = [
// Wireless interface user-friendly name
'wl0',
// USB user-friendly name
'USB',
// Board ID 96368VVW user-friendly name
'96368VVW|ENET1',
'96368VVW|ENET2',
'96368VVW|ENET3',
'96368VVW|ENET4',
// Board ID 96368E user-friendly name
'96368E|ENET1',
'96368E|ENET2',
'96368E|ENET3',
'96368E|ENET4',
// Board ID 96368U1027 user-friendly name
'96368U1027|ENET1',
'96368U1027|ENET2',
'96368U1027|ENET3',
'96368U1027|ENET4',
// Board ID 96362ADVNG user-friendly name
'96362ADVNG|ENET1',
'96362ADVNG|ENET2',
'96362ADVNG|ENET3',
'96362ADVNG|ENET4',
'96362ADVNG|ENET5',

// Board ID 96328rng user-friendly name
'96328rng|ENET1',
// Board ID 96368R user-friendly name
'96368R|ENET1',

// Board ID 963168_T132A_C user-friendly name
'963168_T132A_C|LAN1',
'963168_T132A_C|LAN2',
'963168_T132A_C|LAN3',
'963168_T132A_C|LAN4',
'963168_T132A_C|ETHWAN',
'963168_T132A_C|LAN1(wan)',
'963168_T132A_C|LAN2(wan)',
'963168_T132A_C|LAN3(wan)',
'963168_T132A_C|LAN4(wan)',
'963168_T132A_C|ETHWAN',
];

function getUNameByLName(name) {
   var index = 0;
   var uName   = '';

   // SafetyNet if someone sends a name without prefixing the
   // board ID and |, then return that name.
   if (name.indexOf('|') == -1)
      return name;
      
   if (name.indexOf('usb0') != -1) {
      return 'USB';
   }
   for (index = 0; index < portName_L.length; index++) {
      if (portName_L[index] == name) {
         uName = portName_U[index].split('|');
         return uName[1];
      }
   }
   uName = name.split('|');
   return uName[1];
}

function getLNameByUName(name) {
   var index = 0;
   var brdIntf = name.split('|');
   var lName   = '';
   var uName   = '';

   // SafetyNet if someone sends a name without prefixing the
   // board ID and |, then return that name.
   if (name.indexOf('|') == -1)
      return name;
            
   if (name.indexOf('USB') != -1)
      return 'usb0';
   for (index = 0; index < portName_U.length; index++) {
      //uName = portName_U[index].split('|');
      if (portName_U[index] == name) {
         lName = portName_L[index].split('|');
         return lName[1];
      }
   }
   lName = name.split('|');
   return lName[1];
}
